/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.IPropertiesCompositeFactory;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.Messages;
import org.eclipse.bpmn2.modeler.core.validation.LiveValidationListener;
import org.eclipse.bpmn2.modeler.core.validation.ValidationErrorHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class AbstractObjectEditingDialog
extends FormDialog
implements ValidationErrorHandler {
    protected IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    protected DiagramEditor editor;
    protected String title = "";
    protected EObject object;
    protected boolean cancel = false;
    protected boolean abortOnCancel = true;
    protected Transaction transaction;
    protected ScrolledForm form;
    protected Composite dialogContent;
    private Text errorMessageText;
    private IPropertiesCompositeFactory compositeFactory = null;
    public static final String DO_NOT_ADAPT = "do_not_adapt";

    public AbstractObjectEditingDialog(DiagramEditor editor, EObject object) {
        super(editor.getEditorSite().getShell());
        this.setShellStyle(0x10C70 | AbstractObjectEditingDialog.getDefaultOrientation());
        this.editor = editor;
        this.object = object;
    }

    public void setCompositeFactory(IPropertiesCompositeFactory compositeFactory) {
        this.compositeFactory = compositeFactory;
    }

    protected void createFormContent(IManagedForm mform) {
        super.createFormContent(mform);
        this.form = mform.getForm();
        this.form.setExpandHorizontal(true);
        this.form.setExpandVertical(true);
        this.form.setText(null);
        Composite body = this.form.getBody();
        body.setBackground(this.form.getBackground());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        body.setLayoutData((Object)data);
        body.setLayout((Layout)new FormLayout());
        this.dialogContent = this.createDialogContent(body);
        if (this.compositeFactory != null) {
            this.dialogContent.setData("factory", (Object)this.compositeFactory);
        }
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.dialogContent.setLayoutData((Object)data);
        this.form.setContent((Control)body);
        this.getShell().pack();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.errorMessageText = new Text(parent, 2120);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        this.errorMessageText.setForeground(this.errorMessageText.getDisplay().getSystemColor(3));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        return composite;
    }

    protected abstract Composite createDialogContent(Composite var1);

    protected abstract String getPreferenceKey();

    protected String getTitle() {
        return this.title;
    }

    protected void addControlListener() {
        int y;
        int height;
        final String key = this.getPreferenceKey();
        Point p = this.getShell().getSize();
        int width = this.preferenceStore.getInt("dialog." + key + ".width");
        if (width == 0) {
            width = p.x;
        }
        if ((height = this.preferenceStore.getInt("dialog." + key + ".height")) == 0) {
            height = p.y;
        }
        this.getShell().setSize(width, height);
        p = this.getShell().getLocation();
        int x = this.preferenceStore.getInt("dialog." + key + ".x");
        if (x == 0) {
            x = p.x;
        }
        if ((y = this.preferenceStore.getInt("dialog." + key + ".y")) == 0) {
            y = p.y;
        }
        this.getShell().setLocation(x, y);
        this.getShell().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                Point p = AbstractObjectEditingDialog.this.getShell().getLocation();
                AbstractObjectEditingDialog.this.preferenceStore.setValue("dialog." + key + ".x", p.x);
                AbstractObjectEditingDialog.this.preferenceStore.setValue("dialog." + key + ".y", p.y);
            }

            public void controlResized(ControlEvent e) {
                Point p = AbstractObjectEditingDialog.this.getShell().getSize();
                AbstractObjectEditingDialog.this.preferenceStore.setValue("dialog." + key + ".width", p.x);
                AbstractObjectEditingDialog.this.preferenceStore.setValue("dialog." + key + ".height", p.y);
            }
        });
        this.hookTransaction();
    }

    protected void aboutToOpen() {
        this.dialogContent.setData((Object)this.object);
    }

    public void create() {
        super.create();
        this.startTransaction();
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        this.getShell().setText(this.getTitle());
        this.getShell().setSize(600, 400);
        this.addControlListener();
        LiveValidationListener.setValidationErrorHandler(this);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                LiveValidationListener.setValidationErrorHandler(null);
            }
        });
        this.aboutToOpen();
        this.adapt(this.dialogContent);
        return super.open();
    }

    protected void adapt(Composite content) {
        content.setBackground(this.form.getBackground());
        Control[] controlArray = content.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control k = controlArray[n2];
            Object data = k.getData(DO_NOT_ADAPT);
            if (!(data instanceof Boolean) || !((Boolean)data).booleanValue()) {
                k.setBackground(this.form.getBackground());
                if (k instanceof Composite) {
                    this.adapt((Composite)k);
                }
            }
            ++n2;
        }
    }

    public boolean close() {
        if (this.getReturnCode() != 0) {
            this.cancel = true;
        }
        return super.close();
    }

    public boolean isAbortOnCancel() {
        return this.abortOnCancel;
    }

    public void setAbortOnCancel(boolean abort) {
        this.abortOnCancel = abort;
    }

    protected void cancelPressed() {
        this.cancel = true;
        this.dialogContent.dispose();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.cancel = false;
        this.dialogContent.dispose();
        super.okPressed();
    }

    public boolean hasDoneChanges() {
        return this.transaction == null || !this.transaction.getChangeDescription().isEmpty();
    }

    protected void startTransaction() {
        if (this.transaction == null) {
            try {
                InternalTransactionalEditingDomain transactionalDomain = (InternalTransactionalEditingDomain)this.editor.getEditingDomain();
                this.transaction = transactionalDomain.startTransaction(false, null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void hookTransaction() {
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (AbstractObjectEditingDialog.this.transaction != null && AbstractObjectEditingDialog.this.transaction.isActive()) {
                    if (AbstractObjectEditingDialog.this.cancel) {
                        AbstractObjectEditingDialog.this.transaction.rollback();
                    } else {
                        try {
                            AbstractObjectEditingDialog.this.transaction.commit();
                        }
                        catch (RollbackException e) {
                            ErrorDialog.openError((Shell)AbstractObjectEditingDialog.this.getShell(), (String)Messages.AbstractObjectEditingDialog_Commit_Error, (String)Messages.AbstractObjectEditingDialog_Commit_Error_Title, (IStatus)new Status(4, "org.eclipse.bpmn2.modeler.core", e.getMessage(), (Throwable)e));
                        }
                    }
                }
            }
        });
    }

    protected void rollbackTransaction() {
        if (this.transaction != null) {
            this.transaction.rollback();
            this.transaction = null;
        }
    }

    @Override
    public void reportError(IStatus s) {
        String errorMessage;
        String string = errorMessage = s == null ? null : s.getMessage();
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            Button button;
            this.errorMessageText.setText(errorMessage == null ? "" : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            GridData gd = (GridData)this.errorMessageText.getLayoutData();
            boolean bl = gd.exclude = !hasError;
            if (this.dialogArea != null) {
                this.dialogArea.getParent().layout();
            }
            if (s != null && s.getSeverity() >= 4 && (button = this.getButton(0)) != null) {
                button.setEnabled(hasError);
            }
        }
    }
}

