/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.bendpoint;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.BendpointConnectionRouter;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.dd.dc.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveBendpointContext;
import org.eclipse.graphiti.features.impl.DefaultMoveBendpointFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MoveBendpointFeature
extends DefaultMoveBendpointFeature {
    public MoveBendpointFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean moveBendpoint(IMoveBendpointContext context) {
        boolean moved = super.moveBendpoint(context);
        try {
            FreeFormConnection connection = context.getConnection();
            BaseElement element = BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, BaseElement.class);
            BPMNEdge edge = DIUtils.findBPMNEdge((EObject)element);
            if (edge != null) {
                int index = context.getBendpointIndex() + 1;
                Point p = (Point)edge.getWaypoint().get(index);
                p.setX((float)context.getX());
                p.setY((float)context.getY());
                BendpointConnectionRouter.setMovedBendpoint((Connection)connection, context.getBendpointIndex());
                FeatureSupport.updateConnection(this.getFeatureProvider(), (Connection)connection);
            }
        }
        catch (Exception e) {
            Activator.logError(e);
        }
        return moved;
    }
}

