/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.ConnectionRoute;
import org.eclipse.bpmn2.modeler.core.features.DefaultConnectionRouter;
import org.eclipse.bpmn2.modeler.core.utils.AnchorSite;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class BendpointConnectionRouter
extends DefaultConnectionRouter {
    protected FreeFormConnection ffc;
    protected Point movedBendpoint;
    protected Point removedBendpoint;
    protected List<Point> oldPoints;

    public BendpointConnectionRouter(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean route(Connection connection) {
        super.route(connection);
        boolean changed = false;
        if (connection instanceof FreeFormConnection) {
            this.ffc = (FreeFormConnection)connection;
            this.initialize();
            ConnectionRoute route = this.calculateRoute();
            if (route != null) {
                changed = this.isRouteChanged(route);
                this.applyRoute(route);
            }
            this.dispose();
        }
        return changed;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.movedBendpoint = BendpointConnectionRouter.getMovedBendpoint((Connection)this.ffc);
        if (this.movedBendpoint == null) {
            this.movedBendpoint = BendpointConnectionRouter.getAddedBendpoint((Connection)this.ffc);
        }
        this.removedBendpoint = BendpointConnectionRouter.getRemovedBendpoint((Connection)this.ffc);
        this.findAllShapes();
        if (this.movedBendpoint != null) {
            for (ContainerShape shape : this.allShapes) {
                if (!GraphicsUtil.contains((Shape)shape, this.movedBendpoint)) continue;
                this.movedBendpoint = null;
                break;
            }
        }
        this.oldPoints = new ArrayList<Point>();
        this.oldPoints.add(GraphicsUtil.createPoint(this.ffc.getStart()));
        for (Point p : this.ffc.getBendpoints()) {
            this.oldPoints.add(GraphicsUtil.createPoint(p));
        }
        this.oldPoints.add(GraphicsUtil.createPoint(this.ffc.getEnd()));
        this.calculateAllowedAnchorSites();
    }

    protected ConnectionRoute calculateRoute() {
        if (this.isSelfConnection()) {
            return this.calculateSelfConnectionRoute();
        }
        ConnectionRoute route = new ConnectionRoute(this, 1, this.source, this.target);
        AnchorUtil.moveAnchor(this.sourceAnchor, GraphicsUtil.getShapeCenter((AnchorContainer)this.target));
        AnchorUtil.moveAnchor(this.targetAnchor, GraphicsUtil.getShapeCenter((AnchorContainer)this.source));
        Point start = GraphicsUtil.createPoint((Anchor)this.sourceAnchor);
        Point end = GraphicsUtil.createPoint((Anchor)this.targetAnchor);
        route.add(start);
        int i = 1;
        while (i < this.oldPoints.size() - 1) {
            route.add(this.oldPoints.get(i));
            ++i;
        }
        route.add(end);
        this.oldPoints.clear();
        return route;
    }

    protected ConnectionRoute calculateSelfConnectionRoute() {
        if (!this.isSelfConnection()) {
            return null;
        }
        if (this.movedBendpoint == null && this.ffc.getStart() != this.ffc.getEnd() && this.ffc.getBendpoints().size() > 0 && !BendpointConnectionRouter.forceRouting((Connection)this.ffc)) {
            return null;
        }
        ILocation loc = peService.getLocationRelativeToDiagram(this.target);
        IDimension size = GraphicsUtil.calculateSize((PictogramElement)this.target);
        Point p = Graphiti.getCreateService().createPoint(loc.getX() + size.getWidth() / 2, loc.getY());
        FixPointAnchor topAnchor = (FixPointAnchor)this.ffc.getEnd();
        AnchorUtil.moveAnchor(topAnchor, p);
        p = Graphiti.getCreateService().createPoint(loc.getX() + size.getWidth(), loc.getY() + size.getHeight() / 2);
        FixPointAnchor rightAnchor = (FixPointAnchor)this.ffc.getStart();
        AnchorUtil.moveAnchor(rightAnchor, p);
        Point right = GraphicsUtil.createPoint((Anchor)rightAnchor);
        right.setX(right.getX() + 20);
        Point top = GraphicsUtil.createPoint((Anchor)topAnchor);
        top.setY(top.getY() - 20);
        Point corner = Graphiti.getCreateService().createPoint(right.getX(), top.getY());
        p = this.movedBendpoint;
        if (p != null) {
            int x = p.getX();
            int y = p.getY();
            if (x > loc.getX() + size.getWidth() + 2) {
                right.setX(x);
                corner.setX(x);
            }
            if (y < loc.getY() - 2) {
                top.setY(y);
                corner.setY(y);
            }
        }
        ConnectionRoute route = new ConnectionRoute(this, 1, this.source, this.target);
        route.add(GraphicsUtil.createPoint((Anchor)rightAnchor));
        route.add(right);
        route.add(corner);
        route.add(top);
        route.add(GraphicsUtil.createPoint((Anchor)topAnchor));
        return route;
    }

    protected boolean isRouteChanged(ConnectionRoute route) {
        if (route == null || route.size() == 0) {
            return false;
        }
        if (this.oldPoints.size() != route.size()) {
            return true;
        }
        int i = 0;
        while (i < this.oldPoints.size()) {
            Point p2;
            Point p1 = this.oldPoints.get(i);
            if (!GraphicsUtil.pointsEqual(p1, p2 = route.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void applyRoute(ConnectionRoute route) {
        route.apply(this.ffc, this.sourceAnchor, this.targetAnchor);
        DIUtils.updateDIEdge((Connection)this.ffc);
    }

    protected AnchorSite getNextAnchorSite(AnchorSite site) {
        switch (site) {
            case BOTTOM: {
                return AnchorSite.LEFT;
            }
            case LEFT: {
                return AnchorSite.RIGHT;
            }
            case RIGHT: {
                return AnchorSite.TOP;
            }
            case TOP: {
                return AnchorSite.BOTTOM;
            }
            case CENTER: {
                return AnchorSite.CENTER;
            }
        }
        return site;
    }

    public static void setMovedBendpoint(Connection connection, int index) {
        BendpointConnectionRouter.setInterestingBendpoint(connection, "moved.", index);
    }

    public static void setAddedBendpoint(Connection connection, int index) {
        BendpointConnectionRouter.setInterestingBendpoint(connection, "added.", index);
    }

    public static void setRemovedBendpoint(Connection connection, int index) {
        BendpointConnectionRouter.setInterestingBendpoint(connection, "removed.", index);
    }

    public static void setFixedBendpoint(Connection connection, int index) {
        BendpointConnectionRouter.setInterestingBendpoint(connection, "fixed." + index + ".", index);
    }

    protected static void setInterestingBendpoint(Connection connection, String type, int index) {
        if (connection instanceof FreeFormConnection) {
            int size = ((FreeFormConnection)connection).getBendpoints().size();
            if (index >= 0 && size > 0) {
                if (index >= size) {
                    index = size - 1;
                }
                AbstractConnectionRouter.setRoutingInfoInt(connection, String.valueOf(type) + "bendpoint", index);
            } else {
                AbstractConnectionRouter.removeRoutingInfo(connection, String.valueOf(type) + "bendpoint");
            }
        }
    }

    public static Point getMovedBendpoint(Connection connection) {
        return BendpointConnectionRouter.getInterestingBendpoint(connection, "moved.");
    }

    public static Point getAddedBendpoint(Connection connection) {
        return BendpointConnectionRouter.getInterestingBendpoint(connection, "added.");
    }

    public static Point getRemovedBendpoint(Connection connection) {
        return BendpointConnectionRouter.getInterestingBendpoint(connection, "removed.");
    }

    public static Point getFixedBendpoint(Connection connection, int index) {
        return BendpointConnectionRouter.getInterestingBendpoint(connection, "fixed." + index + ".");
    }

    protected static Point getInterestingBendpoint(Connection connection, String type) {
        try {
            int index = AbstractConnectionRouter.getRoutingInfoInt(connection, String.valueOf(type) + "bendpoint");
            return (Point)((FreeFormConnection)connection).getBendpoints().get(index);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

