/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core;

import java.lang.reflect.Field;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.IToolTipProvider;
import org.eclipse.bpmn2.modeler.core.utils.JavaReflectionUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;

public class ToolTipProvider
extends NLS
implements IToolTipProvider {
    public static final ToolTipProvider INSTANCE = new ToolTipProvider();

    @Override
    public String getToolTip(Object context, EObject object) {
        return this.getUIText(context, object, "tooltip");
    }

    @Override
    public String getLongDescription(Object context, EObject object) {
        return this.getUIText(context, object, "description");
    }

    @Override
    public String getToolTip(Object context, EObject object, EStructuralFeature feature) {
        return this.getUIText(context, object, feature, "tooltip");
    }

    @Override
    public String getLongDescription(Object context, EObject object, EStructuralFeature feature) {
        return this.getUIText(context, object, feature, "description");
    }

    private String getUIText(Object context, EObject object, String type) {
        Participant participant;
        EObject container;
        String name = "";
        String description = "";
        if (object instanceof BPMNDiagram) {
            switch (ModelUtil.getDiagramType(object)) {
                case NONE: {
                    name = "UnknownDiagram";
                    break;
                }
                case PROCESS: {
                    name = "Process";
                    break;
                }
                case CHOREOGRAPHY: {
                    name = "Choreography";
                    break;
                }
                case COLLABORATION: {
                    name = "Collaboration";
                    break;
                }
                case CONVERSATION: {
                    name = "Conversation";
                    break;
                }
            }
        } else if (object instanceof Participant && (container = (participant = (Participant)object).eContainer()) instanceof Choreography) {
            for (FlowElement fe : ((Choreography)container).getFlowElements()) {
                ChoreographyActivity ca;
                if (!(fe instanceof ChoreographyActivity) || !(ca = (ChoreographyActivity)fe).getParticipantRefs().contains(participant)) continue;
                name = "ParticipantBand";
                break;
            }
        }
        try {
            if (name.isEmpty()) {
                description = this.getUIText(context, object, null, type);
            } else {
                String fieldName = "UI_" + name + "_" + type;
                Class messages = JavaReflectionUtil.findClass(context, "Messages");
                Field field = messages.getField(fieldName);
                description = (String)field.get(null);
            }
        }
        catch (Exception exception) {
            description = this.getUIText(context, object, null, type);
        }
        return description;
    }

    private String getUIText(Object context, EObject object, EStructuralFeature feature, String type) {
        String description = "";
        Class<?> messages = JavaReflectionUtil.findClass(context, "Messages");
        if (messages != null) {
            ClassLoader classLoader = messages.getClassLoader();
            boolean found = false;
            block6: do {
                int index;
                Field field;
                String fieldName;
                try {
                    EClass eClass = object instanceof EClass ? (EClass)object : object.eClass();
                    String className = eClass.getName().replaceAll("Impl$", "");
                    fieldName = feature == null ? "UI_" + className + "_" + type : "UI_" + className + "_" + feature.getName() + "_" + type;
                    field = messages.getField(fieldName);
                    description = String.valueOf(description) + (String)field.get(null);
                    found = true;
                }
                catch (Exception exception) {
                    try {
                        if (feature != null) {
                            fieldName = "UI_Any_" + feature.getName() + "_" + type;
                            field = messages.getField(fieldName);
                            description = String.valueOf(description) + (String)field.get(null);
                            found = true;
                        }
                    }
                    catch (Exception exception2) {}
                }
                if (found) continue;
                String packageName = messages.getPackage().getName();
                messages = null;
                while ((index = packageName.lastIndexOf(".")) != -1) {
                    packageName = packageName.substring(0, index);
                    String className = String.valueOf(packageName) + ".Messages";
                    try {
                        messages = Class.forName(className, true, classLoader);
                        continue block6;
                    }
                    catch (Exception exception) {}
                }
            } while (!found && messages != null);
        }
        return description;
    }
}

