/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xml.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.designer.metamodels.xml.BuildStatus;
import org.teiid.designer.metamodels.xml.ProcessingInstruction;
import org.teiid.designer.metamodels.xml.XmlAll;
import org.teiid.designer.metamodels.xml.XmlAttribute;
import org.teiid.designer.metamodels.xml.XmlBuildable;
import org.teiid.designer.metamodels.xml.XmlChoice;
import org.teiid.designer.metamodels.xml.XmlComment;
import org.teiid.designer.metamodels.xml.XmlContainerNode;
import org.teiid.designer.metamodels.xml.XmlDocumentEntity;
import org.teiid.designer.metamodels.xml.XmlDocumentNode;
import org.teiid.designer.metamodels.xml.XmlDocumentPlugin;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.XmlFragment;
import org.teiid.designer.metamodels.xml.XmlNamespace;
import org.teiid.designer.metamodels.xml.XmlSequence;

public class XmlDocumentUtil {
    public static final int XSD_OCCURRENCE_NONE = 0;
    public static final int XSD_OCCURRENCE_N = 1;
    public static final int XSD_OCCURRENCE_NToM = 2;
    public static final int XSD_OCCURRENCE_NToUnbounded = 3;
    public static final int XSD_OCCURRENCE_One = 4;
    public static final int XSD_OCCURRENCE_OneToN = 5;
    public static final int XSD_OCCURRENCE_OneToUnbounded = 6;
    public static final int XSD_OCCURRENCE_Zero = 7;
    public static final int XSD_OCCURRENCE_ZeroToN = 8;
    public static final int XSD_OCCURRENCE_ZeroToOne = 9;
    public static final int XSD_OCCURRENCE_ZeroToUnbounded = 10;
    private static final String ANY_TYPE = "anyType";

    private XmlDocumentUtil() {
    }

    public static String createXmlPrefixFromUri(String uri) {
        if (uri == null) {
            return "";
        }
        if (uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/2000/10/XMLSchema") || uri.equals("http://www.w3.org/1999/XMLSchema")) {
            return "xs";
        }
        if (uri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            return "xsi";
        }
        int index = uri.lastIndexOf("/");
        if (index == -1) {
            index = uri.lastIndexOf("\\");
        }
        index = index == -1 ? 0 : ++index;
        String name = uri.substring(index).replace(':', '_');
        int i2 = name.lastIndexOf(".");
        if (i2 == -1) {
            return name;
        }
        return name.substring(0, i2);
    }

    public static String getPathInDocument(XmlDocumentEntity entity) {
        String path = null;
        while (entity != null) {
            String segment = null;
            if (entity instanceof XmlFragment) break;
            if (entity instanceof XmlNamespace) {
                XmlNamespace namespace = (XmlNamespace)entity;
                segment = "@xmlns:" + namespace.getPrefix();
            } else if (entity instanceof XmlElement) {
                XmlElement element = (XmlElement)entity;
                segment = element.getName();
            } else if (entity instanceof XmlAttribute) {
                XmlAttribute attribute = (XmlAttribute)entity;
                segment = "@" + attribute.getName();
            } else if (entity instanceof XmlContainerNode) {
                if (entity instanceof XmlSequence) {
                    segment = XmlDocumentPlugin.Util.getString("_UI_XmlSequence_type", new Object[0]);
                } else if (entity instanceof XmlChoice) {
                    segment = XmlDocumentPlugin.Util.getString("_UI_XmlChoice_type", new Object[0]);
                } else if (entity instanceof XmlAll) {
                    segment = XmlDocumentPlugin.Util.getString("_UI_XmlAll_type", new Object[0]);
                }
            } else if (entity instanceof XmlComment) {
                XmlComment comment = (XmlComment)entity;
                String text = comment.getText();
                segment = "<!-- ";
                if (text != null) {
                    segment = String.valueOf(segment) + text;
                }
                if ((segment = String.valueOf(segment) + " -->").length() > 21) {
                    segment = String.valueOf(segment.substring(0, 20)) + "... -->";
                }
            } else if (entity instanceof ProcessingInstruction) {
                ProcessingInstruction instructions = (ProcessingInstruction)entity;
                String target = instructions.getTarget();
                String rawText = instructions.getRawText();
                segment = "<?";
                if (target != null && target.trim().length() != 0) {
                    segment = String.valueOf(segment) + target;
                }
                if (rawText != null && rawText.trim().length() != 0) {
                    segment = String.valueOf(segment) + " " + rawText;
                }
                if ((segment = String.valueOf(segment) + " ?>").length() > 21) {
                    segment = String.valueOf(segment.substring(0, 20)) + "... ?>";
                }
            }
            if (segment == null) {
                segment = "";
            }
            path = path == null ? segment : String.valueOf(segment) + "/" + path;
            entity = (XmlDocumentEntity)entity.eContainer();
        }
        if (path == null) {
            return "/";
        }
        return "/" + path;
    }

    public static String getXPath(XmlDocumentEntity entity) {
        String path = null;
        while (entity != null) {
            String segment = null;
            if (entity instanceof XmlFragment) break;
            if (entity instanceof XmlNamespace) {
                XmlNamespace namespace = (XmlNamespace)entity;
                segment = "@xmlns:" + namespace.getPrefix();
            } else if (entity instanceof XmlElement) {
                XmlElement element = (XmlElement)entity;
                segment = element.getName();
            } else if (entity instanceof XmlAttribute) {
                XmlAttribute attribute = (XmlAttribute)entity;
                segment = "@" + attribute.getName();
            } else {
                if (entity instanceof XmlContainerNode) {
                    entity = (XmlDocumentEntity)entity.eContainer();
                    continue;
                }
                if (entity instanceof XmlComment) {
                    entity = (XmlDocumentEntity)entity.eContainer();
                    continue;
                }
                if (entity instanceof ProcessingInstruction) {
                    entity = (XmlDocumentEntity)entity.eContainer();
                    continue;
                }
            }
            if (segment == null) {
                segment = "";
            }
            path = path == null ? segment : String.valueOf(segment) + "/" + path;
            entity = (XmlDocumentEntity)entity.eContainer();
        }
        if (path == null) {
            return "/";
        }
        return "/" + path;
    }

    public static boolean hasComplexType(Object object) {
        if (object instanceof XmlDocumentNode) {
            XmlDocumentNode dnode = (XmlDocumentNode)object;
            XSDComponent xcomp = dnode.getXsdComponent();
            XSDTypeDefinition xtype = XmlDocumentUtil.findXSDType(xcomp);
            return xtype instanceof XSDComplexTypeDefinition;
        }
        return false;
    }

    public static boolean isAnyType(EObject obj) {
        return obj instanceof XSDTypeDefinition && ANY_TYPE.equals(((XSDTypeDefinition)obj).getName());
    }

    public static XSDTypeDefinition findXSDType(Object node) {
        if (node instanceof XmlDocumentNode) {
            XmlDocumentNode docNode = (XmlDocumentNode)node;
            return XmlDocumentUtil.findXSDType(docNode.getXsdComponent());
        }
        return null;
    }

    public static XSDTypeDefinition findXSDType(XSDComponent schemaComponent) {
        if (schemaComponent instanceof XSDElementDeclaration) {
            XSDElementDeclaration ref = ((XSDElementDeclaration)schemaComponent).getResolvedElementDeclaration();
            return ref == null ? null : ref.getType();
        }
        if (schemaComponent instanceof XSDTypeDefinition) {
            XSDDerivationMethod der;
            if (schemaComponent instanceof XSDComplexTypeDefinition && (der = ((XSDComplexTypeDefinition)schemaComponent).getDerivationMethod()) != null && der.getValue() == 1) {
                return null;
            }
            XSDTypeDefinition baseType = ((XSDTypeDefinition)schemaComponent).getBaseType();
            if (baseType == null || baseType == schemaComponent || XmlDocumentUtil.isAnyType((EObject)baseType)) {
                return null;
            }
            return baseType;
        }
        if (schemaComponent instanceof XSDFeature) {
            return ((XSDFeature)schemaComponent).getType();
        }
        return null;
    }

    public static boolean isExcluded(Object element, boolean checkHierarchy) {
        if (element instanceof XmlDocumentEntity) {
            if (element instanceof XmlElement) {
                XmlElement e = (XmlElement)element;
                return e.isExcludeFromDocument() || checkHierarchy && XmlDocumentUtil.isExcluded(e.getParent(), checkHierarchy);
            }
            if (element instanceof XmlContainerNode) {
                XmlContainerNode e = (XmlContainerNode)element;
                return e.isExcludeFromDocument() || checkHierarchy && XmlDocumentUtil.isExcluded(e.getParent(), checkHierarchy);
            }
            if (element instanceof XmlAttribute) {
                XmlAttribute e = (XmlAttribute)element;
                return e.isExcludeFromDocument() || checkHierarchy && XmlDocumentUtil.isExcluded(e.getElement(), checkHierarchy);
            }
            if (element instanceof XmlComment) {
                XmlComment e = (XmlComment)element;
                return checkHierarchy && XmlDocumentUtil.isExcluded(e.getParent(), checkHierarchy);
            }
            if (element instanceof XmlNamespace) {
                XmlNamespace e = (XmlNamespace)element;
                return checkHierarchy && XmlDocumentUtil.isExcluded(e.getElement(), checkHierarchy);
            }
            if (element instanceof ProcessingInstruction) {
                ProcessingInstruction e = (ProcessingInstruction)element;
                return checkHierarchy && XmlDocumentUtil.isExcluded(e.getParent(), checkHierarchy);
            }
        }
        return false;
    }

    public static void setExcluded(Object element, boolean exclude) {
        if (element instanceof XmlDocumentNode) {
            XmlDocumentNode xe = (XmlDocumentNode)element;
            xe.setExcludeFromDocument(exclude);
        } else if (element instanceof XmlContainerNode) {
            XmlContainerNode xcn = (XmlContainerNode)element;
            xcn.setExcludeFromDocument(exclude);
        }
    }

    public static boolean isRecursive(Object element) {
        if (element instanceof XmlElement) {
            XmlElement xe = (XmlElement)element;
            return xe.isRecursive();
        }
        return false;
    }

    public static void setRecursive(Object element, boolean recurse) {
        if (element instanceof XmlElement) {
            XmlElement xe = (XmlElement)element;
            xe.setRecursive(recurse);
        }
    }

    public static boolean isIncomplete(Object element) {
        if (element instanceof XmlBuildable) {
            XmlBuildable xb = (XmlBuildable)element;
            return xb.getBuildState() == BuildStatus.INCOMPLETE_LITERAL;
        }
        return false;
    }

    public static void setIncomplete(Object element, boolean stopped) {
        if (element instanceof XmlBuildable) {
            XmlBuildable xb = (XmlBuildable)element;
            BuildStatus bs = stopped ? BuildStatus.INCOMPLETE_LITERAL : BuildStatus.COMPLETE_LITERAL;
            xb.setBuildState(bs);
        }
    }

    public static boolean hasElementChildren(XmlDocumentEntity node) {
        for (XmlDocumentEntity kid : node.eContents()) {
            if (!(kid instanceof XmlElement)) continue;
            return true;
        }
        return false;
    }

    public static int getCardinality(Object element) {
        if (element instanceof XmlDocumentNode) {
            int min = ((XmlDocumentNode)element).getMinOccurs();
            int max = ((XmlDocumentNode)element).getMaxOccurs();
            if (min == 0) {
                if (min == max) {
                    return 7;
                }
                if (max == 1) {
                    return 9;
                }
                if (max == -1) {
                    return 10;
                }
                if (max > min) {
                    return 8;
                }
            } else if (min == 1) {
                if (min == max) {
                    return 4;
                }
                if (max == -1) {
                    return 6;
                }
                if (max > min) {
                    return 5;
                }
            } else if (min > 1) {
                if (min == max) {
                    return 1;
                }
                if (max == -1) {
                    return 3;
                }
                if (max > min) {
                    return 2;
                }
            }
        }
        return 0;
    }

    public static void setAllExcluded(XmlDocumentEntity element, boolean excluded) {
        EList l = element.eContents();
        for (XmlDocumentEntity node : l) {
            XmlDocumentUtil.setAllExcluded(node, excluded);
        }
        XmlDocumentUtil.setExcluded(element, excluded);
    }
}

