/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.wizard;

import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.UiConstants;
import org.teiid.designer.teiidimporter.ui.wizard.TeiidImportManager;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public class SelectTargetPage
extends AbstractWizardPage
implements UiConstants {
    private static final String EMPTY_STR = "";
    private static final String SERVER_PREFIX = "Default Server: ";
    private TeiidImportManager importManager;
    private Text targetModelContainerText;
    private Text targetModelFileText;
    private Text targetModelInfoText;
    private Button createConnProfileCB;
    private Button showVdbXMLButton;
    final ViewerFilter sourceModelFilter = new ModelWorkspaceViewerFilter(true){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean doSelect = false;
            if (element instanceof IResource) {
                boolean projectOpen = ((IResource)element).getProject().isOpen();
                if (projectOpen) {
                    if (element instanceof IProject) {
                        try {
                            doSelect = ((IProject)element).hasNature("org.teiid.designer.core.modelNature");
                        }
                        catch (CoreException e) {
                            UTIL.log((Throwable)e);
                        }
                    } else if (element instanceof IContainer) {
                        doSelect = true;
                    } else if (element instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)element))) {
                        ModelResource theModel = null;
                        try {
                            theModel = ModelUtil.getModelResource((IFile)((IFile)element), (boolean)true);
                        }
                        catch (Exception ex) {
                            ModelerCore.Util.log((Throwable)ex);
                        }
                        if (theModel != null && ModelIdentifier.isRelationalSourceModel((ModelResource)theModel)) {
                            doSelect = true;
                        }
                    }
                }
            } else if (element instanceof IContainer) {
                doSelect = true;
            }
            return doSelect;
        }
    };

    public SelectTargetPage(TeiidImportManager importManager) {
        super(SelectTargetPage.class.getSimpleName(), Messages.SelectTargetPage_title);
        this.importManager = importManager;
    }

    public void createControl(Composite theParent) {
        String serverString;
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4, (int)768);
        pnl.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)pnl);
        Label serverNameLabel = new Label(pnl, 0);
        try {
            serverString = this.importManager.getDisplayName();
        }
        catch (Exception exception) {
            serverString = "Unknown";
        }
        serverNameLabel.setText(SERVER_PREFIX + serverString);
        serverNameLabel.setForeground(Display.getCurrent().getSystemColor(10));
        Font bannerFont = JFaceResources.getBannerFont();
        serverNameLabel.setFont(bannerFont);
        this.createTargetModelGroup(pnl);
        this.showVdbXMLButton = new Button(pnl, 8);
        this.showVdbXMLButton.setText(Messages.ShowVdbXmlAction_text);
        this.showVdbXMLButton.setToolTipText(Messages.ShowVdbXmlAction_tooltip);
        this.showVdbXMLButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShowVdbXmlDialog dialog = new ShowVdbXmlDialog(SelectTargetPage.this.getShell(), SelectTargetPage.this.importManager.getDynamicVdbString());
                dialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.validatePage();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.importManager.getTargetModelLocation() != null) {
                this.targetModelContainerText.setText(this.importManager.getTargetModelLocation().makeRelative().toString());
            }
            this.validatePage();
            this.getControl().setVisible(visible);
        } else {
            super.setVisible(visible);
        }
    }

    private void createTargetModelGroup(Composite parent) {
        new Label(parent, 0);
        Group sourceGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.SelectTargetPage_TgtModelDefnGroup, (int)0, (int)1, (int)3);
        sourceGroup.setLayoutData((Object)new GridData(768));
        Label locationLabel = new Label((Composite)sourceGroup, 0);
        locationLabel.setText(Messages.SelectTargetPage_Location);
        this.targetModelContainerText = new Text((Composite)sourceGroup, 2052);
        String targetContainerText = null;
        if (this.importManager.getTargetModelLocation() != null) {
            targetContainerText = this.importManager.getTargetModelLocation().toOSString();
        }
        if (targetContainerText != null) {
            this.targetModelContainerText.setText(targetContainerText);
        }
        GridData gridData = new GridData(768);
        this.targetModelContainerText.setLayoutData((Object)gridData);
        this.targetModelContainerText.setBackground(Display.getCurrent().getSystemColor(19));
        this.targetModelContainerText.setEditable(false);
        Button browseButton = new Button((Composite)sourceGroup, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(Messages.SelectTargetPage_Browse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectTargetPage.this.handleTargetModelLocationBrowse();
            }
        });
        Label fileLabel = new Label((Composite)sourceGroup, 0);
        fileLabel.setText(Messages.SelectTargetPage_Name);
        this.targetModelFileText = new Text((Composite)sourceGroup, 2052);
        gridData = new GridData(768);
        this.targetModelFileText.setLayoutData((Object)gridData);
        this.targetModelFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectTargetPage.this.handleTargetModelTextChanged();
            }
        });
        new Label((Composite)sourceGroup, 0);
        new Label((Composite)sourceGroup, 0);
        Group infoGroup = WidgetFactory.createGroup((Composite)sourceGroup, (String)Messages.SelectTargetPage_ModelStatus, (int)2, (int)2);
        infoGroup.setLayoutData((Object)new GridData(768));
        this.targetModelInfoText = new Text((Composite)infoGroup, 72);
        this.setTargetModelInfoText();
        this.targetModelInfoText.setBackground(Display.getCurrent().getSystemColor(19));
        this.targetModelInfoText.setForeground(Display.getCurrent().getSystemColor(10));
        GridData gd = new GridData(768);
        gd.heightHint = 35;
        gd.horizontalSpan = 3;
        this.targetModelInfoText.setLayoutData((Object)gd);
        this.createConnProfileCB = WidgetFactory.createCheckBox((Composite)sourceGroup, (String)Messages.SelectTargetPage_CreateConnectionProfileCB_Label, (int)0, (int)3);
        this.createConnProfileCB.setToolTipText(Messages.SelectTargetPage_CreateConnectionProfileCB_Label);
        this.createConnProfileCB.setSelection(true);
    }

    void handleTargetModelLocationBrowse() {
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)ModelerCore.getWorkspace().getRoot(), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.targetModelContainerText != null) {
            this.importManager.setTargetModelLocation(folder.getFullPath().makeRelative());
            this.targetModelContainerText.setText(this.importManager.getTargetModelLocation().makeRelative().toString());
        } else {
            this.importManager.setTargetModelLocation((IPath)new Path(EMPTY_STR));
            this.targetModelContainerText.setText(EMPTY_STR);
        }
        this.validatePage();
    }

    void handleTargetModelTextChanged() {
        String mdlText = this.targetModelFileText.getText();
        if (!CoreStringUtil.isEmpty((String)mdlText) && !this.matchingModelOfWrongTypeExists(mdlText)) {
            this.importManager.setTargetModelName(this.targetModelFileText.getText());
        }
        this.validatePage();
    }

    private boolean matchingModelOfWrongTypeExists(String modelName) {
        IResource modelResource;
        IPath modelLocation = this.importManager.getTargetModelLocation();
        if (modelLocation == null) {
            return false;
        }
        IWorkspaceRoot root = ModelerCore.getWorkspace().getRoot();
        IResource containerResource = root.findMember(modelLocation);
        if (containerResource == null || !(containerResource instanceof IContainer)) {
            return false;
        }
        IContainer container = (IContainer)containerResource;
        if (!container.exists()) {
            return false;
        }
        IPath modelPath = container.getFullPath().append(modelName);
        if (!modelName.endsWith(".xmi")) {
            modelPath = modelPath.addFileExtension(".xmi".substring(1));
        }
        if ((modelResource = root.findMember(modelPath)) == null || !ModelUtil.isModelFile((IResource)modelResource)) {
            return false;
        }
        return !"http://www.metamatrix.com/metamodels/Relational".equals(ModelUtil.getXmiHeader((IResource)modelResource).getPrimaryMetamodelURI());
    }

    private boolean validatePage() {
        boolean modelSelectionValid = this.validateTargetModelSelection();
        if (!modelSelectionValid) {
            return false;
        }
        this.setThisPageComplete(EMPTY_STR, 0);
        return true;
    }

    private boolean validateTargetModelSelection() {
        this.setTargetModelInfoText();
        Collection openModelProjects = DotProjectUtils.getOpenModelProjects();
        if (openModelProjects.size() == 0) {
            this.setThisPageComplete(Messages.SelectTargetPage_NoOpenProjMsg, 3);
            return false;
        }
        String container = this.targetModelContainerText.getText();
        if (CoreStringUtil.isEmpty((String)container)) {
            this.setThisPageComplete(Messages.SelectTargetPage_SrcLocationNotSpecified, 3);
            return false;
        }
        IProject project = this.getTargetProject();
        if (project == null) {
            this.setThisPageComplete(Messages.SelectTargetPage_SrcLocationNotSpecified, 3);
            return false;
        }
        String fileText = this.targetModelFileText.getText().trim();
        IStatus status = ModelNameUtil.validate((String)fileText, (String)".xmi", null, (int)1);
        if (status.getSeverity() == 4) {
            this.setThisPageComplete(String.valueOf(ModelNameUtil.MESSAGES.INVALID_MODEL_NAME) + status.getMessage(), 3);
            return false;
        }
        if (this.importManager.targetModelExists()) {
            this.setThisPageComplete(Messages.bind((String)Messages.SelectTargetPage_ModelExistsWithThisNameMsg, (Object)fileText), 3);
            return false;
        }
        return true;
    }

    private void setThisPageComplete(String message, int severity) {
        WizardUtil.setPageComplete((WizardPage)this, (String)message, (int)severity);
    }

    private IProject getTargetProject() {
        IWorkspaceRoot root;
        IResource resource;
        IProject result = null;
        String containerName = this.getTargetContainerName();
        if (!CoreStringUtil.isEmpty((String)containerName) && (resource = (root = ModelerCore.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource.getProject();
        }
        return result;
    }

    private String getTargetContainerName() {
        String result = null;
        result = ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric() ? this.getHiddenProjectPath() : this.targetModelContainerText.getText().trim();
        return result;
    }

    private String getHiddenProjectPath() {
        String result = null;
        IProject hiddenProj = ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject(false);
        if (hiddenProj != null) {
            result = hiddenProj.getFullPath().makeRelative().toString();
        }
        return result;
    }

    private void setTargetModelInfoText() {
        String targetModelName = this.targetModelFileText.getText();
        if (targetModelName == null || targetModelName.trim().length() == 0) {
            this.targetModelInfoText.setText(Messages.SelectTargetPage_SrcModelUndefined);
        } else {
            this.targetModelInfoText.setText(String.valueOf(Messages.SelectTargetPage_SrcModelSelected) + ": " + targetModelName);
        }
    }

    public boolean isCreateConnectionProfile() {
        boolean isChecked = false;
        if (this.createConnProfileCB != null) {
            isChecked = this.createConnProfileCB.getSelection();
        }
        return isChecked;
    }

    class ShowVdbXmlDialog
    extends Dialog {
        private StyledTextEditor textEditor;
        private String theXmlText;

        public ShowVdbXmlDialog(Shell shell, String theXmlText) {
            super(shell, Messages.ShowVdbXmlDialog_title);
            this.theXmlText = theXmlText;
        }

        protected Control createDialogArea(Composite parent) {
            Composite dlgPanel = (Composite)super.createDialogArea(parent);
            Group descGroup = WidgetFactory.createGroup((Composite)dlgPanel, (String)Messages.ShowVdbXmlDialog_dynamic_vdb_text, (int)0);
            descGroup.setLayoutData((Object)new GridData(1808));
            Composite innerPanel = new Composite((Composite)descGroup, 0);
            innerPanel.setLayout((Layout)new GridLayout());
            GridData pgd = new GridData(1808);
            pgd.minimumWidth = 400;
            pgd.minimumHeight = 400;
            pgd.grabExcessVerticalSpace = true;
            pgd.grabExcessHorizontalSpace = true;
            innerPanel.setLayoutData((Object)pgd);
            this.textEditor = new StyledTextEditor(innerPanel, 2818);
            GridData gdt = new GridData(1808);
            gdt.widthHint = 400;
            gdt.heightHint = 400;
            this.textEditor.setLayoutData((Object)gdt);
            this.textEditor.setEditable(false);
            this.textEditor.setAllowFind(false);
            this.textEditor.getTextWidget().setWordWrap(false);
            this.textEditor.setText(this.theXmlText);
            return dlgPanel;
        }

        protected Control createContents(Composite parent) {
            Control superControl = super.createContents(parent);
            this.getButton(0).setEnabled(true);
            return superControl;
        }
    }
}

