/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.tree;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IFrom;
import org.teiid.designer.query.sql.lang.IQueryCommand;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.query.ui.UiConstants;
import org.teiid.query.ui.tree.QueryTreeContentProvider;
import org.teiid.query.ui.tree.QueryTreeLabelProvider;

public class QueryTreeSelectionDialog
extends ElementTreeSelectionDialog
implements UiConstants {
    private static final String UNIONALL_CHECKBOX_TEXT = Util.getString("QueryTreeSelectionDialog.unionAllCheckbox.text", new Object[0]);
    private static final String UNIONALL_CHECKBOX_TIP = Util.getString("QueryTreeSelectionDialog.unionAllCheckbox.toolTip", new Object[0]);
    private ICommand root;
    private Button unionAllCheckbox;
    private boolean unionAll = false;

    public QueryTreeSelectionDialog(Shell parent, ICommand root) {
        super(parent, (ILabelProvider)new QueryTreeLabelProvider(), (ITreeContentProvider)QueryTreeContentProvider.getInstance());
        this.root = root;
        this.init();
    }

    public QueryTreeSelectionDialog(Shell parent, ICommand root, ILabelProvider labelProvider) {
        super(parent, (ILabelProvider)new QueryTreeLabelProvider(labelProvider), (ITreeContentProvider)QueryTreeContentProvider.getInstance());
        this.root = root;
        this.init();
    }

    private void init() {
        ArrayList<ICommand> inputList = new ArrayList<ICommand>(1);
        inputList.add(this.root);
        this.setInput(inputList);
        this.setAllowMultiple(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite overallComposite = new Composite(parent, 0);
        overallComposite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        overallComposite.setLayoutData((Object)gridData);
        super.createDialogArea(overallComposite);
        this.unionAllCheckbox = WidgetFactory.createCheckBox((Composite)overallComposite, (String)UNIONALL_CHECKBOX_TEXT);
        this.unionAllCheckbox.setToolTipText(UNIONALL_CHECKBOX_TIP);
        this.unionAllCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                QueryTreeSelectionDialog.this.updateUnionAll();
            }
        });
        return overallComposite;
    }

    void setUnionAllCheckbox(int indx) {
        if (this.root != null && this.root instanceof ISetQuery) {
            ISetQuery union = (ISetQuery)this.root;
            this.unionAllCheckbox.setSelection(union.isAll());
            this.unionAll = union.isAll();
        }
    }

    void updateUnionAll() {
        this.unionAll = this.unionAllCheckbox.getSelection();
    }

    public void addViewerFilter(ViewerFilter filter) {
        super.getTreeViewer().addFilter(filter);
    }

    public int getSelectedUnionSegmentIndex() {
        Object[] results;
        int index = -1;
        if (this.root instanceof ISetQuery && (results = this.getResult()).length == 1 && results[0] instanceof ICommand) {
            Object[] children = QueryTreeContentProvider.getInstance().getChildren(this.root);
            int i = 0;
            while (i < children.length) {
                if (children[i].equals(results[0])) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    public boolean unionQuerySegmentSelected() {
        int index = this.getSelectedUnionSegmentIndex();
        return index != -1;
    }

    public boolean unionQueryFromClauseSelected() {
        Object[] results;
        boolean fromSelected = false;
        if (this.root instanceof ISetQuery && (results = this.getResult()).length == 1 && results[0] instanceof IFrom) {
            fromSelected = true;
        }
        return fromSelected;
    }

    public int getUnionQuerySegmentIndexForFromClause() {
        Object[] results;
        int segmentIndex = -1;
        if (this.root instanceof ISetQuery && (results = this.getResult()).length == 1 && results[0] instanceof IFrom) {
            Object[] children = QueryTreeContentProvider.getInstance().getChildren(this.root);
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IQueryCommand) {
                    Object[] queryChildren = QueryTreeContentProvider.getInstance().getChildren(children[i]);
                    int iClause = 0;
                    while (iClause < queryChildren.length) {
                        if (queryChildren[iClause] instanceof IFrom && queryChildren[iClause].equals(results[0])) {
                            segmentIndex = i;
                            break;
                        }
                        ++iClause;
                    }
                }
                ++i;
            }
        }
        return segmentIndex;
    }

    public void setInitialUnionSelection(int selectedUnionIndex) {
        Object[] children = QueryTreeContentProvider.getInstance().getChildren(this.root);
        ArrayList<Object> selectedChild = new ArrayList<Object>(1);
        selectedChild.add(children[selectedUnionIndex]);
        this.setInitialElementSelections(selectedChild);
    }

    public boolean isUnionAllSelected() {
        return this.unionAll;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer result = super.createTreeViewer(parent);
        result.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).isOpen();
                }
                return true;
            }
        });
        result.expandAll();
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (QueryTreeSelectionDialog.this.unionQuerySegmentSelected()) {
                    int indx = QueryTreeSelectionDialog.this.getSelectedUnionSegmentIndex();
                    QueryTreeSelectionDialog.this.setUnionAllCheckbox(indx);
                }
            }
        });
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }
}

