/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.tree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.query.SetQueryUtil;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.IValueIteratorProviderCollectorVisitor;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.IFrom;
import org.teiid.designer.query.sql.lang.IFromClause;
import org.teiid.designer.query.sql.lang.IJoinPredicate;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.query.sql.lang.ISubqueryContainer;
import org.teiid.designer.query.sql.lang.ISubqueryFromClause;
import org.teiid.designer.query.sql.lang.IUnaryFromClause;

public class QueryTreeContentProvider
implements ITreeContentProvider {
    public static QueryTreeContentProvider instance = null;

    public static QueryTreeContentProvider getInstance() {
        if (instance == null) {
            instance = new QueryTreeContentProvider();
        }
        return instance;
    }

    private QueryTreeContentProvider() {
    }

    public Object[] getChildren(Object obj) {
        if (obj instanceof ISetQuery) {
            return SetQueryUtil.getQueryList((ISetQuery)((ISetQuery)obj)).toArray();
        }
        if (obj instanceof IQuery) {
            if (((IQuery)obj).getCriteria() == null) {
                return new Object[]{((IQuery)obj).getFrom()};
            }
            return new Object[]{((IQuery)obj).getFrom(), ((IQuery)obj).getCriteria()};
        }
        if (obj instanceof IFrom) {
            List clauses = ((IFrom)obj).getClauses();
            ArrayList<Object> children = new ArrayList<Object>(clauses.size());
            for (IFromClause clause : clauses) {
                if (clause instanceof IUnaryFromClause) {
                    children.add(((IUnaryFromClause)clause).getGroup());
                    continue;
                }
                children.add(clause);
            }
            return children.toArray();
        }
        if (obj instanceof IFromClause) {
            if (obj instanceof IUnaryFromClause) {
                return new Object[0];
            }
            if (obj instanceof IJoinPredicate) {
                return new Object[]{((IJoinPredicate)obj).getLeftClause(), ((IJoinPredicate)obj).getRightClause()};
            }
            if (obj instanceof ISubqueryFromClause) {
                return new Object[0];
            }
        } else if (obj instanceof ICriteria) {
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            IValueIteratorProviderCollectorVisitor visitor = queryService.getValueIteratorProviderCollectorVisitor();
            List containers = visitor.findValueIteratorProviders((ILanguageObject)((ICriteria)obj));
            ArrayList<ICommand> commands = new ArrayList<ICommand>();
            for (ISubqueryContainer container : containers) {
                commands.add(container.getCommand());
            }
            return commands.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length != 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ArrayList) {
            return ((ArrayList)inputElement).toArray();
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

