/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.runtime.spi.ExecutionConfigurationEvent;
import org.teiid.designer.runtime.spi.IExecutionConfigurationListener;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.udf.IFunctionForm;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.designer.udf.UdfManager;
import org.teiid.query.ui.UiConstants;

public class SqlSyntax {
    IExecutionConfigurationListener configurationListener = new IExecutionConfigurationListener(){

        public void configurationChanged(ExecutionConfigurationEvent event) {
        }
    };
    private List<String> RESERVED_WORDS = new ArrayList<String>();
    private List<String> FUNCTION_NAMES = new ArrayList<String>();
    private List<String> DATATYPE_NAMES = new ArrayList<String>();
    private List<String> ALL_WORDS = new ArrayList<String>();
    private List<String> RESERVED_WORD_START_CHARS = new ArrayList<String>();
    private List<String> FUNCTION_NAME_START_CHARS = new ArrayList<String>();
    private List<String> DATATYPE_NAME_START_CHARS = new ArrayList<String>();
    private List<String> ALL_WORD_START_CHARS = new ArrayList<String>();

    public SqlSyntax() {
        this.init();
    }

    private void init() {
        IQueryService sqlSyntaxService = ModelerCore.getTeiidQueryService();
        IDataTypeManagerService dataTypeManagerService = ModelerCore.getTeiidDataTypeManagerService();
        try {
            String start;
            for (String reservedWord : sqlSyntaxService.getReservedWords()) {
                this.RESERVED_WORDS.add(reservedWord);
                start = reservedWord.substring(0, 1);
                if (this.RESERVED_WORD_START_CHARS.contains(start)) continue;
                this.RESERVED_WORD_START_CHARS.add(start);
            }
            for (String reservedWord : sqlSyntaxService.getNonReservedWords()) {
                this.RESERVED_WORDS.add(reservedWord);
                start = reservedWord.substring(0, 1);
                if (this.RESERVED_WORD_START_CHARS.contains(start)) continue;
                this.RESERVED_WORD_START_CHARS.add(start);
            }
            Collections.sort(this.RESERVED_WORDS);
        }
        catch (Exception e) {
            UiConstants.Util.log((Throwable)e);
        }
        HashSet<String> allFunctionNames = new HashSet<String>();
        try {
            IFunctionLibrary functionLib = UdfManager.getInstance().getSystemFunctionLibrary();
            List allCategories = functionLib.getFunctionCategories();
            for (String category : allCategories) {
                for (IFunctionForm fForm : functionLib.getFunctionForms(category)) {
                    String fName = fForm.getName();
                    allFunctionNames.add(fName);
                    String start = fName.substring(0, 1);
                    if (this.FUNCTION_NAME_START_CHARS.contains(start)) continue;
                    this.FUNCTION_NAME_START_CHARS.add(start);
                }
            }
            this.FUNCTION_NAMES.addAll(allFunctionNames);
            Collections.sort(this.FUNCTION_NAMES);
        }
        catch (Exception e) {
            UiConstants.Util.log((Throwable)e);
        }
        Set dataTypes = new HashSet();
        try {
            dataTypes = dataTypeManagerService.getAllDataTypeNames();
            for (String dtypeName : dataTypes) {
                this.DATATYPE_NAMES.add(dtypeName);
                String start = dtypeName.substring(0, 1);
                if (this.DATATYPE_NAME_START_CHARS.contains(start)) continue;
                this.DATATYPE_NAME_START_CHARS.add(start);
            }
            Collections.sort(this.DATATYPE_NAMES);
        }
        catch (Exception e) {
            UiConstants.Util.log((Throwable)e);
        }
        HashSet<String> allWords = new HashSet<String>();
        allWords.addAll(this.RESERVED_WORDS);
        allWords.addAll(allFunctionNames);
        allWords.addAll(dataTypes);
        this.ALL_WORDS.addAll(allWords);
        Collections.sort(this.ALL_WORDS);
        HashSet<String> allStartStrs = new HashSet<String>();
        allStartStrs.addAll(this.RESERVED_WORD_START_CHARS);
        allStartStrs.addAll(this.FUNCTION_NAME_START_CHARS);
        allStartStrs.addAll(this.DATATYPE_NAME_START_CHARS);
        this.ALL_WORD_START_CHARS.addAll(allStartStrs);
    }

    public boolean isSqlWordStart(char c) {
        for (String charStr : this.ALL_WORD_START_CHARS) {
            char start;
            if (charStr == null || c != (start = charStr.charAt(0))) continue;
            return true;
        }
        return false;
    }

    public boolean isSqlWordPart(char c) {
        boolean isUnderscore;
        boolean isLetter = Character.isLetter(c);
        boolean isDigit = Character.isDigit(c);
        boolean bl = isUnderscore = c == '_';
        return isLetter || isDigit || isUnderscore;
    }

    public List<String> getReservedWords() {
        return Collections.unmodifiableList(this.RESERVED_WORDS);
    }

    public List<String> getDataTypeNames() {
        return Collections.unmodifiableList(this.DATATYPE_NAMES);
    }

    public List<String> getFunctionNames() {
        return Collections.unmodifiableList(this.FUNCTION_NAMES);
    }

    public List<String> getAllWords() {
        return Collections.unmodifiableList(this.ALL_WORDS);
    }
}

