/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.html.Option;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.ICommandCollectorVisitor;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.IDelete;
import org.teiid.designer.query.sql.lang.IExistsCriteria;
import org.teiid.designer.query.sql.lang.IFrom;
import org.teiid.designer.query.sql.lang.IGroupBy;
import org.teiid.designer.query.sql.lang.IInsert;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IOrderBy;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.query.sql.lang.ISelect;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.query.sql.lang.IStoredProcedure;
import org.teiid.designer.query.sql.lang.ISubqueryCompareCriteria;
import org.teiid.designer.query.sql.lang.ISubqueryFromClause;
import org.teiid.designer.query.sql.lang.ISubquerySetCriteria;
import org.teiid.designer.query.sql.lang.IUpdate;
import org.teiid.designer.query.sql.proc.ICommandStatement;
import org.teiid.designer.query.sql.proc.ICreateProcedureCommand;
import org.teiid.designer.query.sql.symbol.IScalarSubquery;
import org.teiid.query.ui.sqleditor.component.DisplayNode;
import org.teiid.query.ui.sqleditor.component.FromDisplayNode;
import org.teiid.query.ui.sqleditor.component.HavingDisplayNode;
import org.teiid.query.ui.sqleditor.component.QueryDisplayComponent;
import org.teiid.query.ui.sqleditor.component.SelectDisplayNode;
import org.teiid.query.ui.sqleditor.component.WhereDisplayNode;

public class SqlIndexLocator {
    public static final int UNKNOWN = -1;
    public static final int QUERY = 10;
    public static final int SET_QUERY = 12;
    public static final int SELECT = 20;
    public static final int FROM = 21;
    public static final int WHERE = 22;
    public static final int SUBQUERY_FROM_CLAUSE = 23;
    public static final int SCALAR_SUBQUERY = 24;
    public static final int CRITERIA = 30;
    public static final int EXISTS_CRITERIA = 31;
    public static final int HAS_CRITERIA = 32;
    public static final int SUBQUERY_COMPARE_CRITERIA = 33;
    public static final int SUBQUERY_SET_CRITERIA = 34;
    public static final int GROUP_BY = 40;
    public static final int ORDER_BY = 41;
    public static final int HAVING = 42;
    public static final int OPTION = 43;
    public static final int UPDATE = 50;
    public static final int INSERT = 51;
    public static final int DELETE = 52;
    public static final int STORED_PROCEDURE = 53;
    public static final int CREATE_UPDATE_PROCEDURE = 54;
    public static final int COMMAND_STATEMENT = 60;
    private static final int TYPE_UNKNOWN = -1;
    private static final int TYPE_QUERY = 0;
    private static final int TYPE_UNION = 2;
    private static final int TYPE_QUERY_IN_CRITERIA = 3;
    private static final int TYPE_QUERY_IN_UNION = 4;
    private static final int TYPE_QUERY_IN_COMMAND = 5;
    private int currentIndex = 0;
    private int primaryNodeType = -1;
    private int primaryLanguageObjectType = -1;
    private QueryDisplayComponent displayComponent;
    private DisplayNode commandDisplayNode;
    private DisplayNode primaryIndexDisplayNode;
    private ILanguageObject primaryLanguageObject;
    private boolean subQuerySelected = false;
    private boolean selectScopeSelected = false;
    private boolean whereSelected = false;

    public SqlIndexLocator(QueryDisplayComponent displayComponent, int index) {
        this.displayComponent = displayComponent;
        this.init(index);
    }

    public boolean isSubQuerySelected() {
        return this.subQuerySelected;
    }

    public boolean isUnionSegmentSelected() {
        return this.primaryLanguageObjectType == 4;
    }

    public boolean isCriteriaQuerySelected() {
        return this.primaryLanguageObjectType == 3 || this.getDisplayNodeType(this.primaryIndexDisplayNode) == 22;
    }

    public boolean isCommandQuerySelected() {
        return this.primaryLanguageObjectType == 5;
    }

    public boolean hasSubQueries() {
        if (this.primaryLanguageObject != null && this.primaryLanguageObject instanceof IQuery) {
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            ICommandCollectorVisitor commandCollectorVisitor = queryService.getCommandCollectorVisitor();
            List subCommands = commandCollectorVisitor.findCommands((ICommand)((IQuery)this.primaryLanguageObject));
            return !subCommands.isEmpty();
        }
        return false;
    }

    private void init(int index) {
        this.currentIndex = index < 0 ? 0 : index;
        this.commandDisplayNode = this.displayComponent.getCommandDisplayNodeAtIndex(this.currentIndex);
        if (this.commandDisplayNode == null) {
            this.commandDisplayNode = this.displayComponent.getDisplayNode();
        }
        this.primaryLanguageObject = this.commandDisplayNode.getLanguageObject();
        this.setPrimaryIndexDisplayNode();
        this.setPrimaryLanguageObjectType();
        this.selectScopeSelected = this.isIndexInSelectScope();
        this.subQuerySelected = this.isSubQueryNode(this.commandDisplayNode);
        this.whereSelected = this.isIndexInWhere();
    }

    private void setPrimaryLanguageObjectType() {
        if (this.primaryLanguageObject != null) {
            DisplayNode parentNode;
            this.primaryLanguageObjectType = this.primaryLanguageObject instanceof IQuery ? ((parentNode = this.commandDisplayNode.getParent()) != null && this.getDisplayNodeType(parentNode) == 31 ? 3 : (parentNode != null && this.getDisplayNodeType(parentNode) == 12 ? 4 : (parentNode != null && this.getDisplayNodeType(parentNode) == 60 ? 5 : 0))) : (this.primaryLanguageObject instanceof ISetQuery ? ((parentNode = this.commandDisplayNode.getParent()) != null && this.getDisplayNodeType(parentNode) == 31 ? 3 : (parentNode != null && this.getDisplayNodeType(parentNode) == 12 ? 4 : (parentNode != null && this.getDisplayNodeType(parentNode) == 23 ? 4 : 2))) : -1);
        }
    }

    private void setPrimaryIndexDisplayNode() {
        int lastEndIndex = -1;
        DisplayNode lastNode = null;
        if (this.commandDisplayNode != null) {
            List<DisplayNode> displayNodes = this.commandDisplayNode.getChildren();
            lastNode = this.commandDisplayNode;
            for (DisplayNode node : displayNodes) {
                lastEndIndex = node.endIndex;
                if (this.currentIndex >= node.startIndex && this.currentIndex <= node.endIndex) {
                    this.primaryIndexDisplayNode = node;
                    this.setPrimaryIndexNodeType();
                    break;
                }
                if (this.currentIndex < lastEndIndex) {
                    this.primaryIndexDisplayNode = lastNode;
                    this.setPrimaryIndexNodeType();
                }
                lastNode = node;
            }
            if (this.primaryIndexDisplayNode == null) {
                this.primaryIndexDisplayNode = lastNode;
                this.setPrimaryIndexNodeType();
            }
        }
    }

    private void setPrimaryIndexNodeType() {
        this.primaryNodeType = this.getDisplayNodeType(this.primaryIndexDisplayNode);
    }

    public int getDisplayNodeType(DisplayNode node) {
        if (node == null) {
            return -1;
        }
        if (node.languageObject instanceof ISelect) {
            return 20;
        }
        if (node.languageObject instanceof IFrom) {
            return 21;
        }
        if (node instanceof WhereDisplayNode) {
            return 22;
        }
        if (node.languageObject instanceof IGroupBy) {
            return 40;
        }
        if (node instanceof HavingDisplayNode) {
            return 42;
        }
        if (node.languageObject instanceof IOrderBy) {
            return 41;
        }
        if (node.languageObject instanceof Option) {
            return 43;
        }
        if (node.languageObject instanceof IQuery) {
            return 10;
        }
        if (node.languageObject instanceof ISetQuery) {
            return 12;
        }
        if (node.languageObject instanceof IUpdate) {
            return 50;
        }
        if (node.languageObject instanceof IInsert) {
            return 51;
        }
        if (node.languageObject instanceof IDelete) {
            return 52;
        }
        if (node.languageObject instanceof IStoredProcedure) {
            return 53;
        }
        if (node.languageObject instanceof ICreateProcedureCommand) {
            return 54;
        }
        if (node.languageObject instanceof IExistsCriteria) {
            return 31;
        }
        if (node.languageObject instanceof ISubqueryFromClause) {
            return 23;
        }
        if (node.languageObject instanceof IScalarSubquery) {
            return 24;
        }
        if (node.languageObject instanceof ISubqueryCompareCriteria) {
            return 33;
        }
        if (node.languageObject instanceof ISubquerySetCriteria) {
            return 34;
        }
        if (node.languageObject instanceof ICriteria) {
            return 30;
        }
        if (node.languageObject instanceof ICommandStatement) {
            return 60;
        }
        return -1;
    }

    public ILanguageObject getPrimaryLanguageObject() {
        return this.primaryLanguageObject;
    }

    public int getPrimaryNodeType() {
        return this.primaryNodeType;
    }

    public boolean isSubQueryNode(DisplayNode node) {
        DisplayNode parentNode;
        int nodeType = this.getDisplayNodeType(node);
        if ((nodeType == 10 || nodeType == 12) && (parentNode = node.getParent()) != null) {
            int parentType = this.getDisplayNodeType(parentNode);
            if (parentType == 23) {
                return true;
            }
            if (parentType == 12 && this.primaryLanguageObjectType == 4 && (parentNode = parentNode.getParent()) != null && this.getDisplayNodeType(parentNode) == 23) {
                return true;
            }
        }
        return false;
    }

    public int getIndexForDisplayNode(DisplayNode parentNode, DisplayNode targetNode) {
        if (targetNode.getParent() != null && !parentNode.getChildren().isEmpty()) {
            Iterator<DisplayNode> iter = parentNode.getChildren().iterator();
            DisplayNode nextNode = null;
            while (iter.hasNext()) {
                nextNode = iter.next();
                if (nextNode.equals(targetNode)) {
                    return nextNode.startIndex;
                }
                int tmpIndex = this.getIndexForDisplayNode(nextNode, targetNode);
                if (tmpIndex <= -1) continue;
                return tmpIndex;
            }
        }
        return -1;
    }

    public DisplayNode getTopDisplayNode() {
        DisplayNode parentNode = this.commandDisplayNode;
        while (parentNode.getParent() != null) {
            parentNode = parentNode.getParent();
        }
        return parentNode;
    }

    public DisplayNode getCommandDisplayNode() {
        return this.commandDisplayNode;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public boolean isIndexInSelectScope() {
        if (this.primaryIndexDisplayNode instanceof SelectDisplayNode || this.primaryIndexDisplayNode instanceof FromDisplayNode) {
            return true;
        }
        int startSelectIndex = -1;
        int endFromIndex = -1;
        List<DisplayNode> displayNodes = this.primaryIndexDisplayNode.getChildren();
        for (DisplayNode node : displayNodes) {
            boolean inNode;
            if (node.languageObject instanceof ISelect) {
                startSelectIndex = node.startIndex;
            }
            if (node.languageObject instanceof IFrom) {
                endFromIndex = node.endIndex + 1;
            }
            int correctedIndex = this.getCurrentIndex() - this.getCommandDisplayNode().getStartIndex();
            if (node instanceof WhereDisplayNode && (inNode = this.isIndexInSelectScope(node, correctedIndex))) {
                return true;
            }
            if (node.languageObject instanceof IExistsCriteria) {
                inNode = false;
                for (DisplayNode nextNode : node.getChildren()) {
                    inNode = this.isIndexInSelectScope(nextNode, this.currentIndex);
                    if (!inNode) continue;
                    return true;
                }
            }
            if (startSelectIndex <= -1 || endFromIndex <= -1) continue;
            return this.currentIndex >= startSelectIndex && this.currentIndex <= endFromIndex;
        }
        return false;
    }

    private boolean isIndexInSelectScope(DisplayNode displayNode, int index) {
        if (displayNode != null) {
            if (displayNode.languageObject instanceof ISelect || displayNode.languageObject instanceof IFrom) {
                return true;
            }
            int startSelectIndex = -1;
            int endFromIndex = -1;
            List<DisplayNode> displayNodes = displayNode.getChildren();
            for (DisplayNode node : displayNodes) {
                boolean inNode;
                if (node.languageObject instanceof ISelect) {
                    startSelectIndex = node.startIndex;
                }
                if (node.languageObject instanceof IFrom) {
                    endFromIndex = node.endIndex + 1;
                }
                if ((node instanceof WhereDisplayNode || node.languageObject instanceof IExistsCriteria || node.languageObject instanceof IQuery) && (inNode = this.isIndexInSelectScope(node, index))) {
                    return true;
                }
                if (startSelectIndex <= -1 || endFromIndex <= -1 || index < startSelectIndex || index > endFromIndex) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isIndexInWhere() {
        if (this.primaryIndexDisplayNode instanceof WhereDisplayNode) {
            return true;
        }
        List<DisplayNode> displayNodes = this.primaryIndexDisplayNode.getChildren();
        for (DisplayNode node : displayNodes) {
            int correctedIndex = this.getCurrentIndex() - this.getCommandDisplayNode().getStartIndex();
            if (!(node instanceof WhereDisplayNode) || correctedIndex < node.startIndex || correctedIndex > node.endIndex) continue;
            return true;
        }
        return false;
    }

    public boolean isWhereSelected() {
        return this.whereSelected;
    }

    public boolean isSelectScopeSelected() {
        return this.selectScopeSelected;
    }

    public DisplayNode getSelectedSelectQuery() {
        if (this.primaryIndexDisplayNode.languageObject instanceof ISelect || this.primaryIndexDisplayNode.languageObject instanceof IFrom) {
            return this.primaryIndexDisplayNode.getParent();
        }
        int startSelectIndex = -1;
        int endFromIndex = -1;
        List<DisplayNode> displayNodes = this.primaryIndexDisplayNode.getChildren();
        for (DisplayNode node : displayNodes) {
            DisplayNode selectNode;
            if (node instanceof SelectDisplayNode) {
                startSelectIndex = node.startIndex;
            }
            if (node.languageObject instanceof IFrom) {
                endFromIndex = node.endIndex + 1;
            }
            int correctedIndex = this.getCurrentIndex() - this.getCommandDisplayNode().getStartIndex();
            if (node instanceof WhereDisplayNode && (selectNode = this.getSelectedSelectQuery(node, correctedIndex)) != null) {
                return selectNode;
            }
            if (node.languageObject instanceof IExistsCriteria) {
                for (DisplayNode nextNode : node.getChildren()) {
                    DisplayNode selectNode2 = this.getSelectedSelectQuery(nextNode, this.currentIndex);
                    if (selectNode2 == null) continue;
                    return selectNode2;
                }
            }
            if (startSelectIndex <= -1 || endFromIndex <= -1) continue;
            if (this.currentIndex >= startSelectIndex && this.currentIndex <= endFromIndex) {
                return node.getParent();
            }
            return null;
        }
        return null;
    }

    private DisplayNode getSelectedSelectQuery(DisplayNode displayNode, int index) {
        if (displayNode != null) {
            if (displayNode.languageObject instanceof ISelect || displayNode.languageObject instanceof IFrom) {
                return displayNode.getParent();
            }
            int startSelectIndex = -1;
            int endFromIndex = -1;
            List<DisplayNode> displayNodes = displayNode.getChildren();
            for (DisplayNode node : displayNodes) {
                DisplayNode selectNode;
                if (node.languageObject instanceof ISelect) {
                    startSelectIndex = node.startIndex;
                }
                if (node.languageObject instanceof IFrom) {
                    endFromIndex = node.endIndex + 1;
                }
                if ((node instanceof WhereDisplayNode || node.languageObject instanceof IExistsCriteria || node.languageObject instanceof IQuery) && (selectNode = this.getSelectedSelectQuery(node, index)) != null) {
                    return selectNode;
                }
                if (startSelectIndex <= -1 || endFromIndex <= -1 || this.currentIndex < startSelectIndex || this.currentIndex > endFromIndex) continue;
                return node.getParent();
            }
        }
        return null;
    }

    public List collectCriteriaParentQueries(boolean useSelectQuery) {
        if (this.isCriteriaQuerySelected()) {
            DisplayNode startingNode = null;
            startingNode = useSelectQuery ? this.getSelectedSelectQuery() : this.primaryIndexDisplayNode;
            ArrayList<DisplayNode> parentQueries = new ArrayList<DisplayNode>();
            parentQueries.add(startingNode);
            boolean foundUnexpectedParent = false;
            boolean shouldFindCriteria = false;
            boolean foundExpectedCriteria = true;
            DisplayNode parentNode = startingNode.getParent();
            while (!foundUnexpectedParent && foundExpectedCriteria) {
                if (parentNode == null) {
                    foundUnexpectedParent = true;
                    continue;
                }
                if (shouldFindCriteria && !(parentNode.languageObject instanceof IExistsCriteria)) {
                    foundExpectedCriteria = false;
                }
                if (foundExpectedCriteria) {
                    shouldFindCriteria = false;
                    if (parentNode.languageObject instanceof IQuery) {
                        parentQueries.add(parentNode);
                        if (parentNode.getParent() != null && !(parentNode.getParent().languageObject instanceof ISubqueryFromClause)) {
                            shouldFindCriteria = true;
                        }
                    } else if (!(parentNode.languageObject instanceof IFrom || parentNode.languageObject instanceof ISelect || parentNode.languageObject instanceof IExistsCriteria || parentNode instanceof WhereDisplayNode || parentNode.languageObject instanceof ISubqueryFromClause)) {
                        foundUnexpectedParent = true;
                    }
                }
                parentNode = parentNode.getParent();
            }
            return parentQueries;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isSelectedNodeContainedWithinType(int type) {
        DisplayNode parentNode = this.primaryIndexDisplayNode;
        while (parentNode != null) {
            if (this.getDisplayNodeType(parentNode) == type) {
                return true;
            }
            parentNode = parentNode.getParent();
        }
        return false;
    }

    public DisplayNode getExistsCriteriaWhereNode(DisplayNode node) {
        DisplayNode queryNode;
        DisplayNode whereNode = node.getParent();
        if (whereNode != null && this.getDisplayNodeType(whereNode) == 22 && (queryNode = whereNode.getParent()) != null && queryNode.languageObject instanceof IQuery) {
            return queryNode;
        }
        return null;
    }
}

