/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational.util;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.runtime.CoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcManager;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.relational.ModelerJdbcRelationalConstants;
import org.teiid.designer.metamodels.core.ModelType;

public class JdbcRelationalUtil
implements ModelerJdbcRelationalConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(JdbcRelationalUtil.class);
    private static final String ESCAPE_CHARACTER = "\"";
    private static JdbcManager mgr;

    public static Connection connect(JdbcSource source, String password) throws CoreException, JdbcException, SQLException {
        CoreArgCheck.isNotNull((Object)source);
        return JdbcRelationalUtil.getJdbcManager().createConnection(source, password);
    }

    public static String escapeDatabaseObjectName(String name) {
        if (Character.isDigit(name.charAt(0)) || name.indexOf(32) >= 0) {
            if (!name.startsWith(ESCAPE_CHARACTER)) {
                name = ESCAPE_CHARACTER + name;
            }
            if (!name.endsWith(ESCAPE_CHARACTER)) {
                name = String.valueOf(name) + ESCAPE_CHARACTER;
            }
        }
        return name;
    }

    public static JdbcManager getJdbcManager() {
        return JdbcPlugin.getJdbcManager();
    }

    public static ModelResource getPhysicalModifiableRelationalModel(Object object) throws ModelWorkspaceException {
        ModelResource model = JdbcRelationalUtil.getRelationalModel(object);
        if (model != null && model.getModelType().getValue() == ModelType.PHYSICAL) {
            return model;
        }
        return null;
    }

    public static ModelResource getRelationalModel(Object object) throws ModelWorkspaceException {
        ModelResource model = ModelUtil.getModel((Object)object);
        if (model != null && "http://www.metamatrix.com/metamodels/Relational".equals(model.getPrimaryMetamodelDescriptor().getNamespaceURI())) {
            return model;
        }
        return null;
    }

    private static String getString(String id) {
        return ModelerJdbcRelationalConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private JdbcRelationalUtil() {
    }
}

