/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.mapping.Mapping;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.Stopwatch;
import org.teiid.designer.compare.DifferenceDescriptor;
import org.teiid.designer.compare.DifferenceProcessor;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.compare.MergeProcessor;
import org.teiid.designer.compare.ModelerComparePlugin;
import org.teiid.designer.compare.PropertyDifference;
import org.teiid.designer.compare.util.CompareUtil;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.TransactionRunnable;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.resource.xmi.MtkXmiResourceImpl;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.jdbc.CaseConversion;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcImportSettings;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.SourceNames;
import org.teiid.designer.jdbc.data.Request;
import org.teiid.designer.jdbc.data.Results;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcProcedure;
import org.teiid.designer.jdbc.metadata.JdbcTable;
import org.teiid.designer.jdbc.metadata.JdbcTableType;
import org.teiid.designer.jdbc.metadata.impl.GetColumnsRequest;
import org.teiid.designer.jdbc.metadata.impl.GetExportedForeignKeysRequest;
import org.teiid.designer.jdbc.metadata.impl.GetImportedForeignKeysRequest;
import org.teiid.designer.jdbc.metadata.impl.GetIndexesRequest;
import org.teiid.designer.jdbc.metadata.impl.GetPrimaryKeyRequest;
import org.teiid.designer.jdbc.metadata.impl.GetProcedureParametersRequest;
import org.teiid.designer.jdbc.relational.ContextImpl;
import org.teiid.designer.jdbc.relational.CostAnalyzer;
import org.teiid.designer.jdbc.relational.CostAnalyzerFactory;
import org.teiid.designer.jdbc.relational.JdbcRelationalPlugin;
import org.teiid.designer.jdbc.relational.ModelerJdbcRelationalConstants;
import org.teiid.designer.jdbc.relational.RelationalModelProcessor;
import org.teiid.designer.jdbc.relational.impl.Context;
import org.teiid.designer.jdbc.relational.impl.JdbcModelStructure;
import org.teiid.designer.jdbc.relational.impl.ObjectMatcher;
import org.teiid.designer.jdbc.relational.impl.UserCancelledException;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ColumnSet;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.MultiplicityKind;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.RelationalEntity;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.RelationalPackage;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.metamodels.relational.SearchabilityType;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.UniqueConstraint;
import org.teiid.designer.metamodels.relational.UniqueKey;
import org.teiid.designer.metamodels.relational.aspects.validation.rules.RelationalStringNameRule;
import org.teiid.designer.metamodels.relational.util.RelationalTypeMapping;
import org.teiid.designer.metamodels.relational.util.RelationalUtil;

public class RelationalModelProcessorImpl
implements ModelerJdbcRelationalConstants,
RelationalModelProcessor {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(RelationalModelProcessorImpl.class);
    private static final String IMPORT_DESCRIPTION = RelationalModelProcessorImpl.getString("importDescription");
    public static final int IMPORT_WITH_NO_PROBLEMS = 3001;
    public static final int IMPORT_WITH_WARNINGS = 3002;
    public static final int IMPORT_WITH_ERRORS = 3003;
    public static final int IMPORT_WITH_WARNINGS_AND_ERRORS = 3004;
    public static final int IMPORT_WITH_NO_WARNINGS_AND_ERRORS = 3005;
    public static final int ERROR_PROCESSING_NODE = 3006;
    private static final int UNITS_PHASE_0 = 10;
    private static final int UNITS_PHASE_1 = 1000;
    private static final int UNITS_PHASE_2 = 1000;
    private static final int UNITS_PHASE_3 = 10000;
    private static final int UNITS_PHASE_4 = 10;
    private static final int UNITS_PHASE_5 = 10000;
    private static final int UNITS_PHASE_6 = 1000;
    private static final int UNITS_PHASE_7 = 1000;
    private static final int UNITS_PHASE_8 = 5000;
    private final RelationalFactory factory;
    private boolean verbose = false;
    private RelationalTypeMapping typeMapping;
    private DatatypeManager datatypeManager;
    DifferenceProcessor diffProc;
    DifferenceReport drDifferenceReport;
    private boolean moveRatherThanCopyAdds;
    private boolean includeIncompleteFKs;
    private boolean debugTimingEnabled = false;

    private static String getString(String id) {
        return ModelerJdbcRelationalConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public RelationalModelProcessorImpl() {
        this(RelationalFactory.eINSTANCE, null);
    }

    public RelationalModelProcessorImpl(RelationalFactory factory) {
        this(factory, null);
    }

    public RelationalModelProcessorImpl(RelationalFactory factory, RelationalTypeMapping mapping) {
        CoreArgCheck.isNotNull((Object)factory);
        this.factory = factory;
        this.typeMapping = mapping;
    }

    void stopLogIncrementAndRestart(Stopwatch watch, String message) {
        if (this.debugTimingEnabled) {
            watch.stopLogIncrementAndRestart(message);
        }
    }

    @Override
    public final IStatus execute(Resource modelResource, JdbcDatabase jdbcDatabase, JdbcImportSettings settings, IProgressMonitor monitor) {
        return this.execute(modelResource, null, jdbcDatabase, settings, monitor);
    }

    @Override
    public final IStatus execute(Resource modelResource, Container container, JdbcDatabase jdbcDatabase, JdbcImportSettings settings, IProgressMonitor monitor) {
        Stopwatch totalWatch = new Stopwatch();
        totalWatch.start();
        Stopwatch sWatch = new Stopwatch();
        sWatch.start();
        ModelContents modelContents = modelResource instanceof EmfResource ? ((EmfResource)modelResource).getModelContents() : new ModelContents(modelResource);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Got/Created Model Contents - Delta ");
        ContextImpl context = new ContextImpl(modelResource, modelContents, jdbcDatabase, settings, monitor);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Created ContextImpl - Delta ");
        URI uri = modelResource.getURI();
        WorkingArea workingArea = new WorkingArea(uri, jdbcDatabase, settings, monitor);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Created Working Area - Delta ");
        IStatus iStatus = this.executeWithinTransaction(context, workingArea, container);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Executing ContextImpl - Delta ");
        this.stopLogIncrementAndRestart(totalWatch, " RelationalModelProcessor:  Execute() Total - Delta ");
        return iStatus;
    }

    @Override
    public final IStatus execute(ModelResource modelResource, JdbcDatabase jdbcDatabase, JdbcImportSettings settings, IProgressMonitor monitor) throws ModelWorkspaceException {
        Stopwatch totalWatch = new Stopwatch();
        totalWatch.start();
        Stopwatch sWatch = new Stopwatch();
        sWatch.start();
        Resource emfResource = modelResource.getEmfResource();
        ModelContents modelContents = ModelContents.getModelContents((ModelResource)modelResource);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Got/Created Model Contents - Delta ");
        ContextImpl context = new ContextImpl(emfResource, modelContents, jdbcDatabase, settings, monitor);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Created ContextImpl - Delta ");
        URI uri = modelResource.getEmfResource().getURI();
        WorkingArea workingArea = new WorkingArea(uri, jdbcDatabase, settings, monitor);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Created Working Area - Delta ");
        IStatus iStatus = this.executeWithinTransaction(context, workingArea);
        this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  Executing ContextImpl - Delta ");
        this.stopLogIncrementAndRestart(totalWatch, " RelationalModelProcessor:  Execute() Total - Delta ");
        return iStatus;
    }

    protected IStatus executeWithinTransaction(Context context, WorkingArea workingArea) {
        return this.executeWithinTransaction(context, workingArea, null);
    }

    protected IStatus executeWithinTransaction(final Context context, final WorkingArea workingArea, Container container) {
        Status problem;
        String msg;
        final LinkedList<Status> problems = new LinkedList<Status>();
        try {
            TransactionRunnable op = new TransactionRunnable(){

                public Object run(UnitOfWork uow) throws ModelerCoreException {
                    Stopwatch sWatch = new Stopwatch();
                    sWatch.start();
                    RelationalModelProcessorImpl.this.performExecute(workingArea.getContext(), problems);
                    RelationalModelProcessorImpl.this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  performExecute() - Delta ");
                    RelationalModelProcessorImpl.this.performMerge(context, workingArea, problems);
                    RelationalModelProcessorImpl.this.stopLogIncrementAndRestart(sWatch, " RelationalModelProcessor:  performMerge() - Delta ");
                    return null;
                }
            };
            ModelerCore.getModelEditor().executeAsTransaction(op, container, IMPORT_DESCRIPTION, true, (Object)this);
        }
        catch (ModelerCoreRuntimeException e) {
            if (!(e.getChild() instanceof UserCancelledException)) {
                msg = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Problem_while_importing", new Object[0]);
                problem = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)e);
                problems.add(problem);
            }
        }
        catch (ModelerCoreException err) {
            msg = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Problem_while_importing", new Object[0]);
            problem = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)err);
            problems.add(problem);
        }
        IStatus resultStatus = null;
        if (problems.isEmpty()) {
            msg = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Import_into_relational_model_completed", new Object[0]);
            Status status = new Status(0, "org.teiid.designer.jdbc.relational", 3001, msg, null);
            resultStatus = status;
        } else if (problems.size() == 1) {
            resultStatus = (IStatus)problems.get(0);
        } else {
            int numErrors = 0;
            int numWarnings = 0;
            for (IStatus iStatus : problems) {
                if (iStatus.getSeverity() == 2) {
                    ++numWarnings;
                    continue;
                }
                if (iStatus.getSeverity() != 4) continue;
                ++numErrors;
            }
            IStatus[] iStatusArray = problems.toArray(new IStatus[problems.size()]);
            if (numWarnings != 0 && numErrors == 0) {
                Object[] params = new Object[]{new Integer(numWarnings)};
                String msg2 = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Completed_import_with_warnings", params);
                resultStatus = new MultiStatus("org.teiid.designer.jdbc.relational", 3002, iStatusArray, msg2, null);
            } else if (numWarnings == 0 && numErrors != 0) {
                Object[] params = new Object[]{new Integer(numErrors)};
                String msg3 = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Import_resulted_in_errors", params);
                resultStatus = new MultiStatus("org.teiid.designer.jdbc.relational", 3003, iStatusArray, msg3, null);
            } else if (numWarnings != 0 && numErrors != 0) {
                Object[] params = new Object[]{new Integer(numWarnings), new Integer(numErrors)};
                String msg4 = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Import_resulted_in_warnings_and_errors", params);
                resultStatus = new MultiStatus("org.teiid.designer.jdbc.relational", 3004, iStatusArray, msg4, null);
            } else {
                String msg5 = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Completed_import_with_no_warnings_or_errors", new Object[0]);
                resultStatus = new MultiStatus("org.teiid.designer.jdbc.relational", 3005, iStatusArray, msg5, null);
            }
        }
        return resultStatus;
    }

    public DifferenceReport generateDifferenceReport(ModelResource modelResource, JdbcDatabase jdbcDatabase, JdbcImportSettings settings, IProgressMonitor monitor) throws ModelWorkspaceException {
        LinkedList problems = new LinkedList();
        Resource emfResource = modelResource.getEmfResource();
        ModelContents modelContents = ModelContents.getModelContents((ModelResource)modelResource);
        ContextImpl context = new ContextImpl(emfResource, modelContents, jdbcDatabase, settings, monitor);
        URI uri = modelResource.getEmfResource().getURI();
        WorkingArea workingArea = new WorkingArea(uri, jdbcDatabase, settings, monitor);
        this.createDifferenceReport(context, workingArea, problems);
        return this.getDifferenceReport();
    }

    private DifferenceReport createDifferenceReport(final Context context, final WorkingArea workingArea, final List problems) {
        try {
            TransactionRunnable op = new TransactionRunnable(){

                public Object run(UnitOfWork uow) {
                    RelationalModelProcessorImpl.this.performExecute(workingArea.getContext(), problems);
                    Resource startingResource = context.getResource();
                    Resource endingResource = workingArea.getResource();
                    IProgressMonitor monitor = context.getProgressMonitor();
                    RelationalModelProcessorImpl.this.diffProc = ModelerComparePlugin.createDifferenceProcessor((Resource)startingResource, (Resource)endingResource);
                    IStatus diffStatus = RelationalModelProcessorImpl.this.diffProc.execute(monitor);
                    problems.add(diffStatus);
                    if (diffStatus.getSeverity() != 4) {
                        RelationalModelProcessorImpl.this.drDifferenceReport = RelationalModelProcessorImpl.this.diffProc.getDifferenceReport();
                        RelationalModelProcessorImpl.this.preProcessDifferenceReport(RelationalModelProcessorImpl.this.drDifferenceReport, context, workingArea, problems);
                    }
                    return null;
                }
            };
            ModelerCore.getModelEditor().executeAsTransaction(op, IMPORT_DESCRIPTION, true, (Object)this);
        }
        catch (ModelerCoreRuntimeException e) {
            if (!(e.getChild() instanceof UserCancelledException)) {
                String msg = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Problem_while_importing", new Object[0]);
                Status problem = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)e);
                problems.add(problem);
            }
        }
        catch (ModelerCoreException err) {
            String msg = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Problem_while_importing", new Object[0]);
            Status problem = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)err);
            problems.add(problem);
        }
        return this.drDifferenceReport;
    }

    public DifferenceReport getDifferenceReport() {
        return this.drDifferenceReport;
    }

    private DifferenceProcessor getDifferenceProcessor() {
        return this.diffProc;
    }

    protected void performMerge(Context context, WorkingArea workingArea, List problems) throws ModelerCoreException {
        if (this.getDifferenceProcessor() == null) {
            Resource startingResource = context.getResource();
            Resource endingResource = workingArea.getResource();
            IProgressMonitor monitor = context.getProgressMonitor();
            this.diffProc = ModelerComparePlugin.createDifferenceProcessor((Resource)startingResource, (Resource)endingResource);
            IStatus diffStatus = this.diffProc.execute(monitor);
            problems.add(diffStatus);
            if (diffStatus.getSeverity() != 4) {
                DifferenceReport differences = this.diffProc.getDifferenceReport();
                this.preProcessDifferenceReport(differences, context, workingArea, problems);
            }
        } else {
            this.diffProc = this.getDifferenceProcessor();
        }
        IProgressMonitor monitor = context.getProgressMonitor();
        EObject[] externalReferences = this.getDatatypeManager().getAllDatatypes();
        EmfResource eResource = (EmfResource)context.getResource();
        ContainerImpl ctnr = (ContainerImpl)eResource.getContainer();
        ModelEditorImpl.setContainer((ContainerImpl)ctnr);
        MergeProcessor mergeProc = ModelerComparePlugin.createMergeProcessor((DifferenceProcessor)this.diffProc, (EObject[])externalReferences, (boolean)this.moveRatherThanCopyAdds);
        IStatus mergeStatus = mergeProc.execute(monitor);
        problems.add(mergeStatus);
    }

    @Override
    public void setMoveRatherThanCopyAdds(boolean moveRatherThanCopyAdds) {
        this.moveRatherThanCopyAdds = moveRatherThanCopyAdds;
    }

    @Override
    public void setIncludeIncompleteFKs(boolean includeIncompleteFKs) {
        this.includeIncompleteFKs = includeIncompleteFKs;
    }

    @Override
    public boolean getIncludeIncompleteFKs() {
        return this.includeIncompleteFKs;
    }

    protected void preProcessDifferenceReport(DifferenceReport differences, Context context, WorkingArea workingArea, List problems) {
        CompareUtil.skipDeletesOfStandardContainers((DifferenceReport)differences);
        CompareUtil.skipDeletesOfModelImports((DifferenceReport)differences);
        this.skipDeletesOfJdbcSource(differences);
        this.skipChanges(differences);
    }

    protected void skipChanges(DifferenceReport differences) {
        Mapping rootMapping = differences.getMapping();
        this.skipChanges(rootMapping);
    }

    protected void skipChanges(Mapping mapping) {
        DifferenceDescriptor descriptor = CompareUtil.getDifferenceDescriptor((Mapping)mapping);
        boolean recursive = true;
        if (descriptor != null) {
            if (descriptor.isChanged()) {
                EList inputs = mapping.getInputs();
                if (inputs.size() == 1) {
                    this.skipChanges(descriptor, (EObject)inputs.get(0));
                }
                recursive = false;
            } else if (descriptor.isAddition()) {
                recursive = false;
            } else if (descriptor.isDeletion()) {
                recursive = false;
            }
        }
        if (recursive) {
            EList nestedMappings = mapping.getNested();
            for (Mapping nestedMapping : nestedMappings) {
                this.skipChanges(nestedMapping);
            }
        }
    }

    protected void skipChanges(DifferenceDescriptor changeDescriptor, EObject inputObject) {
        if (inputObject instanceof Column) {
            EList propertyDiffs = changeDescriptor.getPropertyDifferences();
            for (PropertyDifference propDiff : propertyDiffs) {
                EStructuralFeature columnFeature = propDiff.getAffectedFeature();
                int columnFeatureId = columnFeature.getFeatureID();
                switch (columnFeatureId) {
                    case 8: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 19: 
                    case 21: {
                        propDiff.setSkip(true);
                        break;
                    }
                    case 17: 
                    case 18: {
                        propDiff.setSkip(true);
                    }
                }
            }
        }
    }

    protected void skipDeletesOfJdbcSource(DifferenceReport differences) {
        Mapping rootMapping = differences.getMapping();
        EList nestedMappings = rootMapping.getNested();
        for (Mapping nestedMapping : nestedMappings) {
            if (!CompareUtil.hasInstanceof((Mapping)nestedMapping, JdbcSource.class)) continue;
            DifferenceDescriptor desc = CompareUtil.getDifferenceDescriptor((Mapping)nestedMapping);
            desc.setSkip(true);
        }
    }

    /*
     * Exception decompiling
     */
    protected void performExecute(Context context, List problems) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void processCostingInfo(Context context, List problems) throws Exception {
        Resource resource = context.getResource();
        JdbcSource source = context.getJdbcImportSettings().getSource();
        if (source != null) {
            CostAnalyzerFactory analyzerFactory = CostAnalyzerFactory.getCostAnalyzerFactory();
            List emfTables = RelationalUtil.findTables((Object)resource);
            Map tblStats = analyzerFactory.createTableInfos(emfTables);
            IProgressMonitor monitor = context.getProgressMonitor();
            CostAnalyzer costAnalyzer = analyzerFactory.getCostAnalyzer(source, source.getPassword());
            costAnalyzer.collectStatistics(tblStats, monitor);
            if (!context.getProgressMonitor().isCanceled()) {
                analyzerFactory.populateEmfColumnStatistics(emfTables, tblStats);
            }
        }
    }

    protected void processModelInformation(Context context, List problems) {
        ModelContents contents = context.getModelContents();
        ModelAnnotation model = contents.getModelAnnotation();
        this.updateModelAnnotation(model);
    }

    protected RelationalEntity createNewObject(JdbcNode node, RelationalEntity parent, JdbcModelStructure modelStructure, Map nodesToModelObjects, Context context, int totalNum, int unitsPerModelObject, int index, IProgressMonitor monitor, List problems, List newTableObjects) throws JdbcException {
        CoreArgCheck.isNotNull((Object)node);
        CoreArgCheck.isNotNull((Object)modelStructure);
        CoreArgCheck.isNotNull((Object)context);
        ModelContents contents = context.getModelContents();
        int nodeType = node.getType();
        String nodeName = node.getName();
        if (monitor.isCanceled()) {
            throw new UserCancelledException();
        }
        if (nodeName == null || nodeName.trim().length() == 0) {
            String typeName = node.getTypeName();
            Object[] params = new Object[]{typeName};
            String msg = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Skipping_{0}_with_no_name", params);
            Status status = new Status(2, "org.teiid.designer.jdbc.relational", 0, msg, null);
            problems.add(status);
        }
        Procedure obj = null;
        switch (nodeType) {
            case 102: {
                break;
            }
            case 103: {
                break;
            }
            case 104: {
                JdbcTable tableNode = (JdbcTable)node;
                String tableType = tableNode.getTypeName();
                String eclassName = JdbcRelationalPlugin.getJdbcNodeToRelationalMapping().getRelationalClassForJdbcTableType(tableType);
                RelationalPackage pkg = RelationalPackage.eINSTANCE;
                CoreArgCheck.isNotNull((Object)pkg, (String)ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.RelationalPackageNotFound", new Object[0]));
                EClass eclass = (EClass)pkg.getEClassifier(eclassName);
                if (eclass == null) {
                    eclass = pkg.getBaseTable();
                }
                Object[] subtaskParams = new Object[]{eclass.getName(), nodeName, new Integer(totalNum), new Integer(index)};
                String subtaskMsg = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Creating_table_or_view", subtaskParams);
                monitor.subTask(subtaskMsg);
                Table table = (Table)this.factory.create(eclass);
                if (parent instanceof Catalog) {
                    table.setCatalog((Catalog)parent);
                } else if (parent instanceof Schema) {
                    table.setSchema((Schema)parent);
                } else {
                    context.getResource().getContents().add((Object)table);
                }
                this.setNameAndNameInSource((RelationalEntity)table, nodeName, node, context, problems);
                String desc = tableNode.getRemarks();
                if (desc != null && desc.trim().length() != 0) {
                    Annotation annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)table, (AnnotationContainer)contents.getAnnotationContainer(true));
                    annotation.setDescription(desc);
                }
                this.createColumns(tableNode, table, context, problems);
                this.createPrimaryKey(tableNode, table, context, problems);
                if (context.getJdbcDatabase().getIncludes().includeIndexes()) {
                    this.createIndexes(tableNode, table, context, problems);
                }
                newTableObjects.add(node);
                obj = table;
                monitor.worked(unitsPerModelObject);
                break;
            }
            case 106: {
                JdbcProcedure procNode = (JdbcProcedure)node;
                Procedure proc = this.factory.createProcedure();
                Object[] procParams = new Object[]{nodeName, new Integer(totalNum), new Integer(index)};
                String subtaskMsg = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Creating_procedure", procParams);
                monitor.subTask(subtaskMsg);
                if (parent instanceof Catalog) {
                    proc.setCatalog((Catalog)parent);
                } else if (parent instanceof Schema) {
                    proc.setSchema((Schema)parent);
                } else {
                    context.getResource().getContents().add((Object)proc);
                }
                this.setNameAndNameInSource((RelationalEntity)proc, nodeName, node, context, problems);
                obj = proc;
                this.createParameters(procNode, proc, context, problems);
                monitor.worked(unitsPerModelObject);
            }
        }
        nodesToModelObjects.put(node, obj);
        List children = modelStructure.getChildren(node);
        int counter = 0;
        if (children != null && children.size() != 0) {
            for (JdbcNode child : children) {
                this.createNewObject(child, (RelationalEntity)obj, modelStructure, nodesToModelObjects, context, totalNum, unitsPerModelObject, index + ++counter, monitor, problems, newTableObjects);
            }
        }
        return obj;
    }

    protected void createColumns(JdbcTable tableNode, Table table, Context context, List problems) {
        CoreArgCheck.isNotNull((Object)context);
        ModelContents contents = context.getModelContents();
        try {
            Request request = tableNode.getRequest(GetColumnsRequest.NAME, false);
            Results results = request.getResults();
            Object[] rows = results.getRows();
            int numRows = results.getRowCount();
            int i = 0;
            while (i < numRows) {
                Object row = rows[i];
                String name = results.getString(row, 3);
                int type = results.getInt(row, 4);
                String typeName = results.getString(row, 5);
                int columnSize = results.getInt(row, 6);
                int numDecDigits = results.getInt(row, 8);
                int numPrecRadix = results.getInt(row, 9);
                int nullable = results.getInt(row, 10);
                String remarks = results.getString(row, 11);
                String defaultValue = results.getString(row, 12);
                int charOctetLen = results.getInt(row, 15);
                Column column = this.factory.createColumn();
                column.setOwner((ColumnSet)table);
                this.setColumnInfo(column, tableNode, context, problems, name, type, typeName, columnSize, numDecDigits, numPrecRadix, nullable, defaultValue, charOctetLen);
                if (remarks != null && remarks.trim().length() != 0) {
                    Annotation annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)column, (AnnotationContainer)contents.getAnnotationContainer(true));
                    annotation.setDescription(remarks);
                }
                ++i;
            }
        }
        catch (JdbcException e) {
            String msg = String.valueOf(ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_obtaining_column_info", new Object[0])) + e.getLocalizedMessage();
            Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)e);
            problems.add(status);
        }
    }

    protected void setColumnInfo(Column column, JdbcTable tableNode, Context context, List problems, String name, int type, String typeName, int columnSize, int numDecDigits, int numPrecRadix, int nullable, String defaultValue, int charOctetLen) {
        EObject datatype;
        this.setNameAndNameInSource((RelationalEntity)column, name, (JdbcNode)tableNode, context, true, problems);
        column.setFixedLength(this.isFixedLength(type, typeName));
        column.setNativeType(typeName);
        String delegateNativeTypeName = typeName;
        if (type == 1 && columnSize > 1) {
            delegateNativeTypeName = "varchar";
        }
        if ((datatype = this.findType(type, delegateNativeTypeName, columnSize, columnSize, numDecDigits, problems)) != null) {
            column.setType(datatype);
        }
        SearchabilityType searchability = this.typeMapping != null && datatype != null ? this.typeMapping.getSearchabilityType(datatype) : SearchabilityType.UNSEARCHABLE_LITERAL;
        column.setSearchability(searchability);
        if (searchability.getValue() == 1) {
            column.setCaseSensitive(false);
            column.setPrecision(columnSize);
            column.setLength(0);
        } else if (searchability.getValue() == 0) {
            column.setLength(columnSize);
            column.setPrecision(0);
            column.setCaseSensitive(true);
        } else {
            column.setCaseSensitive(false);
            column.setPrecision(0);
            column.setLength(columnSize);
        }
        if (type == 1) {
            column.setLength(columnSize);
            column.setPrecision(0);
        }
        column.setScale(numDecDigits);
        switch (nullable) {
            case 0: {
                column.setNullable(NullableType.NO_NULLS_LITERAL);
                break;
            }
            case 1: {
                column.setNullable(NullableType.NULLABLE_LITERAL);
                break;
            }
            default: {
                column.setNullable(NullableType.NULLABLE_UNKNOWN_LITERAL);
            }
        }
        if (defaultValue != null) {
            if (type == -7) {
                if (columnSize <= 1) {
                    if (defaultValue.length() == 1) {
                        char charIntVal = defaultValue.charAt(0);
                        if (charIntVal == '\u0000') {
                            column.setDefaultValue(Boolean.FALSE.toString());
                        } else if (charIntVal == '\u0001') {
                            column.setDefaultValue(Boolean.TRUE.toString());
                        }
                    } else {
                        String trimedDefault = defaultValue.trim();
                        if (defaultValue.startsWith("(") && defaultValue.endsWith(")")) {
                            trimedDefault = defaultValue.substring(1, defaultValue.length() - 1);
                        }
                        column.setDefaultValue(trimedDefault);
                    }
                }
            } else if (type != -2) {
                column.setDefaultValue(defaultValue);
            }
        }
        column.setSelectable(true);
        column.setUpdateable(true);
        if (numPrecRadix != 0) {
            column.setRadix(numPrecRadix);
        }
    }

    protected boolean isFixedLength(int type, String typeName) {
        return type != -4 && type != -1 && type != -3 && type != 12 && type != 2003 && type != 2004 && type != 2005;
    }

    protected EObject findType(int jdbcType, String typeName, int length, int precision, int scale, List problems) {
        EObject result = null;
        if (jdbcType == -7 && precision > 1) {
            jdbcType = -2;
        }
        try {
            result = this.datatypeManager.getBuiltInDatatype(typeName);
        }
        catch (ModelerCoreException ex) {
            JdbcPlugin.Util.log((Throwable)ex);
        }
        if (result != null) {
            return result;
        }
        result = this.findType(jdbcType, problems);
        if (result != null) {
            return result;
        }
        result = this.findType(typeName, problems);
        return result;
    }

    protected EObject findType(int jdbcType, List problems) {
        if (this.typeMapping != null) {
            try {
                return this.typeMapping.getDatatype(jdbcType);
            }
            catch (ModelerCoreException e) {
                Object[] params = new Object[]{new Integer(jdbcType)};
                String msg = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_computing_datatype", params);
                Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)e);
                problems.add(status);
            }
        }
        return null;
    }

    protected EObject findType(String jdbcTypeName, List problems) {
        if (jdbcTypeName != null && this.typeMapping != null) {
            try {
                return this.typeMapping.getDatatype(jdbcTypeName);
            }
            catch (ModelerCoreException e) {
                Object[] params = new Object[]{jdbcTypeName};
                String msg = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_computing_datatype", params);
                Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)e);
                problems.add(status);
            }
        }
        return null;
    }

    protected EObject findBuiltinType(String typeName, List problems) {
        if (typeName != null && this.getDatatypeManager() != null) {
            try {
                EObject obj = this.getDatatypeManager().getBuiltInDatatype(typeName);
                if (obj != null) {
                    return obj;
                }
            }
            catch (ModelerCoreException e) {
                Object[] params = new Object[]{typeName};
                String msg = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_computing_datatype", params);
                Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)e);
                problems.add(status);
            }
        }
        return null;
    }

    protected void createPrimaryKey(JdbcTable tableNode, Table table, Context context, List problems) {
        if (!(table instanceof BaseTable)) {
            return;
        }
        boolean includeUniqueIndexes = context.getJdbcImportSettings().isIncludeUniqueIndexes();
        boolean includeForeignKeys = context.getJdbcImportSettings().isIncludeForeignKeys();
        if (!includeUniqueIndexes && !includeForeignKeys) {
            return;
        }
        try {
            Request request = tableNode.getRequest(GetPrimaryKeyRequest.NAME, false);
            Results results = request.getResults();
            Object[] rows = results.getRows();
            int numRows = results.getRowCount();
            if (numRows == 0) {
                return;
            }
            Map columnsByName = this.createColumnMapKeyedByNames(table, tableNode, context, problems);
            String pkName = null;
            Column[] columns = new Column[numRows];
            int i = 0;
            while (i < numRows) {
                Object row = rows[i];
                String columnName = results.getString(row, 3);
                pkName = results.getString(row, 5);
                String quoteStr = this.getQuoteString(context, problems);
                columnName = quoteStr != null ? tableNode.getUnqualifiedName(columnName).replaceAll(quoteStr, "") : tableNode.getUnqualifiedName(columnName);
                Column column = (Column)columnsByName.get(columnName = this.convertName(columnName, context));
                if (column != null) {
                    short seqIndex = results.getShort(row, 4);
                    columns[seqIndex - 1] = column;
                }
                ++i;
            }
            PrimaryKey primaryKey = this.factory.createPrimaryKey();
            primaryKey.setTable((BaseTable)table);
            if (pkName != null) {
                this.setNameAndNameInSource((RelationalEntity)primaryKey, pkName, (JdbcNode)tableNode, context, true, problems);
            }
            EList keyColumns = primaryKey.getColumns();
            int i2 = 0;
            while (i2 < columns.length) {
                Column column = columns[i2];
                if (column != null) {
                    keyColumns.add(column);
                }
                ++i2;
            }
        }
        catch (JdbcException e) {
            String msg = String.valueOf(ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_primary_key_info", new Object[0])) + e.getLocalizedMessage();
            Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)e);
            problems.add(status);
        }
    }

    protected boolean checkExportedForeignKeysIfNoImportedForeignKeysFound() {
        return true;
    }

    protected Request getForeignKeyRequest(JdbcTable tableNode, String name, boolean includeMetadata) throws JdbcException {
        return tableNode.getRequest(GetImportedForeignKeysRequest.NAME, false);
    }

    protected void createForeignKey(JdbcTable tableNode, Table table, Context context, Map nodesToModelObjects, boolean includeIncompleteFKs, List problems) {
        if (!(table instanceof BaseTable)) {
            return;
        }
        try {
            Request request = this.getForeignKeyRequest(tableNode, GetImportedForeignKeysRequest.NAME, false);
            Results results = request.getResults();
            Object[] rows = results.getRows();
            int numRows = results.getRowCount();
            if (numRows == 0 && this.checkExportedForeignKeysIfNoImportedForeignKeysFound()) {
                request = tableNode.getRequest(GetExportedForeignKeysRequest.NAME, false);
                results = request.getResults();
                rows = results.getRows();
                numRows = results.getRowCount();
                if (numRows == 0) {
                    return;
                }
                return;
            }
            Map columnsByName = this.createColumnMapKeyedByNames(table, tableNode, context, problems);
            ArrayList<Column> currentColumnsForKey = null;
            HashMap<String, ArrayList<Column>> columnsByFK = new HashMap<String, ArrayList<Column>>();
            ArrayList<String> currentColumnNamesForPk = null;
            HashMap<String, ArrayList<String>> columnNamesForPks = new HashMap<String, ArrayList<String>>();
            HashMap<String, ForeignKeySpec> fkSpecs = new HashMap<String, ForeignKeySpec>();
            ArrayList<Column> previousColForKeyList = null;
            boolean initDone = false;
            int i = 0;
            while (i < numRows) {
                Object row = rows[i];
                short seqIndex = results.getShort(row, 8);
                String fkColumnName = results.getString(row, 7);
                String pkColumnName = results.getString(row, 3);
                String quoteStr = this.getQuoteString(context, problems);
                fkColumnName = quoteStr != null ? tableNode.getUnqualifiedName(fkColumnName).replaceAll(quoteStr, "") : tableNode.getUnqualifiedName(fkColumnName);
                fkColumnName = this.convertName(fkColumnName, context);
                pkColumnName = quoteStr != null ? tableNode.getUnqualifiedName(pkColumnName).replaceAll(quoteStr, "") : tableNode.getUnqualifiedName(pkColumnName);
                pkColumnName = this.convertName(pkColumnName, context);
                Column column = (Column)columnsByName.get(fkColumnName);
                String fkName = results.getString(row, 11);
                currentColumnsForKey = (ArrayList<Column>)columnsByFK.get(fkName);
                currentColumnNamesForPk = (ArrayList<String>)columnNamesForPks.get(fkName);
                if (currentColumnsForKey == null || currentColumnsForKey != previousColForKeyList) {
                    initDone = false;
                    previousColForKeyList = currentColumnsForKey;
                }
                if (column != null) {
                    if (!(seqIndex != 1 && seqIndex != 0 || initDone)) {
                        currentColumnsForKey = new ArrayList<Column>();
                        currentColumnNamesForPk = new ArrayList<String>();
                        ForeignKeySpec fkSpec = new ForeignKeySpec();
                        fkSpec.fkName = fkName;
                        fkSpec.pkName = results.getString(row, 12);
                        fkSpec.pkTable = results.getString(row, 2);
                        fkSpec.pkSchema = results.getString(row, 1);
                        fkSpec.pkCatalog = results.getString(row, 0);
                        fkSpecs.put(fkName, fkSpec);
                        columnsByFK.put(fkName, currentColumnsForKey);
                        columnNamesForPks.put(fkName, currentColumnNamesForPk);
                        initDone = true;
                    }
                    currentColumnsForKey.add(column);
                    currentColumnNamesForPk.add(pkColumnName);
                }
                ++i;
            }
            Iterator fkSpecIter = columnsByFK.keySet().iterator();
            Iterator columnsForKeyIter = columnsByFK.values().iterator();
            Iterator columnNamesForPkIter = columnNamesForPks.values().iterator();
            while (columnsForKeyIter.hasNext()) {
                List columnsForKey = (List)columnsForKeyIter.next();
                List columnNamesForPk = (List)columnNamesForPkIter.next();
                ForeignKeySpec fkSpec = (ForeignKeySpec)fkSpecs.get(fkSpecIter.next());
                UniqueKey ukey = this.findUniqueKey(tableNode.getJdbcDatabase(), nodesToModelObjects, fkSpec.pkCatalog, fkSpec.pkSchema, fkSpec.pkTable, columnNamesForPk, context, problems);
                if (ukey == null && !includeIncompleteFKs) continue;
                ForeignKey fk = this.factory.createForeignKey();
                fk.setTable((BaseTable)table);
                this.setNameAndNameInSource((RelationalEntity)fk, fkSpec.fkName, (JdbcNode)tableNode, context, true, problems);
                fk.getColumns().addAll((Collection)columnsForKey);
                fk.setPrimaryKeyMultiplicity(MultiplicityKind.UNSPECIFIED_LITERAL);
                fk.setForeignKeyMultiplicity(MultiplicityKind.UNSPECIFIED_LITERAL);
                fk.setUniqueKey(ukey);
            }
        }
        catch (JdbcException e) {
            String msg = String.valueOf(ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_primary_key_info", new Object[0])) + e.getLocalizedMessage();
            Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)e);
            problems.add(status);
        }
    }

    protected UniqueKey findUniqueKey(JdbcDatabase dbNode, Map nodesToModelObjects, String catalogName, String schemaName, String tableName, List columnNames, Context context, List<String> problems) {
        JdbcNode tableTypeContainer;
        Path path = new Path("/");
        if (catalogName != null && catalogName.trim().length() != 0) {
            boolean supportsCatalogs = true;
            try {
                supportsCatalogs = dbNode.getCapabilities().supportsCatalogs();
            }
            catch (Exception exception) {}
            if (supportsCatalogs) {
                path = path.append(catalogName);
            }
        }
        if (schemaName != null && schemaName.trim().length() != 0) {
            boolean supportsSchemas = true;
            try {
                supportsSchemas = dbNode.getCapabilities().supportsSchemas();
            }
            catch (Exception exception) {}
            if (supportsSchemas) {
                path = path.append(schemaName);
            }
        }
        if ((tableTypeContainer = dbNode.findJdbcNode((IPath)path)) == null) {
            tableTypeContainer = dbNode;
        }
        JdbcNode[] children = null;
        try {
            children = tableTypeContainer.getChildren();
        }
        catch (JdbcException e) {
            ModelerJdbcRelationalConstants.Util.log((Throwable)e);
            return null;
        }
        int i = 0;
        while (i < children.length) {
            JdbcNode tableWithKey;
            JdbcNode child = children[i];
            if (child instanceof JdbcTableType && (tableWithKey = child.findChild(tableName)) != null && tableWithKey instanceof JdbcTable) {
                JdbcTable tableNode = (JdbcTable)tableWithKey;
                RelationalEntity table = (RelationalEntity)nodesToModelObjects.get(tableWithKey);
                if (table != null && table instanceof BaseTable) {
                    BaseTable baseTable = (BaseTable)table;
                    PrimaryKey pk = baseTable.getPrimaryKey();
                    if (this.isUniqueyMatch((UniqueKey)pk, columnNames, tableNode, context, problems)) {
                        return pk;
                    }
                    for (UniqueConstraint constraint : ((BaseTable)table).getUniqueConstraints()) {
                        if (!this.isUniqueyMatch((UniqueKey)constraint, columnNames, tableNode, context, problems)) continue;
                        return constraint;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    protected Map createColumnMapKeyedByNames(Table table, JdbcTable tableNode, Context context, List problems) {
        String quoteStr = this.getQuoteString(context, problems);
        HashMap<String, Column> columnsByName = new HashMap<String, Column>();
        Iterator iter = table.getColumns().iterator();
        while (iter.hasNext()) {
            String mapName = null;
            Column column = (Column)iter.next();
            String columnNIS = column.getNameInSource();
            if (columnNIS == null || columnNIS.trim().length() == 0) {
                mapName = this.convertName(column.getName(), context);
            } else {
                mapName = quoteStr != null ? tableNode.getUnqualifiedName(columnNIS).replaceAll(quoteStr, "") : tableNode.getUnqualifiedName(columnNIS);
                mapName = this.convertName(mapName, context);
            }
            columnsByName.put(mapName, column);
        }
        return columnsByName;
    }

    protected List createIndexes(JdbcTable tableNode, Table table, Context context, List problems) {
        LinkedList<Index> indexes = null;
        try {
            Request request = tableNode.getRequest(GetIndexesRequest.NAME, false);
            Results results = request.getResults();
            Object[] rows = results.getRows();
            int numRows = results.getRowCount();
            if (numRows == 0) {
                return Collections.EMPTY_LIST;
            }
            indexes = new LinkedList<Index>();
            Map columnsByName = this.createColumnMapKeyedByNames(table, tableNode, context, problems);
            ArrayList<IndexSpec> indexSpecs = new ArrayList<IndexSpec>();
            ArrayList<Column> currentColumnsForIndex = null;
            int i = 0;
            while (i < numRows) {
                Object row = rows[i];
                short type = results.getShort(row, 6);
                if (type == 0) {
                    int cardinality = results.getInt(row, 10);
                    this.updateCardinality(table, cardinality);
                } else {
                    short position = results.getShort(row, 7);
                    String columnName = results.getString(row, 8);
                    String quoteStr = this.getQuoteString(context, problems);
                    columnName = quoteStr != null ? tableNode.getUnqualifiedName(columnName).replaceAll(quoteStr, "") : tableNode.getUnqualifiedName(columnName);
                    columnName = this.convertName(columnName, context);
                    Column column = (Column)columnsByName.get(columnName);
                    if (position == 1) {
                        currentColumnsForIndex = new ArrayList<Column>();
                        IndexSpec spec = new IndexSpec();
                        spec.indexName = results.getString(row, 5);
                        spec.indexQualifier = results.getString(row, 4);
                        spec.nonUnique = results.getBoolean(row, 0);
                        spec.pages = results.getInt(row, 11);
                        spec.cardinality = results.getInt(row, 10);
                        spec.filterCondition = results.getString(row, 12);
                        spec.type = type;
                        spec.columns = currentColumnsForIndex;
                        indexSpecs.add(spec);
                    }
                    if (column != null) {
                        currentColumnsForIndex.add(column);
                    }
                }
                ++i;
            }
            for (IndexSpec indexSpec : indexSpecs) {
                this.modifyIndexName(indexSpec);
                Index index = this.findIndex(table, indexSpec, tableNode, context, true, problems);
                if (index == null) continue;
                this.updateCardinality(table, indexSpec.cardinality);
                indexes.add(index);
            }
        }
        catch (JdbcException e) {
            String msg = String.valueOf(ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_primary_key_info", new Object[0])) + e.getLocalizedMessage();
            Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)e);
            problems.add(status);
        }
        return indexes;
    }

    protected void modifyIndexName(IndexSpec indexSpec) {
    }

    protected void updateCardinality(Table table, int cardinality) {
        if (table.getCardinality() == 0 && cardinality > 0) {
            table.setCardinality(cardinality);
        }
    }

    protected Index findIndex(Table table, IndexSpec spec, JdbcTable tableNode, Context context, boolean createIfRequired, List problems) {
        EObject tableOwner = table.eContainer();
        if (tableOwner != null) {
            EList existingIndexes = null;
            if (tableOwner instanceof Catalog) {
                existingIndexes = ((Catalog)tableOwner).getIndexes();
            } else if (tableOwner instanceof Schema) {
                existingIndexes = ((Schema)tableOwner).getIndexes();
            }
            for (Index index : existingIndexes) {
                boolean isMatch = this.isMatchingIndex(index, spec);
                if (!isMatch) continue;
                this.setNameAndNameInSource((RelationalEntity)index, spec.indexName, (JdbcNode)tableNode, context, problems);
                return index;
            }
        } else {
            Resource resource = table.eResource();
            if (resource != null) {
                for (Object rootObj : resource.getContents()) {
                    Index index;
                    if (!(rootObj instanceof Index) || !this.isMatchingIndex(index = (Index)rootObj, spec)) continue;
                    this.setNameAndNameInSource((RelationalEntity)index, spec.indexName, (JdbcNode)tableNode, context, problems);
                    return index;
                }
            }
        }
        if (table instanceof BaseTable) {
            String objectName = this.convertName(spec.indexName, context);
            PrimaryKey pk = ((BaseTable)table).getPrimaryKey();
            if (pk != null && objectName.equals(pk.getName())) {
                return null;
            }
        }
        Index index = this.factory.createIndex();
        if (tableOwner != null) {
            if (tableOwner instanceof Catalog) {
                index.setCatalog((Catalog)tableOwner);
            } else if (tableOwner instanceof Schema) {
                index.setSchema((Schema)tableOwner);
            }
        } else {
            Resource resource = table.eResource();
            CoreArgCheck.isNotNull((Object)resource);
            resource.getContents().add((Object)index);
        }
        this.setNameAndNameInSource((RelationalEntity)index, spec.indexName, (JdbcNode)tableNode, context, problems);
        String quoteStr = this.getQuoteString(context, problems);
        String nis = String.valueOf(index.getNameInSource()) + '.' + quoteStr + spec.indexName + quoteStr;
        index.setNameInSource(nis);
        index.setUnique(!spec.nonUnique);
        index.getColumns().addAll((Collection)spec.columns);
        index.setFilterCondition(spec.filterCondition);
        return index;
    }

    protected boolean isMatchingIndex(Index index, IndexSpec spec) {
        if (index.isUnique() && spec.nonUnique) {
            return false;
        }
        EList indexColumns = index.getColumns();
        List specColumns = spec.columns;
        if (indexColumns.size() != specColumns.size()) {
            return false;
        }
        return indexColumns.containsAll(specColumns) && specColumns.containsAll((Collection<?>)indexColumns);
    }

    private boolean isUniqueyMatch(UniqueKey ukey, List columnNames, JdbcTable tableNode, Context context, List problems) {
        if (ukey == null) {
            return false;
        }
        EList ukeyColumns = ukey.getColumns();
        if (ukeyColumns.size() != columnNames.size()) {
            return false;
        }
        String quoteStr = this.getQuoteString(context, problems);
        Iterator iter = ukeyColumns.iterator();
        Iterator nameIter = columnNames.iterator();
        while (iter.hasNext()) {
            Column ukColumn = (Column)iter.next();
            String columnName = (String)nameIter.next();
            String ukColumnNIS = ukColumn.getNameInSource();
            String ukColumnName = null;
            if (ukColumnNIS == null || ukColumnNIS.trim().length() == 0) {
                ukColumnName = this.convertName(ukColumn.getName(), context);
            } else {
                ukColumnName = quoteStr != null ? tableNode.getUnqualifiedName(ukColumnNIS).replaceAll(quoteStr, "") : tableNode.getUnqualifiedName(ukColumnNIS);
                ukColumnName = this.convertName(ukColumnName, context);
            }
            if (ukColumnName.equals(columnName)) continue;
            return false;
        }
        return true;
    }

    protected void createParameters(JdbcProcedure procNode, Procedure proc, Context context, List problems) {
        CoreArgCheck.isNotNull((Object)context);
        ModelContents contents = context.getModelContents();
        try {
            Request request = procNode.getRequest(GetProcedureParametersRequest.NAME, false);
            Results results = request.getResults();
            Object[] rows = results.getRows();
            int numRows = results.getRowCount();
            if (numRows == 0) {
                return;
            }
            ProcedureResult procResult = null;
            int numParamsWithNullName = 0;
            int i = 0;
            while (i < numRows) {
                Object row = rows[i];
                String name = results.getString(row, 3);
                short columnType = results.getShort(row, 4);
                short type = results.getShort(row, 5);
                String typeName = results.getString(row, 6);
                int precision = results.getInt(row, 7);
                int length = results.getInt(row, 8);
                int scale = results.getInt(row, 9);
                int radix = results.getInt(row, 10);
                short nullable = results.getShort(row, 11);
                String remarks = results.getString(row, 12);
                boolean resultSetColumn = this.isProcedureResultColumn(columnType, type, typeName);
                if (!resultSetColumn) {
                    ProcedureParameter param = this.factory.createProcedureParameter();
                    param.setProcedure(proc);
                    if (name == null) {
                        name = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.DefaultNameForProcParamWithNoName", (Object)(++numParamsWithNullName));
                    }
                    this.setNameAndNameInSource((RelationalEntity)param, name, (JdbcNode)procNode, context, true, problems);
                    param.setNativeType(typeName);
                    EObject datatype = this.findType(type, typeName, length, precision, scale, problems);
                    if (datatype != null) {
                        param.setType(datatype);
                    }
                    param.setLength(length);
                    param.setPrecision(precision);
                    param.setScale(scale);
                    param.setRadix(radix);
                    switch (nullable) {
                        case 0: {
                            param.setNullable(NullableType.NO_NULLS_LITERAL);
                            break;
                        }
                        case 1: {
                            param.setNullable(NullableType.NULLABLE_LITERAL);
                            break;
                        }
                        default: {
                            param.setNullable(NullableType.NULLABLE_UNKNOWN_LITERAL);
                        }
                    }
                    switch (columnType) {
                        case 1: {
                            param.setDirection(DirectionKind.IN_LITERAL);
                            break;
                        }
                        case 4: {
                            param.setDirection(DirectionKind.OUT_LITERAL);
                            break;
                        }
                        case 2: {
                            param.setDirection(DirectionKind.INOUT_LITERAL);
                            break;
                        }
                        case 5: {
                            param.setDirection(DirectionKind.RETURN_LITERAL);
                            break;
                        }
                        case 3: {
                            param.setDirection(DirectionKind.RETURN_LITERAL);
                            break;
                        }
                        default: {
                            param.setDirection(DirectionKind.UNKNOWN_LITERAL);
                        }
                    }
                    if (remarks != null && remarks.trim().length() != 0) {
                        Annotation annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)param, (AnnotationContainer)contents.getAnnotationContainer(true));
                        annotation.setDescription(remarks);
                    }
                } else {
                    boolean includeColumn;
                    if (procResult == null) {
                        procResult = this.factory.createProcedureResult();
                        procResult.setProcedure(proc);
                        String resultSetName = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.ResultSetName", new Object[0]);
                        this.setNameAndNameInSource((RelationalEntity)procResult, resultSetName, (JdbcNode)procNode, context, true, problems);
                    }
                    if (!(includeColumn = this.includeColumnInProcedureResult(columnType, type, typeName))) {
                        this.setNameAndNameInSource((RelationalEntity)procResult, name, (JdbcNode)procNode, context, true, problems);
                        if (remarks != null && remarks.trim().length() != 0) {
                            Annotation annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)procResult, (AnnotationContainer)contents.getAnnotationContainer(true));
                            annotation.setDescription(remarks);
                        }
                    } else {
                        EObject datatype;
                        Column column = this.factory.createColumn();
                        column.setOwner((ColumnSet)procResult);
                        this.setNameAndNameInSource((RelationalEntity)column, name, (JdbcNode)procNode, context, true, problems);
                        column.setNativeType(typeName);
                        String delegateNativeTypeName = typeName;
                        if (type == 1 && length > 1) {
                            delegateNativeTypeName = "varchar";
                        }
                        if ((datatype = this.findType(type, delegateNativeTypeName, length, length, scale, problems)) != null) {
                            column.setType(datatype);
                        }
                        column.setLength(length);
                        column.setPrecision(precision);
                        column.setScale(scale);
                        column.setRadix(radix);
                        switch (nullable) {
                            case 0: {
                                column.setNullable(NullableType.NO_NULLS_LITERAL);
                                break;
                            }
                            case 1: {
                                column.setNullable(NullableType.NULLABLE_LITERAL);
                                break;
                            }
                            default: {
                                column.setNullable(NullableType.NULLABLE_UNKNOWN_LITERAL);
                            }
                        }
                        if (remarks != null && remarks.trim().length() != 0) {
                            Annotation annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)column, (AnnotationContainer)contents.getAnnotationContainer(true));
                            annotation.setDescription(remarks);
                        }
                    }
                }
                ++i;
            }
        }
        catch (JdbcException e) {
            String msg = String.valueOf(ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_primary_key_info", new Object[0])) + e.getLocalizedMessage();
            Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)e);
            problems.add(status);
        }
    }

    protected boolean isProcedureResultColumn(short columnType, short type, String typeName) {
        return columnType == 3;
    }

    protected boolean includeColumnInProcedureResult(short columnType, short type, String typeName) {
        return true;
    }

    protected void matchChildren(JdbcNode parentOfNodes, List jdbcNodes, List modelObjs, JdbcModelStructure structure, ObjectMatcher matcher, IProgressMonitor monitor) {
        CoreArgCheck.isNotNull((Object)jdbcNodes);
        CoreArgCheck.isNotNull((Object)modelObjs);
        CoreArgCheck.isNotNull((Object)structure);
        CoreArgCheck.isNotNull((Object)matcher);
        if (parentOfNodes == null) {
            String subtaskMsg = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Finding_existing_root_model_objects", new Object[0]);
            monitor.subTask(subtaskMsg);
        } else {
            Object[] params = new Object[]{parentOfNodes.getName()};
            String subtaskMsg = ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Finding_existing_model_objects", params);
            monitor.subTask(subtaskMsg);
        }
        LinkedList relationalModelObjs = new LinkedList(modelObjs);
        Iterator modelObjIter = relationalModelObjs.iterator();
        while (modelObjIter.hasNext()) {
            Object modelObject = modelObjIter.next();
            if (modelObject instanceof RelationalEntity) continue;
            modelObjIter.remove();
        }
        matcher.findBestMatches(jdbcNodes, relationalModelObjs);
        Iterator iter = jdbcNodes.iterator();
        while (iter.hasNext()) {
            List childrenOfChild;
            if (monitor.isCanceled()) {
                throw new UserCancelledException();
            }
            JdbcNode child = (JdbcNode)iter.next();
            RelationalEntity match = (RelationalEntity)matcher.getDestination().get(child);
            if (match == null || (childrenOfChild = structure.getChildren(child)) == null) continue;
            EList childrenOfMatch = match.eContents();
            this.matchChildren(child, childrenOfChild, (List)childrenOfMatch, structure, matcher, monitor);
        }
    }

    public boolean isVerboseLogging() {
        return this.verbose;
    }

    public void setVerboseLogging(boolean b) {
        this.verbose = b;
    }

    public RelationalFactory getFactory() {
        return this.factory;
    }

    protected void setNameAndNameInSource(RelationalEntity entity, String name, JdbcNode node, Context context, List problems) {
        RelationalStringNameRule rule = new RelationalStringNameRule(0);
        StringNameValidator siblingNameValidator = new StringNameValidator();
        for (Object sibling : rule.getSiblingsForUniquenessCheck((EObject)entity)) {
            String siblingName;
            if (sibling == entity || (siblingName = ((RelationalEntity)sibling).getName()) == null) continue;
            siblingNameValidator.addExistingName(siblingName);
        }
        this.setNameAndNameInSource(entity, name, node, context, siblingNameValidator, false, problems);
    }

    protected void setNameAndNameInSource(RelationalEntity entity, String name, JdbcNode node, Context context, boolean ignoreFullyQualifiedName, List problems) {
        RelationalStringNameRule rule = new RelationalStringNameRule(0);
        StringNameValidator siblingNameValidator = new StringNameValidator();
        for (Object sibling : rule.getSiblingsForUniquenessCheck((EObject)entity)) {
            String siblingName;
            if (sibling == entity || (siblingName = ((RelationalEntity)sibling).getName()) == null) continue;
            siblingNameValidator.addExistingName(siblingName);
        }
        this.setNameAndNameInSource(entity, name, node, context, siblingNameValidator, ignoreFullyQualifiedName, problems);
    }

    private void setNameAndNameInSource(RelationalEntity entity, String name, JdbcNode node, Context context, StringNameValidator validator, boolean ignoreFullyQualifiedName, List problems) {
        String finalName;
        String theName = name;
        if (theName == null || theName.trim().length() == 0) {
            theName = this.createReplacementName(entity, context);
        }
        String convertedName = this.convertName(theName, context);
        String uniqueName = validator.createValidUniqueName(convertedName);
        boolean forceSetNameInSource = false;
        String nameInSource = convertedName;
        if (!ignoreFullyQualifiedName) {
            nameInSource = this.computeNameInSource(entity, name, node, context, forceSetNameInSource, problems);
            if (nameInSource != null) {
                entity.setNameInSource(nameInSource);
            }
        } else if (nameInSource != null) {
            String quoteStr = this.getQuoteString(context, problems);
            if (quoteStr != null && quoteStr.length() > 0) {
                nameInSource = String.valueOf(quoteStr) + CoreStringUtil.replaceAll((String)nameInSource, (String)quoteStr, (String)(String.valueOf(quoteStr) + quoteStr)) + quoteStr;
            }
            entity.setNameInSource(nameInSource);
        }
        JdbcImportSettings settings = context.getJdbcImportSettings();
        SourceNames sourceNames = settings.getGenerateSourceNamesInModel();
        int value = sourceNames.getValue();
        if (!ignoreFullyQualifiedName && value == 2) {
            uniqueName = nameInSource;
            String quoteStr = this.getQuoteString(context, problems);
            if (quoteStr != null && quoteStr.length() > 0) {
                uniqueName = nameInSource.replaceAll(quoteStr, "");
            }
        }
        if (uniqueName == null) {
            finalName = this.convertName(convertedName, context);
            entity.setName(finalName);
        } else {
            finalName = this.convertName(uniqueName, context);
            entity.setName(finalName);
            forceSetNameInSource = true;
        }
    }

    private String getQuoteString(Context context, List problems) {
        String quoteStr = null;
        try {
            quoteStr = context.getJdbcDatabase().getDatabaseMetaData().getIdentifierQuoteString();
        }
        catch (JdbcException ex) {
            String msg = String.valueOf(ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_quote_string", (Object)context.getJdbcDatabase().getName())) + ex.getLocalizedMessage();
            Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)ex);
            problems.add(status);
        }
        catch (SQLException ex) {
            String msg = String.valueOf(ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_quote_string", (Object)context.getJdbcDatabase().getName())) + ex.getLocalizedMessage();
            Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)ex);
            problems.add(status);
        }
        return quoteStr;
    }

    private ResultSet getCatalogs(Context context, List problems) {
        ResultSet catalogs = null;
        try {
            catalogs = context.getJdbcDatabase().getDatabaseMetaData().getCatalogs();
        }
        catch (JdbcException ex) {
            String msg = String.valueOf(ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_catalogs", (Object)context.getJdbcDatabase().getName())) + ex.getLocalizedMessage();
            Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)ex);
            problems.add(status);
        }
        catch (SQLException ex) {
            String msg = String.valueOf(ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_catalogs", (Object)context.getJdbcDatabase().getName())) + ex.getLocalizedMessage();
            Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)ex);
            problems.add(status);
        }
        return catalogs;
    }

    protected String convertName(String originalName, Context context) {
        String name = originalName;
        if (originalName != null) {
            JdbcImportSettings settings = context.getJdbcImportSettings();
            CaseConversion caseConversion = settings.getConvertCaseInModel();
            switch (caseConversion.getValue()) {
                case 2: {
                    return name.toLowerCase();
                }
                case 1: {
                    return name.toUpperCase();
                }
            }
        }
        return name;
    }

    private String addDoubleQuotesIfDotInName(String originalName) {
        if (originalName.indexOf(46) > -1) {
            return String.valueOf('\"') + originalName + '\"';
        }
        return originalName;
    }

    protected String createReplacementName(RelationalEntity entity, Context context) {
        return "New" + entity.eClass().getName();
    }

    protected String computeNameInSource(RelationalEntity object, String name, JdbcNode node, Context context, boolean forced, List problems) {
        String finalName;
        block16: {
            String fullyQualifiedName;
            if (name == null) {
                return null;
            }
            JdbcImportSettings settings = context.getJdbcImportSettings();
            boolean includeCatalogs = settings.isCreateCatalogsInModel();
            ResultSet cats = null;
            finalName = fullyQualifiedName = node.getFullyQualifiedName();
            if (!includeCatalogs) {
                try {
                    try {
                        String quoteStr = this.getQuoteString(context, problems);
                        cats = this.getCatalogs(context, problems);
                        if (cats == null) break block16;
                        int i = 0;
                        while (cats.next()) {
                            String catalogName = cats.getString(i + 1);
                            if (catalogName == null || catalogName.length() <= 0) continue;
                            String matchStr = String.valueOf(catalogName) + '.';
                            if (quoteStr != null) {
                                matchStr = String.valueOf(quoteStr) + catalogName + quoteStr + '.';
                            }
                            if (fullyQualifiedName.indexOf(matchStr) <= -1) continue;
                            finalName = fullyQualifiedName.replaceFirst(matchStr, "");
                            break;
                        }
                    }
                    catch (SQLException ex) {
                        String msg = String.valueOf(ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_catalogs", (Object)context.getJdbcDatabase().getName())) + ex.getLocalizedMessage();
                        Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)ex);
                        problems.add(status);
                        if (cats == null) break block16;
                        try {
                            cats.close();
                        }
                        catch (SQLException e) {
                            JdbcPlugin.Util.log((Throwable)e);
                        }
                    }
                }
                finally {
                    if (cats != null) {
                        try {
                            cats.close();
                        }
                        catch (SQLException e) {
                            JdbcPlugin.Util.log((Throwable)e);
                        }
                    }
                }
            }
        }
        return finalName;
    }

    public RelationalTypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(RelationalTypeMapping mapping) {
        this.typeMapping = mapping;
    }

    public void setDatatypeManager(DatatypeManager manager) {
        this.datatypeManager = manager;
    }

    protected DatatypeManager getDatatypeManager() {
        return this.datatypeManager;
    }

    protected void updateModelAnnotation(ModelAnnotation modelAnnotation) {
        modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
        modelAnnotation.setSupportsOuterJoin(true);
    }

    @Override
    public boolean getDebugLogTiming() {
        return this.debugTimingEnabled;
    }

    @Override
    public void setDebugLogTiming(boolean logTiming) {
        this.debugTimingEnabled = logTiming;
    }

    class ForeignKeySpec {
        public String fkName;
        public String pkName;
        public String pkCatalog;
        public String pkSchema;
        public String pkTable;

        ForeignKeySpec() {
        }
    }

    public class IndexSpec {
        public String indexName;
        public String indexQualifier;
        public String filterCondition;
        public int cardinality;
        public int pages;
        public int type;
        public boolean nonUnique;
        public List columns;
    }

    protected class WorkingArea {
        private final URI uri;
        private final EmfResource resource;
        private final Context context;

        protected WorkingArea(URI importUri, JdbcDatabase jdbcDatabase, JdbcImportSettings settings, IProgressMonitor monitor) {
            this.uri = importUri;
            this.resource = new MtkXmiResourceImpl(this.uri);
            ResourceSetImpl container = new ResourceSetImpl();
            container.getResources().add((Object)this.resource);
            this.context = new ContextImpl((Resource)this.resource, this.resource.getModelContents(), jdbcDatabase, settings, monitor);
            ModelAnnotation annotation = this.resource.getModelAnnotation();
            annotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            annotation.setModelType(ModelType.PHYSICAL_LITERAL);
        }

        public ModelContents getModelContents() {
            return this.resource.getModelContents();
        }

        public Resource getResource() {
            return this.resource;
        }

        public URI getUri() {
            return this.uri;
        }

        public Context getContext() {
            return this.context;
        }
    }
}

