/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational.impl;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcImportSettings;
import org.teiid.designer.jdbc.metadata.JdbcCatalog;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcNodeVisitor;
import org.teiid.designer.jdbc.metadata.JdbcProcedure;
import org.teiid.designer.jdbc.metadata.JdbcSchema;
import org.teiid.designer.jdbc.metadata.JdbcTable;
import org.teiid.designer.jdbc.relational.impl.Context;

public class JdbcModelStructure {
    private final Map childrenForParent = new HashMap();
    private final Map parentForChild = new HashMap();
    private int totalNodeCount;
    private int totalTablesAndProcedureCount;

    public static JdbcModelStructure build(Context context) throws JdbcException {
        JdbcDatabase dbNode = context.getJdbcDatabase();
        JdbcImportSettings settings = context.getJdbcImportSettings();
        boolean includeCatalogs = settings.isCreateCatalogsInModel();
        boolean includeSchemas = settings.isCreateSchemasInModel();
        return JdbcModelStructure.build(dbNode, includeCatalogs, includeSchemas);
    }

    protected static JdbcModelStructure build(JdbcDatabase dbNode, final boolean includeCatalog, final boolean includeSchema) throws JdbcException {
        final JdbcModelStructure model = new JdbcModelStructure();
        JdbcNodeVisitor visitor = new JdbcNodeVisitor(){

            public boolean visit(JdbcNode node) {
                if (node.getSelectionMode() == 0) {
                    return false;
                }
                if (node instanceof JdbcCatalog && !includeCatalog) {
                    return true;
                }
                if (node instanceof JdbcSchema && !includeSchema) {
                    return true;
                }
                JdbcNode parent = node.getParentDatabaseObject(includeCatalog, includeSchema);
                if (node.isDatabaseObject()) {
                    model.addChild(parent, node);
                }
                model.incrementNodeCount();
                if (node instanceof JdbcTable) {
                    model.incrementTableAndProcedureCount();
                } else if (node instanceof JdbcProcedure) {
                    model.incrementTableAndProcedureCount();
                } else if (!(node instanceof JdbcCatalog)) {
                    boolean cfr_ignored_0 = node instanceof JdbcSchema;
                }
                return true;
            }
        };
        dbNode.accept(visitor, 2);
        return model;
    }

    protected JdbcModelStructure() {
    }

    public List getChildren(JdbcNode parent) {
        return (List)this.childrenForParent.get(parent);
    }

    public boolean addChild(JdbcNode parent, JdbcNode child) {
        CoreArgCheck.isNotNull((Object)child);
        Object existingParent = this.parentForChild.get(child);
        if (existingParent != null) {
            return false;
        }
        LinkedList<JdbcNode> children = (LinkedList<JdbcNode>)this.childrenForParent.get(parent);
        if (children == null) {
            children = new LinkedList<JdbcNode>();
            this.childrenForParent.put(parent, children);
        }
        children.add(child);
        this.parentForChild.put(child, parent);
        return true;
    }

    public JdbcNode getParent(JdbcNode child) {
        return (JdbcNode)this.parentForChild.get(child);
    }

    public JdbcNode removeChild(JdbcNode child) {
        CoreArgCheck.isNotNull((Object)child);
        JdbcNode parent = (JdbcNode)this.parentForChild.remove(child);
        if (parent != null) {
            List children = this.getChildren(parent);
            CoreArgCheck.isNotNull((Object)children);
            boolean removed = children.remove(child);
            CoreArgCheck.isTrue((boolean)removed, (String)"There were no children for child even though child had a parent");
        }
        return parent;
    }

    public void print(PrintStream stream) {
        this.printChildren(null, "  ", "/", stream);
    }

    public void printChildren(JdbcNode parent, String parentPath, String delim, PrintStream stream) {
        List children = this.getChildren(parent);
        if (children == null) {
            return;
        }
        for (JdbcNode child : children) {
            String childPath = String.valueOf(parentPath) + delim + child.getName();
            stream.println(childPath);
            this.printChildren(child, childPath, delim, stream);
        }
    }

    public void print(StringBuffer sb) {
        this.printChildren(null, "  ", "/", sb);
    }

    public void printChildren(JdbcNode parent, String parentPath, String delim, StringBuffer sb) {
        List children = this.getChildren(parent);
        if (children == null) {
            return;
        }
        for (JdbcNode child : children) {
            String childPath = String.valueOf(parentPath) + delim + child.getName();
            sb.append(childPath);
            sb.append("\n");
            this.printChildren(child, childPath, delim, sb);
        }
    }

    public int getTotalNodeCount() {
        return this.totalNodeCount;
    }

    public int getTotalTablesAndProceduresCount() {
        return this.totalTablesAndProcedureCount;
    }

    public void setTotalNodeCount(int i) {
        this.totalNodeCount = i;
    }

    protected void incrementNodeCount() {
        ++this.totalNodeCount;
    }

    protected void incrementTableAndProcedureCount() {
        ++this.totalTablesAndProcedureCount;
    }
}

