/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.metadata.JdbcCatalog;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcProcedure;
import org.teiid.designer.jdbc.metadata.JdbcSchema;
import org.teiid.designer.jdbc.metadata.JdbcTable;
import org.teiid.designer.jdbc.relational.JdbcNodeToRelationalMapping;
import org.teiid.designer.jdbc.relational.ModelerJdbcRelationalConstants;
import org.teiid.designer.metamodels.relational.RelationalPackage;

public class JdbcNodeToRelationalMappingImpl
implements JdbcNodeToRelationalMapping {
    public static final String UBIQUITOUS_VIEW_NAME = "View";
    public static final String DEFAULT_VIEW_NAME = ModelerJdbcRelationalConstants.Util.getString("JdbcNodeToRelationalMappingImpl.ViewTableType", new Object[0]);
    private final Map tableTypeNameToEClassName = new HashMap();
    private final Map upperTableTypeNameToEClassName = new HashMap();

    public JdbcNodeToRelationalMappingImpl() {
        EClass viewClass = this.findClassifierById(7);
        String viewClassName = viewClass.getName();
        this.setRelationalClassForJdbcTableType(UBIQUITOUS_VIEW_NAME, viewClassName);
        this.setRelationalClassForJdbcTableType(DEFAULT_VIEW_NAME, viewClassName);
    }

    @Override
    public EClass getRelationalClassForJdbcNode(JdbcNode jdbcNode) {
        CoreArgCheck.isNotNull((Object)jdbcNode);
        if (jdbcNode instanceof JdbcCatalog) {
            return this.findClassifierById(8);
        }
        if (jdbcNode instanceof JdbcSchema) {
            return this.findClassifierById(2);
        }
        if (jdbcNode instanceof JdbcProcedure) {
            return this.findClassifierById(9);
        }
        if (jdbcNode instanceof JdbcTable) {
            EClassifier eClassForTypeName;
            String typeName = jdbcNode.getTypeName();
            String eClassName = this.getRelationalClassForJdbcTableType(typeName);
            if (eClassName != null && (eClassForTypeName = RelationalPackage.eINSTANCE.getEClassifier(eClassName)) != null && eClassForTypeName instanceof EClass) {
                return (EClass)eClassForTypeName;
            }
            return this.findClassifierById(0);
        }
        return null;
    }

    @Override
    public void setRelationalClassForJdbcTableType(String tableType, String eClassName) {
        CoreArgCheck.isNotNull((Object)tableType);
        CoreArgCheck.isNotNull((Object)eClassName);
        CoreArgCheck.isNotZeroLength((String)eClassName);
        this.tableTypeNameToEClassName.put(tableType, eClassName);
        this.upperTableTypeNameToEClassName.put(tableType.toUpperCase(), eClassName);
    }

    @Override
    public String getRelationalClassForJdbcTableType(String tableType) {
        if (tableType == null) {
            return null;
        }
        String exactMatch = (String)this.tableTypeNameToEClassName.get(tableType);
        if (exactMatch != null) {
            return exactMatch;
        }
        return (String)this.upperTableTypeNameToEClassName.get(tableType.toUpperCase());
    }

    protected EClass findClassifierById(int classifierId) {
        for (EClassifier classifier : RelationalPackage.eINSTANCE.getEClassifiers()) {
            if (classifier.getClassifierID() != classifierId || !(classifier instanceof EClass)) continue;
            return (EClass)classifier;
        }
        return null;
    }
}

