/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.jdbc.JdbcImportSettings;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.relational.impl.Context;

public class ContextImpl
implements Context {
    private final Resource resource;
    private final ModelContents modelContents;
    private final JdbcDatabase jdbcDatabase;
    private final JdbcImportSettings importSettings;
    private final IProgressMonitor monitor;
    private final List errors = new ArrayList();
    private final List warnings = new ArrayList();
    private final Map eObjectByIPath = new HashMap();
    private boolean verbose;

    public ContextImpl(Resource resource, ModelContents contents, JdbcDatabase jdbcDatabase, JdbcImportSettings settings, IProgressMonitor monitor) {
        this.resource = resource;
        this.modelContents = contents;
        this.jdbcDatabase = jdbcDatabase;
        this.importSettings = settings;
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
    }

    @Override
    public EObject findObject(IPath pathInModel) {
        CoreArgCheck.isNotNull((Object)pathInModel);
        EObject obj = (EObject)this.eObjectByIPath.get(pathInModel);
        return obj;
    }

    @Override
    public EObject addNewObject(IPath path, EObject obj) {
        return this.eObjectByIPath.put(path, obj);
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public ModelContents getModelContents() {
        return this.modelContents;
    }

    @Override
    public JdbcDatabase getJdbcDatabase() {
        return this.jdbcDatabase;
    }

    @Override
    public JdbcImportSettings getJdbcImportSettings() {
        return this.importSettings;
    }

    @Override
    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    @Override
    public List getErrors() {
        return this.errors;
    }

    @Override
    public List getWarnings() {
        return this.warnings;
    }

    @Override
    public void setVerboseLogging(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }
}

