/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.builder.execution.processor;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.teiid.designer.metamodels.builder.processor.Processor;

public abstract class AbstractProcessor
implements Processor {
    protected static final String DELIM = ".";
    private static final String PCT = "%";
    private static final String TABLE_NAME_COL = "TABLE_NAME";
    protected final Connection sqlConnection;
    protected final String modelAndSchemaName;

    public AbstractProcessor(Connection sqlConnection, String modelAndSchemaName) {
        this.sqlConnection = sqlConnection;
        this.modelAndSchemaName = modelAndSchemaName;
    }

    protected List getSchemaTables() throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        String schemaNamePattern = String.valueOf(this.modelAndSchemaName) + DELIM;
        int patternLength = schemaNamePattern.length();
        DatabaseMetaData metadata = this.sqlConnection.getMetaData();
        ResultSet tablesRS = metadata.getTables(null, null, String.valueOf(schemaNamePattern) + PCT, null);
        while (tablesRS.next()) {
            String tableName = tablesRS.getString(TABLE_NAME_COL);
            tableNames.add(tableName.substring(patternLength));
        }
        tablesRS.close();
        return tableNames;
    }

    protected ResultSet executeTableQuery(String tableName) throws SQLException {
        Statement stmt = this.sqlConnection.createStatement();
        String sql = "SELECT * FROM " + this.modelAndSchemaName + DELIM + tableName;
        return stmt.executeQuery(sql);
    }
}

