/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.builder.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.metamodels.builder.MetamodelEntityBuilder;
import org.teiid.designer.metamodels.builder.MetamodelEntityRecord;
import org.teiid.designer.metamodels.builder.execution.MetamodelBuilderConstants;
import org.teiid.designer.metamodels.builder.execution.MetamodelBuilderExecutionPlugin;
import org.teiid.designer.metamodels.builder.execution.util.MetamodelBuilderUtil;
import org.teiid.designer.metamodels.builder.util.MetaClassUriHelper;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.CorePackage;
import org.teiid.designer.metamodels.core.extension.util.ExtensionUtil;
import org.teiid.designer.metamodels.relational.util.RelationalUtil;

public class MetamodelEntityBuilderImpl
implements MetamodelEntityBuilder,
MetamodelBuilderConstants {
    private final MultiStatus status;
    private final ResourceSet resources;
    private boolean builderDebugEnabled = false;
    private static final String ENTITY_NAME = "Name";
    private MetamodelEntityRecord currentRecord;
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(MetamodelEntityBuilderImpl.class);

    private static String getString(String id) {
        return UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object param1) {
        return UTIL.getString(String.valueOf(I18N_PREFIX) + id, param1);
    }

    private static String getString(String id, Object param1, Object param2) {
        return UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[]{param1, param2});
    }

    public MetamodelEntityBuilderImpl(MultiStatus status, ResourceSet resources) {
        CoreArgCheck.isNotNull((Object)status);
        CoreArgCheck.isNotNull((Object)resources);
        CoreArgCheck.isNotEmpty((Collection)resources.getResources());
        this.status = status;
        this.resources = resources;
    }

    public EObject create(MetamodelEntityRecord record, IProgressMonitor monitor) {
        String metaClassUri;
        String ePkgUri;
        EPackage ePkg;
        CoreArgCheck.isNotNull((Object)record);
        this.currentRecord = record;
        EObject entity = null;
        boolean isExisting = false;
        String parentPath = record.getParentPath();
        Map featuresMap = record.getFeaturesNameValueMap();
        Object nameValue = featuresMap.get(ENTITY_NAME);
        if (nameValue != null) {
            String shortName = (String)nameValue;
            String fullPath = String.valueOf(parentPath) + "\\\\" + shortName;
            Object existingEntity = MetamodelBuilderUtil.findEObjectByPath(this.resources, fullPath, record.getMetaClassUri(), this.status);
            if (existingEntity != null && existingEntity instanceof EObject) {
                entity = (EObject)existingEntity;
                isExisting = true;
            }
        }
        if ((ePkg = MetamodelBuilderUtil.getEPackageForUri(ePkgUri = MetaClassUriHelper.getPackageUri((String)(metaClassUri = record.getMetaClassUri())), this.status)) == null) {
            return null;
        }
        EClass eClass = (EClass)MetamodelBuilderUtil.getEClassForUri(metaClassUri, this.status);
        if (eClass == null) {
            return null;
        }
        EFactory factory = ePkg.getEFactoryInstance();
        if (entity == null) {
            entity = factory.create(eClass);
        }
        if (entity == null) {
            String msg = MetamodelEntityBuilderImpl.getString("unableToCreateEntity", eClass.getName());
            MetamodelBuilderUtil.addStatus(this.status, 4, msg);
            if (this.builderDebugEnabled) {
                MetamodelBuilderExecutionPlugin.Util.log(4, msg);
            }
            return null;
        }
        this.process(entity, record, factory, isExisting);
        if (monitor != null) {
            monitor.worked(1);
        }
        return entity;
    }

    public List create(List records, IProgressMonitor monitor) {
        CoreArgCheck.isNotNull((Object)records);
        ArrayList<EObject> eObjs = new ArrayList<EObject>(records.size());
        Iterator iter = records.iterator();
        while (iter.hasNext()) {
            EObject eObj = this.create((MetamodelEntityRecord)iter.next(), monitor);
            if (eObj == null) continue;
            eObjs.add(eObj);
        }
        return eObjs;
    }

    private void process(EObject entity, MetamodelEntityRecord entityRecord, EFactory factory, boolean isExisting) {
        boolean added;
        if (!isExisting && !(added = this.addEntity(entity, entityRecord))) {
            return;
        }
        Map featuresMap = entityRecord.getFeaturesNameValueMap();
        if (!isExisting) {
            Object nameValue = featuresMap.get(ENTITY_NAME);
            if (entity != null && nameValue != null) {
                this.setFeatureValue(entity, factory, ENTITY_NAME, nameValue, isExisting);
            }
        }
        for (Map.Entry next : featuresMap.entrySet()) {
            String name = (String)next.getKey();
            Object value = next.getValue();
            if (name == null || entity == null || name.equals(ENTITY_NAME)) continue;
            this.setFeatureValue(entity, factory, name, value, isExisting);
        }
    }

    private boolean addEntity(EObject entity, MetamodelEntityRecord entityRecord) {
        String path = entityRecord.getParentPath();
        CoreArgCheck.isNotNull((Object)path);
        Resource rsrc = MetamodelBuilderUtil.findResource(this.resources, path);
        if (rsrc == null) {
            String msg = MetamodelEntityBuilderImpl.getString("noRsrc", entityRecord.getParentPath());
            MetamodelBuilderUtil.addStatus(this.status, 4, msg);
            if (this.builderDebugEnabled) {
                MetamodelBuilderExecutionPlugin.Util.log(4, msg);
            }
            return false;
        }
        Object parent = MetamodelBuilderUtil.findEObjectByPath(this.resources, path, entityRecord.getParentMetaClassUri(), this.status);
        if (parent == null) {
            String msg = MetamodelEntityBuilderImpl.getString("noParent", entity.eClass().getName(), entityRecord.getParentPath());
            MetamodelBuilderUtil.addStatus(this.status, 4, msg);
            if (this.builderDebugEnabled) {
                MetamodelBuilderExecutionPlugin.Util.log(4, msg);
            }
            return false;
        }
        return this.addChildToParent(rsrc, entity, parent);
    }

    private boolean addChildToParent(Resource rsrc, EObject child, Object parent) {
        if (parent instanceof Resource) {
            ((Resource)parent).getContents().add((Object)child);
            return true;
        }
        EObject parentEObj = (EObject)parent;
        int rsrcType = MetamodelBuilderUtil.getModelType(rsrc);
        boolean added = false;
        switch (rsrcType) {
            case 1: {
                added = RelationalUtil.addChildToParent((EObject)child, (EObject)parentEObj);
                break;
            }
            case 2: {
                added = ExtensionUtil.addChildToParent((EObject)child, (EObject)parentEObj);
            }
        }
        if (!added) {
            String msg = MetamodelEntityBuilderImpl.getString("noAdd", child.eClass().getName(), parentEObj.eClass().getName());
            MetamodelBuilderUtil.addStatus(this.status, 4, msg);
            if (this.builderDebugEnabled) {
                MetamodelBuilderExecutionPlugin.Util.log(4, msg);
            }
        }
        return added;
    }

    private boolean addFeatureValue(EObject eObject, String featureName, Object value) {
        EStructuralFeature feature = this.getFeature(eObject.eClass(), featureName, false);
        if (feature != null && feature.isMany()) {
            List values = (List)eObject.eGet(feature);
            if (value instanceof Collection) {
                return values.addAll((Collection)value);
            }
            return values.add(value);
        }
        return false;
    }

    private void setFeatureValue(EObject eObject, EFactory factory, String featureName, Object value, boolean isExisting) {
        block29: {
            if (value == null && !isExisting) {
                return;
            }
            try {
                if (featureName != null && featureName.equalsIgnoreCase("description")) {
                    this.setDescription(eObject, (String)value);
                    return;
                }
                EStructuralFeature feature = this.getFeature(eObject.eClass(), featureName, false);
                if (feature == null) {
                    EObject extension = MetamodelBuilderUtil.getExtension(eObject, this.status);
                    if (extension != null) {
                        this.setFeatureValue(extension, factory, featureName, value, isExisting);
                        return;
                    }
                    String msg = MetamodelEntityBuilderImpl.getString("noFeature", featureName, this.getEntityString(this.currentRecord, eObject));
                    MetamodelBuilderUtil.addStatus(this.status, 4, msg);
                    if (this.builderDebugEnabled) {
                        MetamodelBuilderExecutionPlugin.Util.log(4, msg);
                    }
                    return;
                }
                if (!feature.isChangeable()) {
                    String msg = MetamodelEntityBuilderImpl.getString("featureNotChangeable", featureName, this.getEntityString(this.currentRecord, eObject));
                    MetamodelBuilderUtil.addStatus(this.status, 2, msg);
                    if (this.builderDebugEnabled) {
                        MetamodelBuilderExecutionPlugin.Util.log(4, msg);
                    }
                    return;
                }
                if (feature instanceof EReference && value instanceof String) {
                    ArrayList<Object> refObjects = new ArrayList<Object>();
                    StringTokenizer refs = new StringTokenizer((String)value, ",");
                    Object first = null;
                    while (refs.hasMoreTokens()) {
                        String ref = refs.nextToken();
                        Object next = MetamodelBuilderUtil.findEObjectByPath(this.resources, ref, null, this.status);
                        if (next != null) {
                            refObjects.add(next);
                            if (first != null) continue;
                            first = next;
                            continue;
                        }
                        String msg = MetamodelEntityBuilderImpl.getString("badRef", ref, featureName);
                        MetamodelBuilderUtil.addStatus(this.status, 4, msg);
                        if (!this.builderDebugEnabled) continue;
                        MetamodelBuilderExecutionPlugin.Util.log(4, msg);
                    }
                    if (refObjects.size() == 1) {
                        this.setFeatureValue(eObject, factory, featureName, first, isExisting);
                    } else if (refObjects.size() > 1) {
                        this.setFeatureValue(eObject, factory, featureName, refObjects, isExisting);
                    }
                } else if (!feature.isMany()) {
                    if (value instanceof String && feature instanceof EAttribute) {
                        EDataType type = ((EAttribute)feature).getEAttributeType();
                        if (type instanceof EEnum) {
                            Object valObj = factory.createFromString(type, (String)value);
                            eObject.eSet(feature, valObj);
                        } else {
                            Object dtValue = EcoreFactory.eINSTANCE.createFromString(type, (String)value);
                            eObject.eSet(feature, dtValue);
                        }
                    } else if (value instanceof Character && feature instanceof EAttribute) {
                        EDataType type = ((EAttribute)feature).getEAttributeType();
                        if (type.getName().equalsIgnoreCase("EBoolean")) {
                            Boolean val = this.getBooleanForChar((Character)value);
                            eObject.eSet(feature, (Object)val);
                        }
                    } else {
                        eObject.eSet(feature, value);
                    }
                } else if (feature.isMany()) {
                    if (value != null) {
                        this.addFeatureValue(eObject, featureName, value);
                    } else {
                        String msg = MetamodelEntityBuilderImpl.getString("addNullToMultiFeature", featureName, this.getEntityString(this.currentRecord, eObject));
                        MetamodelBuilderUtil.addStatus(this.status, 2, msg);
                        if (this.builderDebugEnabled) {
                            MetamodelBuilderExecutionPlugin.Util.log(2, msg);
                        }
                    }
                }
            }
            catch (Exception err) {
                String msg = MetamodelEntityBuilderImpl.getString("errFeature", featureName, this.getEntityString(this.currentRecord, eObject));
                MetamodelBuilderUtil.addStatus(this.status, 4, msg, err);
                if (!this.builderDebugEnabled) break block29;
                MetamodelBuilderExecutionPlugin.Util.log(4, msg);
            }
        }
    }

    private Boolean getBooleanForChar(Character character) {
        Boolean result = null;
        char charValue = character.charValue();
        if (charValue == 't' || charValue == 'T' || charValue == '1' || charValue == 'Y' || charValue == 'y') {
            result = Boolean.TRUE;
        } else if (charValue == 'f' || charValue == 'F' || charValue == '0' || charValue == 'N' || charValue == 'n') {
            result = Boolean.FALSE;
        }
        return result;
    }

    private String getEntityString(MetamodelEntityRecord entityRecord, EObject eObject) {
        StringBuffer sb = new StringBuffer();
        if (eObject != null) {
            EClass ec = eObject.eClass();
            sb.append(String.valueOf(ec.getName()) + " ");
            if (entityRecord != null && entityRecord.getParentPath() != null) {
                sb.append(String.valueOf(entityRecord.getParentPath()) + "\\\\");
            } else {
                sb.append("UnknownPath\\\\");
            }
            EStructuralFeature nameFeature = this.getFeature(ec, ENTITY_NAME, false);
            if (nameFeature != null) {
                Object nameValue = eObject.eGet(nameFeature);
                if (nameValue != null) {
                    sb.append(nameValue.toString());
                } else {
                    sb.append("UnknownName");
                }
            }
        }
        return sb.toString();
    }

    private void setDescription(EObject eObject, String value) {
        Annotation existing;
        Resource eResource = eObject.eResource();
        if (eResource == null) {
            String msg = MetamodelEntityBuilderImpl.getString("noResource");
            MetamodelBuilderUtil.addStatus(this.status, 4, msg);
            if (this.builderDebugEnabled) {
                MetamodelBuilderExecutionPlugin.Util.log(4, msg);
            }
            return;
        }
        AnnotationContainer cntr = MetamodelBuilderUtil.getAnnotationContainer(eResource);
        if (cntr == null) {
            EFactory factory = CorePackage.eINSTANCE.getEFactoryInstance();
            cntr = (AnnotationContainer)factory.create(CorePackage.eINSTANCE.getAnnotationContainer());
            eResource.getContents().add((Object)cntr);
        }
        if ((existing = cntr.findAnnotation(eObject)) != null) {
            existing.setDescription(value);
        } else {
            EFactory factory = CorePackage.eINSTANCE.getEFactoryInstance();
            Annotation annot = (Annotation)factory.create(CorePackage.eINSTANCE.getAnnotation());
            annot.setAnnotatedObject(eObject);
            annot.setDescription(value);
            annot.setAnnotationContainer(cntr);
        }
    }

    private EStructuralFeature getFeature(EClass eClass, String featureName, boolean caseSensitiveMatch) {
        EStructuralFeature next;
        if (featureName == null) {
            return null;
        }
        if (caseSensitiveMatch && (next = eClass.getEStructuralFeature(featureName)) != null) {
            return next;
        }
        for (EStructuralFeature next2 : eClass.getEAllStructuralFeatures()) {
            if (!featureName.equalsIgnoreCase(next2.getName())) continue;
            return next2;
        }
        return null;
    }
}

