/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.tools.models.switchyard1_0.switchyard.DocumentRoot;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardPackage;
import org.switchyard.tools.models.switchyard1_0.switchyard.ValidateType;
import org.switchyard.tools.models.switchyard1_0.switchyard.ValidatesType;
import org.switchyard.tools.models.switchyard1_0.switchyard.util.SwitchyardResourceImpl;
import org.switchyard.tools.models.switchyard1_0.validate.JavaValidateType;
import org.switchyard.tools.models.switchyard1_0.validate.ValidateFactory;
import org.switchyard.tools.models.switchyard1_0.validate.XmlSchemaType;
import org.switchyard.tools.models.switchyard1_0.validate.XmlValidateType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public final class ValidatorTypesUtil {
    private Set<QName> _typeQNames = null;
    private ValidatesType _targetValidators = null;

    public ValidatorTypesUtil() {
        try {
            this._typeQNames = this.getTypesForConfig();
            this._targetValidators = this.loadValidatorsFromTarget();
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
    }

    public static List<ValidateType> getSupportedValidateTypes() {
        ArrayList<ValidateType> typeList = new ArrayList<ValidateType>();
        XmlValidateType xmlType = ValidateFactory.eINSTANCE.createXmlValidateType();
        xmlType.setSchemaType(XmlSchemaType.DTD);
        typeList.add((ValidateType)xmlType);
        JavaValidateType javaType = ValidateFactory.eINSTANCE.createJavaValidateType();
        typeList.add((ValidateType)javaType);
        return typeList;
    }

    private Set<QName> getTypesForConfig() throws Exception {
        if (this._typeQNames != null) {
            return this._typeQNames;
        }
        HashSet<QName> typesList = new HashSet<QName>();
        ArrayList<ServiceInterface> services = this.getOperationsForConfig();
        for (ServiceInterface baseService : services) {
            Set ops = baseService.getOperations();
            for (ServiceOperation serviceOperation : ops) {
                if (serviceOperation.getInputType() != null) {
                    typesList.add(serviceOperation.getInputType());
                }
                if (serviceOperation.getOutputType() != null) {
                    typesList.add(serviceOperation.getOutputType());
                }
                if (serviceOperation.getFaultType() == null) continue;
                typesList.add(serviceOperation.getFaultType());
            }
        }
        return typesList;
    }

    private ArrayList<ServiceInterface> getOperationsForConfig() throws Exception {
        Composite composite = this.getCompositeFromTarget();
        ArrayList<ServiceInterface> runtimeServices = new ArrayList<ServiceInterface>();
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JavaUtil.getProjectClassLoader((IJavaProject)JavaCore.create((IProject)SwitchyardSCAEditor.getActiveEditor().getTargetModelFile().getProject()), null));
        try {
            for (Service service : composite.getService()) {
                if (service.getInterface() == null) continue;
                runtimeServices.add(SwitchYardModelUtils.getServiceInterface((Interface)service.getInterface()));
            }
            for (Reference reference : composite.getReference()) {
                if (reference.getInterface() == null) continue;
                runtimeServices.add(SwitchYardModelUtils.getServiceInterface((Interface)reference.getInterface()));
            }
            for (Component component : composite.getComponent()) {
                for (ComponentService service : component.getService()) {
                    if (service.getInterface() == null) continue;
                    runtimeServices.add(SwitchYardModelUtils.getServiceInterface((Interface)service.getInterface()));
                }
                for (ComponentReference reference : component.getReference()) {
                    if (reference.getInterface() == null) continue;
                    runtimeServices.add(SwitchYardModelUtils.getServiceInterface((Interface)reference.getInterface()));
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
        return runtimeServices;
    }

    private Composite getCompositeFromTarget() {
        IFile target = SwitchyardSCAEditor.getActiveEditor().getTargetModelFile();
        if (target != null) {
            try {
                SwitchYardType switchyard = this.loadModelFile(target);
                return switchyard.getComposite();
            }
            catch (IOException e) {
                e.fillInStackTrace();
            }
        }
        return null;
    }

    private SwitchYardType loadModelFile(IFile file) throws IOException {
        DocumentRoot docroot;
        SwitchyardPackage.eINSTANCE.eClass();
        ResourceSet resourceSet = SwitchYardModelUtils.newResourceSet();
        URI modelUri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        SwitchyardResourceImpl resource = null;
        try {
            resource = (SwitchyardResourceImpl)resourceSet.getResource(modelUri, true);
        }
        catch (WrappedException wrappedException) {
            resource = (SwitchyardResourceImpl)resourceSet.getResource(modelUri, true);
        }
        catch (Exception exception) {
            resource = (SwitchyardResourceImpl)resourceSet.getResource(modelUri, true);
        }
        if (resource != null && resource.getContents() != null && resource.getContents().size() > 0 && (docroot = (DocumentRoot)resource.getContents().get(0)) != null) {
            SwitchYardType switchyard = docroot.getSwitchyard();
            return switchyard;
        }
        return null;
    }

    private String[] getTypesAsStrings(Set<QName> typesList) throws Exception {
        String[] outList = new String[typesList.size()];
        int count = 0;
        for (QName qName : typesList) {
            outList[count] = qName.toString();
            ++count;
        }
        return outList;
    }

    public String[] getTypesAsStringsForConfig() throws Exception {
        return this.getTypesAsStrings(this.getTypesForConfig());
    }

    private ValidatesType loadValidatorsFromTarget() {
        IFile target = SwitchyardSCAEditor.getActiveEditor().getTargetModelFile();
        if (target != null) {
            try {
                SwitchYardType switchyard = this.loadModelFile(target);
                if (switchyard != null && switchyard.getValidates() != null) {
                    return switchyard.getValidates();
                }
            }
            catch (IOException e) {
                e.fillInStackTrace();
            }
        }
        return null;
    }

    public ValidatesType getValidatorsFromTarget() {
        if (this._targetValidators != null) {
            return this._targetValidators;
        }
        return this.loadValidatorsFromTarget();
    }

    public boolean validatorExists(String name) {
        if (this.loadValidatorsFromTarget() != null && this.loadValidatorsFromTarget().getValidate() != null) {
            for (ValidateType targetValidatorType : this.loadValidatorsFromTarget().getValidate()) {
                boolean testToMatch = targetValidatorType.getName().equals(name);
                if (!testToMatch) continue;
                return true;
            }
        }
        return false;
    }
}

