/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.switchyard.DomainType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SecuritiesType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SecurityType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.ModelOperation;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class SecurityPolicyComposite
extends AbstractModelComposite<Contract> {
    private static final String CONFIDENTIALITY = "confidentiality";
    private static final String CLIENT_AUTHENTICATION = "clientAuthentication";
    private boolean _inUpdate = false;
    private Button _clientAuthCheckbox;
    private Button _confidentialityCheckbox;
    private Combo _securityCombo;
    private Contract _contract;
    private ArrayList<String> _supportedSecurityPolicies = new ArrayList();
    private static String _defaultValue = "default";

    public SecurityPolicyComposite(ICompositeContainer container, Composite parent, int style) {
        super(Contract.class, container, parent, style);
        this._supportedSecurityPolicies.add(CONFIDENTIALITY);
        this._supportedSecurityPolicies.add(CLIENT_AUTHENTICATION);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 6;
        layout.marginTop = 6;
        layout.marginLeft = 6;
        layout.marginRight = 6;
        this.setLayout((Layout)layout);
        FormToolkit factory = this.getWidgetFactory();
        this._clientAuthCheckbox = factory.createButton((Composite)this, Messages.label_clientAuthentication, 32);
        FormData data = new FormData();
        data.left = new FormAttachment(1, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        this._clientAuthCheckbox.setLayoutData((Object)data);
        this._clientAuthCheckbox.addSelectionListener((SelectionListener)new CheckboxSelectionListener());
        this._clientAuthCheckbox.setData((Object)CLIENT_AUTHENTICATION);
        this._confidentialityCheckbox = factory.createButton((Composite)this, Messages.label_confidentiality, 32);
        data = new FormData();
        data.left = new FormAttachment(1, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this._clientAuthCheckbox, 5, 0);
        this._confidentialityCheckbox.setLayoutData((Object)data);
        this._confidentialityCheckbox.addSelectionListener((SelectionListener)new CheckboxSelectionListener());
        this._confidentialityCheckbox.setData((Object)CONFIDENTIALITY);
        Label _securityComboLabel = factory.createLabel((Composite)this, Messages.label_securityConfiguration);
        data = new FormData();
        data.left = new FormAttachment(1, 0);
        data.top = new FormAttachment((Control)this._confidentialityCheckbox, 5, 0);
        _securityComboLabel.setLayoutData((Object)data);
        this._securityCombo = new Combo((Composite)this, 12);
        data = new FormData();
        data.left = new FormAttachment((Control)_securityComboLabel, 5, 0);
        data.top = new FormAttachment((Control)this._confidentialityCheckbox, 5, 0);
        data.right = new FormAttachment(100, 0);
        this._securityCombo.setLayoutData((Object)data);
        this._securityCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SecurityPolicyComposite.this.updateSecurity(SecurityPolicyComposite.this._contract, SecurityPolicyComposite.this._securityCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void updatePolicy(final EObject target, final Button control) {
        final String securityPolicy = (String)control.getData();
        this.wrapOperation(new Runnable(){

            @Override
            public void run() {
                if (target instanceof Contract) {
                    Contract contract = (Contract)target;
                    ArrayList<QName> requires = contract.getRequires();
                    ArrayList<String> existing = new ArrayList<String>();
                    if (requires != null) {
                        for (QName requiresItem : requires) {
                            String localPart = requiresItem.getLocalPart();
                            existing.add(localPart);
                        }
                        if (existing.contains(securityPolicy)) {
                            existing.remove(securityPolicy);
                        }
                    }
                    contract.setRequires(null);
                    requires = new ArrayList<QName>();
                    for (String existingItem : existing) {
                        QName newQName = new QName(existingItem);
                        requires.add(newQName);
                    }
                    if (control.getSelection()) {
                        QName newQName = new QName(securityPolicy);
                        requires.add(newQName);
                    }
                    if (!requires.isEmpty()) {
                        contract.setRequires(requires);
                    }
                } else if (target instanceof Implementation) {
                    Implementation impl = (Implementation)target;
                    ArrayList<QName> requires = impl.getRequires();
                    ArrayList<String> existing = new ArrayList<String>();
                    if (requires != null) {
                        for (QName requiresItem : requires) {
                            String localPart = requiresItem.getLocalPart();
                            existing.add(localPart);
                        }
                        if (existing.contains(securityPolicy)) {
                            existing.remove(securityPolicy);
                        }
                    }
                    impl.setRequires(null);
                    requires = new ArrayList<QName>();
                    for (String existingItem : existing) {
                        QName newQName = new QName(existingItem);
                        requires.add(newQName);
                    }
                    if (control.getSelection()) {
                        QName newQName = new QName(securityPolicy);
                        requires.add(newQName);
                    }
                    if (!requires.isEmpty()) {
                        impl.setRequires(requires);
                    }
                }
            }
        });
    }

    @Override
    public void refresh() {
        this._inUpdate = true;
        try {
            boolean clientAuthentication = false;
            boolean confidentiality = false;
            boolean showClientAuthCheckbox = true;
            boolean hasSecurityAttr = false;
            String securityName = null;
            Contract contract = (Contract)this.getTargetObject();
            if (contract != null) {
                this._contract = contract;
                List requires = contract.getRequires();
                if (requires != null) {
                    for (QName requiresItem : requires) {
                        String localPart = requiresItem.getLocalPart();
                        if (CLIENT_AUTHENTICATION.contentEquals(localPart)) {
                            clientAuthentication = true;
                        }
                        if (!CONFIDENTIALITY.contentEquals(localPart)) continue;
                        confidentiality = true;
                    }
                }
                if (contract.eContainer() instanceof Component && contract instanceof ComponentReference) {
                    showClientAuthCheckbox = false;
                }
                if (this.getFunkyAttributeValue(contract, "securityAttr") != null) {
                    hasSecurityAttr = true;
                    securityName = (String)this.getFunkyAttributeValue(contract, "securityAttr");
                } else {
                    securityName = "default";
                }
            }
            if (this._clientAuthCheckbox != null && !this._clientAuthCheckbox.isDisposed()) {
                this._clientAuthCheckbox.setEnabled(showClientAuthCheckbox);
                this._clientAuthCheckbox.setSelection(clientAuthentication);
            }
            if (this._confidentialityCheckbox != null && !this._confidentialityCheckbox.isDisposed()) {
                this._confidentialityCheckbox.setSelection(confidentiality);
            }
            if (this._securityCombo != null && !this._securityCombo.isDisposed()) {
                this.setupSecurityCombo(contract);
                if (hasSecurityAttr) {
                    this._securityCombo.setText(securityName);
                } else {
                    this._securityCombo.setText("default");
                }
            }
        }
        finally {
            this._inUpdate = false;
        }
    }

    private Object getFunkyAttributeValue(Contract object, String propertyName) {
        for (FeatureMap.Entry entry : object.getAnyAttribute()) {
            String name = entry.getEStructuralFeature().getName();
            if (!name.contentEquals(propertyName) || !name.equals("securityAttr")) continue;
            String value = (String)entry.getValue();
            return value;
        }
        return null;
    }

    private void setupSecurityCombo(Contract object) {
        this._securityCombo.removeAll();
        Contract parent = object;
        while (parent != null && parent.eContainer() != null && !(parent instanceof SwitchYardType)) {
            parent = parent.eContainer();
        }
        if (parent != null && parent instanceof SwitchYardType) {
            SecuritiesType securities;
            SwitchYardType root = (SwitchYardType)parent;
            DomainType domain = root.getDomain();
            if (domain != null && (securities = domain.getSecurities()) != null) {
                for (SecurityType security : securities.getSecurity()) {
                    String name = "default";
                    if (security.getName() != null) {
                        name = security.getName();
                    }
                    this._securityCombo.add(name);
                    this._securityCombo.setData(name, (Object)security);
                }
            }
            if (this._securityCombo.getItemCount() > 0) {
                boolean foundDefault = false;
                int i = 0;
                while (i < this._securityCombo.getItems().length) {
                    String array_element = this._securityCombo.getItems()[i];
                    if (array_element.contentEquals(_defaultValue)) {
                        foundDefault = true;
                        break;
                    }
                    ++i;
                }
                if (!foundDefault) {
                    this._securityCombo.add(_defaultValue);
                }
            }
        } else {
            this._securityCombo.add(_defaultValue);
        }
        if (this._securityCombo.getItemCount() > 1) {
            this._securityCombo.setEnabled(true);
        } else {
            this._securityCombo.setEnabled(false);
        }
    }

    private void updateSecurity(final Contract contract, final String securityName) {
        this.wrapOperation(new Runnable(){

            @Override
            public void run() {
                FunkyAttributeContractOperation operation = new FunkyAttributeContractOperation(contract, "securityAttr", securityName);
                try {
                    operation.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private class CheckboxSelectionListener
    implements SelectionListener {
        private CheckboxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Contract contract = (Contract)SecurityPolicyComposite.this.getTargetObject();
            if (contract != null && !SecurityPolicyComposite.this._inUpdate) {
                Button button = (Button)e.widget;
                SecurityPolicyComposite.this.updatePolicy((EObject)contract, button);
            }
        }
    }

    private class FunkyAttributeContractOperation
    extends ModelOperation {
        private Contract _localObject;
        private String _localFeature;
        private Object _localValue;

        public FunkyAttributeContractOperation(Contract object, String featureId, Object value) {
            this._localObject = object;
            this._localFeature = featureId;
            this._localValue = value;
        }

        private void setFunkyAttributeValue(EAttribute attribute, String propertyName, Object propertyValue) {
            Iterator iter = this._localObject.getAnyAttribute().iterator();
            boolean foundIt = false;
            while (iter.hasNext()) {
                FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
                String name = entry.getEStructuralFeature().getName();
                if (!name.contentEquals(propertyName)) continue;
                if (propertyValue != null) {
                    this._localObject.getAnyAttribute().add((EStructuralFeature)attribute, propertyValue);
                } else {
                    this._localObject.getAnyAttribute().set((EStructuralFeature)attribute, null);
                }
                foundIt = true;
                break;
            }
            if (!foundIt) {
                this._localObject.getAnyAttribute().add((EStructuralFeature)attribute, propertyValue);
            }
        }

        @Override
        public void run() throws Exception {
            if (this._localFeature.contentEquals("securityAttr")) {
                if (this._localValue instanceof String && !((String)this._localValue).contentEquals(_defaultValue)) {
                    this.setFunkyAttributeValue(SwitchyardPackage.eINSTANCE.getDocumentRoot_SecurityAttr(), "securityAttr", this._localValue);
                } else {
                    this.setFunkyAttributeValue(SwitchyardPackage.eINSTANCE.getDocumentRoot_SecurityAttr(), "securityAttr", null);
                }
            }
        }
    }
}

