/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.platform.GFPropertySection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public abstract class AbstractTabbedPropertySection<T extends EObject>
extends GFPropertySection
implements ITabbedPropertyConstants,
ICompositeContainer,
ResourceSetListener {
    private TransactionalEditingDomain _domain = null;
    private TabbedPropertySheetPage _page;
    private AbstractModelComposite<T> _composite;
    private DataBindingContext _context = new EMFDataBindingContext();
    private ObservablesManager _observablesManager = new ObservablesManager();

    protected AbstractTabbedPropertySection() {
        this._observablesManager.addObservablesFromContext(this._context, true, true);
    }

    @Override
    public FormToolkit getToolkit() {
        return this._page.getWidgetFactory();
    }

    @Override
    public void validated(IStatus status) {
    }

    @Override
    public void layout() {
        if (this._page == null) {
            return;
        }
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!AbstractTabbedPropertySection.this._page.getControl().isDisposed()) {
                    AbstractTabbedPropertySection.this._page.resizeScrolledComposite();
                }
            }
        });
    }

    public void createControls(final Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this._page = aTabbedPropertySheetPage;
        this._observablesManager.runAndCollect(new Runnable(){

            @Override
            public void run() {
                AbstractTabbedPropertySection.this._composite = AbstractTabbedPropertySection.this.createComposite(parent, 0);
            }
        });
        this.getToolkit().adapt(this._composite);
    }

    protected abstract AbstractModelComposite<T> createComposite(Composite var1, int var2);

    @Override
    public EObject getSelectedBusinessObject() {
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe == null) {
            return null;
        }
        return Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
    }

    public void refresh() {
        super.refresh();
        if (this._composite == null || this._composite.isDisposed()) {
            return;
        }
        this._composite.refresh();
    }

    public void aboutToBeShown() {
        this.addDomainListener();
        super.aboutToBeShown();
    }

    public void aboutToBeHidden() {
        this.removeDomainListener();
        super.aboutToBeHidden();
    }

    private void addDomainListener() {
        if (this._domain == null) {
            this._domain = (TransactionalEditingDomainImpl)SwitchyardSCAEditor.getEditor(this.getSelectedBusinessObject()).getEditingDomain();
            this._domain.addResourceSetListener((ResourceSetListener)this);
        }
    }

    private void removeDomainListener() {
        if (this._domain != null) {
            this._domain.removeResourceSetListener((ResourceSetListener)this);
            this._domain = null;
        }
    }

    public void dispose() {
        this.removeDomainListener();
        if (this._composite != null) {
            this._composite.dispose();
            this._composite = null;
        }
        this._observablesManager.dispose();
        this._context.dispose();
        super.dispose();
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent arg0) {
        if (this._page != null && this._page.getControl() != null && !this._page.getControl().isDisposed()) {
            this._page.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractTabbedPropertySection.this.refresh();
                }
            });
        }
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent arg0) throws RollbackException {
        return null;
    }

    @Override
    public DataBindingContext getDataBindingContext() {
        return this._context;
    }

    @Override
    public ObservablesManager getObservablesManager() {
        return this._observablesManager;
    }
}

