/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.switchyard.EsbInterface;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.AbstractSwitchyardComposite;
import org.switchyard.tools.ui.editor.diagram.shared.IInterfaceComposite;

public class ESBInterfaceSelectionComposite
extends AbstractSwitchyardComposite
implements IInterfaceComposite {
    private Composite _panel;
    private Interface _interface = null;
    private Text _inputTypeText;
    private Text _outputTypeText;
    private Text _faultTypeText;
    private String _inputType = null;
    private String _outputType = null;
    private String _faultType = null;

    public ESBInterfaceSelectionComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = this.getToolkit().createComposite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this._panel.setLayout((Layout)gl);
        if (this.getRootGridData() != null) {
            this._panel.setLayoutData((Object)this.getRootGridData());
        }
        this._inputTypeText = this.createLabelAndText(this._panel, Messages.label_inputTypeStar);
        this._outputTypeText = this.createLabelAndText(this._panel, Messages.label_outputTypeStar);
        this._faultTypeText = this.createLabelAndText(this._panel, Messages.label_faultType);
    }

    @Override
    public Interface getInterface() {
        return this._interface;
    }

    @Override
    public void setInterface(Interface cInterface) {
        this._interface = cInterface;
        if (this._interface != null && this._interface instanceof EsbInterface) {
            this.setInUpdate(true);
            EsbInterface esbIntfc = (EsbInterface)this._interface;
            if (esbIntfc.getInputType() != null) {
                this._inputType = esbIntfc.getInputType();
                this._inputTypeText.setText(this._inputType);
            }
            if (esbIntfc.getOutputType() != null) {
                this._outputType = esbIntfc.getOutputType();
                this._outputTypeText.setText(this._outputType);
            }
            if (esbIntfc.getFaultType() != null) {
                this._faultType = esbIntfc.getFaultType();
                this._faultTypeText.setText(this._faultType);
            }
            this.setInUpdate(false);
            this.addObservableListeners();
        }
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    protected boolean validate() {
        if (this._inputTypeText != null && !this._inputTypeText.isDisposed() && this._inputTypeText.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.error_noInputTypeForEsbInterface);
        } else if (this._faultTypeText != null && !this._faultTypeText.isDisposed() && !this._faultTypeText.getText().trim().isEmpty() && this._outputTypeText != null && !this._outputTypeText.isDisposed() && this._outputTypeText.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.error_noOutputTypeForEsbInterfaceWithFault);
        }
        return this.getErrorMessage() == null;
    }

    @Override
    protected void handleModify(Control control) {
        this.validate();
        if (this._interface != null) {
            if (control.equals(this._inputTypeText)) {
                this._inputType = this._inputTypeText.getText().trim();
                this.updateFeature((EObject)this._interface, "inputType", this._inputType);
            } else if (control.equals(this._outputTypeText)) {
                this._outputType = this._outputTypeText.getText().trim();
                this.updateFeature((EObject)this._interface, "outputType", this._outputType);
            } else if (control.equals(this._faultTypeText)) {
                this._faultType = this._faultTypeText.getText().trim();
                this.updateFeature((EObject)this._interface, "faultType", this._faultType);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this._interface != null && !this.inUpdate() && this.hasChanged()) {
            this.validate();
            this.handleModify((Control)e.getSource());
            this.fireChangedEvent((Control)e.getSource());
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 27) {
            this.setInUpdate(true);
            if (this._interface != null) {
                EsbInterface esbIntfc = (EsbInterface)this._interface;
                Control control = (Control)e.getSource();
                if (control.equals(this._inputTypeText)) {
                    this._inputTypeText.setText(esbIntfc.getInputType());
                    this._inputType = esbIntfc.getInputType();
                } else if (control.equals(this._outputTypeText)) {
                    this._outputTypeText.setText(esbIntfc.getOutputType());
                    this._outputType = esbIntfc.getOutputType();
                } else if (control.equals(this._faultTypeText)) {
                    this._faultTypeText.setText(esbIntfc.getFaultType());
                    this._faultType = esbIntfc.getFaultType();
                }
                this.handleModify(control);
            }
            this.setInUpdate(false);
        } else if (e.keyCode == 13) {
            if (this._interface != null && !this.inUpdate() && this.hasChanged()) {
                this.validate();
                this.handleModify((Control)e.getSource());
                this.fireChangedEvent((Control)e.getSource());
            }
        } else if (e.keyCode == 9 && this._interface != null && !this.inUpdate() && this.hasChanged()) {
            boolean flag = this.validate();
            if (flag) {
                this.handleModify((Control)e.getSource());
            }
            this.fireChangedEvent((Control)e.getSource());
        }
    }

    @Override
    public void modifyText(ModifyEvent e) {
        super.modifyText(e);
        this._inputType = this._inputTypeText.getText().trim();
        this._outputType = this._outputTypeText.getText().trim();
        this._faultType = this._faultTypeText.getText().trim();
    }
}

