/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.databinding;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.SwitchYardModelUtils;

public class AccessibleResourceValidator
implements IValidator {
    private final IObservableValue _target;

    public AccessibleResourceValidator(IObservableValue target) {
        this._target = target;
    }

    public IStatus validate(Object value) {
        if (value == null || ((String)value).trim().isEmpty()) {
            return Status.OK_STATUS;
        }
        IProject project = this.resolveCurrentProject();
        if (project == null || !project.getProject().isAccessible()) {
            return new Status(2, "org.switchyard.tools.ui.editor", "Cannot verify accessibility of specified resource.");
        }
        if (SwitchYardModelUtils.getJavaResource((IProject)project, (String)((String)value)) != null) {
            return Status.OK_STATUS;
        }
        return new Status(2, "org.switchyard.tools.ui.editor", "Specified resource is not on the project's classpath.");
    }

    private IProject resolveCurrentProject() {
        try {
            return PlatformResourceAdapterFactory.getContainingProject((Object)this._target.getValue());
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

