/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.soap;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.switchyard.tools.models.switchyard1_0.soap.InterceptorType;
import org.switchyard.tools.models.switchyard1_0.soap.PropertyType;
import org.switchyard.tools.models.switchyard1_0.soap.SOAPFactory;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.components.soap.InterceptorPropertyInputDialog;
import org.switchyard.tools.ui.editor.components.soap.InterceptorPropertyTable;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class InterceptorTypeInputDialog
extends TitleAreaDialog {
    private Text _classNameText;
    private Button _browseButton;
    private InterceptorType _interceptor = null;
    private InterceptorPropertyTable _interceptorPropertyTable;

    public InterceptorTypeInputDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.title_newInterceptorDetails);
        this.setMessage(Messages.description_newInterceptorDetails);
        this.getShell().setText(Messages.title_addInterceptor);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        area.setLayout((Layout)gridLayout);
        area.setLayoutData((Object)new GridData(1808));
        this._classNameText = this.createLabelAndText(area, Messages.label_classNameStar);
        if (this._interceptor != null && this._interceptor.getClass_() != null && !this._interceptor.getClass_().trim().isEmpty()) {
            this._classNameText.setText(this._interceptor.getClass_());
            this.getShell().setText(Messages.title_editInterceptor);
            this.setTitle(Messages.title_interceptorDetails);
            this.setMessage(Messages.description_interceptorDetails);
        }
        this._classNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InterceptorTypeInputDialog.this._interceptor.setClass(InterceptorTypeInputDialog.this._classNameText.getText().trim());
            }
        });
        this._browseButton = new Button(area, 8);
        this._browseButton.setText(Messages.button_browse);
        this._browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterceptorTypeInputDialog.this.handleBrowse();
                InterceptorTypeInputDialog.this.validate();
            }
        });
        Group propertyGroup = new Group(area, 0);
        propertyGroup.setText(Messages.label_interceptorProperties);
        propertyGroup.setLayout((Layout)new GridLayout(1, false));
        GridData grpGD = new GridData(4, 4, true, false);
        grpGD.horizontalSpan = 3;
        propertyGroup.setLayoutData((Object)grpGD);
        this._interceptorPropertyTable = new InterceptorPropertyTable((Composite)propertyGroup, 0){

            @Override
            protected void removeFromList() {
                PropertyType toRemove = InterceptorTypeInputDialog.this._interceptorPropertyTable.getTableSelection();
                if (toRemove != null) {
                    InterceptorTypeInputDialog.this.removeInterceptorProperty(toRemove);
                }
            }

            @Override
            protected void addPropertyTypeToList() {
                InterceptorPropertyInputDialog dialog = new InterceptorPropertyInputDialog(Display.getCurrent().getActiveShell());
                int rtn_value = dialog.open();
                if (rtn_value == 0) {
                    String name = dialog.getPropertyName();
                    String value = dialog.getPropertyValue();
                    InterceptorTypeInputDialog.this.addInterceptorProperty(name, value);
                    InterceptorTypeInputDialog.this._interceptorPropertyTable.setSelection((EList<PropertyType>)InterceptorTypeInputDialog.this._interceptor.getProperties().getProperty());
                }
            }
        };
        this._interceptorPropertyTable.setLayoutData(new GridData(4, 1, true, false, 1, 5));
        if (this._interceptor != null && this._interceptor.getProperties() != null && this._interceptor.getProperties().getProperty() != null) {
            this._interceptorPropertyTable.setSelection((EList<PropertyType>)this._interceptor.getProperties().getProperty());
        }
        return area;
    }

    private void handleBrowse() {
        IJavaSearchScope scope = null;
        IProject project = SwitchyardSCAEditor.getActiveEditor().getModelFile().getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        scope = javaProject == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Display.getCurrent().getActiveShell(), null, (IJavaSearchScope)scope, (int)2, (boolean)false);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                if (result.length > 0 && result[0] instanceof IType) {
                    IType clazz = (IType)result[0];
                    this._classNameText.setText(clazz.getFullyQualifiedName());
                    this._interceptor.setClass(clazz.getFullyQualifiedName());
                }
                this.getButton(0).setEnabled(this.validate());
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control rtnControl = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.validate());
        this.setErrorMessage(null);
        return rtnControl;
    }

    protected Text createLabelAndText(Composite parent, String label) {
        new Label(parent, 0).setText(label);
        Text newText = new Text(parent, 2048);
        newText.setLayoutData((Object)new GridData(4, 0, true, false));
        newText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                InterceptorTypeInputDialog.this.getButton(0).setEnabled(InterceptorTypeInputDialog.this.validate());
            }
        });
        newText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                InterceptorTypeInputDialog.this.getButton(0).setEnabled(InterceptorTypeInputDialog.this.validate());
            }
        });
        return newText;
    }

    protected boolean validate() {
        this.setErrorMessage(null);
        if (this._classNameText.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.error_noInterceptorClass);
        }
        return this.getErrorMessage() == null;
    }

    public void setInterceptor(InterceptorType interceptor) {
        this._interceptor = interceptor;
    }

    public InterceptorType getInterceptor() {
        return this._interceptor;
    }

    private void removeInterceptorProperty(PropertyType property) {
        if (this._interceptor != null) {
            this._interceptor.getProperties().getProperty().remove((Object)property);
        }
    }

    private void addInterceptorProperty(String name, String value) {
        if (this._interceptor != null) {
            if (this._interceptor.getProperties() == null) {
                this._interceptor.setProperties(SOAPFactory.eINSTANCE.createPropertiesType());
            }
            PropertyType property = SOAPFactory.eINSTANCE.createPropertyType();
            property.setName(name);
            property.setValue(value);
            this._interceptor.getProperties().getProperty().add((Object)property);
        }
    }
}

