/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.soap;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.switchyard.tools.models.switchyard1_0.soap.InterceptorType;
import org.switchyard.tools.models.switchyard1_0.soap.PropertyType;
import org.switchyard.tools.ui.editor.Messages;

public abstract class InterceptorPropertyTable
extends Composite
implements ICellModifier {
    private TreeViewer _propertyTreeTable;
    public static final String NAME_COLUMN = "name";
    public static final String VALUE_COLUMN = "value";
    private static final String[] TREE_COLUMNS = new String[]{"name", "value"};
    private Button _mAddButton;
    private Button _mRemoveButton;
    private boolean _isReadOnly = false;
    private EObject _targetObj = null;
    private String _mWarning = null;
    private ListenerList _changeListeners;

    public InterceptorPropertyTable(Composite parent, int style) {
        this(parent, style, false);
    }

    public InterceptorPropertyTable(Composite parent, int style, boolean isReadOnly) {
        super(parent, style);
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this._propertyTreeTable = new TreeViewer((Composite)this, 0x10A40 | additionalStyles);
        this._propertyTreeTable.setAutoExpandLevel(-1);
        GridData gd11 = new GridData(4, 4, true, true, 1, 5);
        gd11.heightHint = 100;
        this._propertyTreeTable.getTree().setLayoutData((Object)gd11);
        this._propertyTreeTable.getTree().setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(this._propertyTreeTable.getTree(), 16384);
        nameColumn.setText(Messages.label_name);
        nameColumn.setWidth(200);
        TreeColumn valueColumn = new TreeColumn(this._propertyTreeTable.getTree(), 16384);
        valueColumn.setText(Messages.label_value);
        valueColumn.setWidth(200);
        this._propertyTreeTable.setColumnProperties(TREE_COLUMNS);
        this._propertyTreeTable.setLabelProvider((IBaseLabelProvider)new PropertyTypeTreeLabelProvider());
        this._propertyTreeTable.setContentProvider((IContentProvider)new PropertyTypeTreeContentProvider());
        this._propertyTreeTable.setCellModifier((ICellModifier)this);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = new TextCellEditor((Composite)this._propertyTreeTable.getTree());
        this._propertyTreeTable.setCellEditors(cellEditorArray);
        this._mAddButton = new Button((Composite)this, 0);
        this._mAddButton.setLayoutData((Object)new GridData(256));
        this._mAddButton.setText(Messages.button_add);
        this._mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterceptorPropertyTable.this.addPropertyTypeToList();
                InterceptorPropertyTable.this._propertyTreeTable.refresh();
                InterceptorPropertyTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._mAddButton.setEnabled(false);
        this._propertyTreeTable.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterceptorPropertyTable.this.updatePropertyTypeButtons();
            }
        });
        this._mRemoveButton = new Button((Composite)this, 0);
        this._mRemoveButton.setLayoutData((Object)new GridData(256));
        this._mRemoveButton.setText(Messages.button_remove);
        this._mRemoveButton.setEnabled(false);
        this._mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterceptorPropertyTable.this.removeFromList();
                InterceptorPropertyTable.this._propertyTreeTable.refresh();
                InterceptorPropertyTable.this.fireChangedEvent(e.getSource());
            }
        });
        this.updatePropertyTypeButtons();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    protected abstract void addPropertyTypeToList();

    protected abstract void removeFromList();

    public EList<PropertyType> getSelection() {
        if (this._propertyTreeTable != null && this._propertyTreeTable.getInput() != null) {
            return (EList)this._propertyTreeTable.getInput();
        }
        return null;
    }

    public PropertyType getTableSelection() {
        IStructuredSelection ssel;
        if (this._propertyTreeTable != null && !this._propertyTreeTable.getSelection().isEmpty() && (ssel = (IStructuredSelection)this._propertyTreeTable.getSelection()).getFirstElement() instanceof PropertyType) {
            return (PropertyType)ssel.getFirstElement();
        }
        return null;
    }

    public void updatePropertyTypeButtons() {
        if (this._isReadOnly) {
            this._mAddButton.setEnabled(false);
            this._mRemoveButton.setEnabled(false);
        } else {
            this._mAddButton.setEnabled(true);
            if (this.getSelection() != null) {
                this._mRemoveButton.setEnabled(true);
            }
        }
    }

    public void setSelection(EList<PropertyType> properties) {
        this._propertyTreeTable.setInput(properties);
        this.updatePropertyTypeButtons();
    }

    public String getWarning() {
        return this._mWarning;
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
    }

    protected EObject getTargetObject() {
        return this._targetObj;
    }

    protected void setFeatureValue(EObject eObject, String featureId, Object value) {
        EClass eClass = eObject.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable() && eStructuralFeature.getName().equalsIgnoreCase(featureId)) {
                eObject.eSet(eStructuralFeature, value);
                break;
            }
            ++i;
        }
    }

    public boolean canModify(Object element, String property) {
        return element instanceof PropertyType && property.equalsIgnoreCase(VALUE_COLUMN);
    }

    public Object getValue(Object element, String property) {
        if (element instanceof PropertyType && property.equalsIgnoreCase(VALUE_COLUMN)) {
            return ((PropertyType)element).getValue();
        }
        return null;
    }

    public void modify(Object element, String property, final Object value) {
        if (element instanceof TreeItem && property.equalsIgnoreCase(VALUE_COLUMN)) {
            final TreeItem ti = (TreeItem)element;
            if (this.getTargetObject() instanceof InterceptorType) {
                InterceptorType domainType = (InterceptorType)this.getTargetObject();
                if (domainType.eContainer() != null) {
                    TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)domainType);
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            PropertyType parm = (PropertyType)ti.getData();
                            InterceptorPropertyTable.this.setFeatureValue((EObject)parm, InterceptorPropertyTable.VALUE_COLUMN, value);
                            InterceptorPropertyTable.this.getTreeViewer().refresh(true);
                        }
                    });
                } else {
                    PropertyType parm = (PropertyType)ti.getData();
                    this.setFeatureValue((EObject)parm, VALUE_COLUMN, value);
                    this.getTreeViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected TreeViewer getTreeViewer() {
        return this._propertyTreeTable;
    }

    private class PropertyTypeTreeContentProvider
    implements ITreeContentProvider {
        private EList<PropertyType> _properties;

        private PropertyTypeTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof EList) {
                this._properties = (EList)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EList) {
                return this._properties.toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PropertyType[]) {
                return new Object[]{this._properties.toArray()};
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof PropertyType) {
                return ((PropertyType)element).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof EList) {
                return ((EList)element).size() > 0;
            }
            return false;
        }
    }

    private class PropertyTypeTreeLabelProvider
    implements ITableLabelProvider {
        private PropertyTypeTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            if (element instanceof PropertyType && property.equalsIgnoreCase(InterceptorPropertyTable.NAME_COLUMN)) {
                return true;
            }
            return element instanceof PropertyType && property.equalsIgnoreCase(InterceptorPropertyTable.VALUE_COLUMN);
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PropertyType && columnIndex == 0) {
                return ((PropertyType)element).getName();
            }
            if (element instanceof PropertyType && columnIndex == 1) {
                PropertyType tp = (PropertyType)element;
                return tp.getValue();
            }
            return null;
        }
    }
}

