/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.rules;

import java.util.Collection;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.switchyard.tools.models.switchyard1_0.rules.MappingType;
import org.switchyard.tools.models.switchyard1_0.rules.RulesFactory;
import org.switchyard.tools.models.switchyard1_0.rules.RulesOperationType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.TableColumnLayout;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class RulesMappingsTable
extends Composite
implements ICellModifier {
    private TableViewer _propertyTreeTable;
    public static final String FROM_COLUMN = "from";
    public static final String TO_COLUMN = "to";
    private final List<String> _treeColumns;
    private Button _mAddButton;
    private Button _mRemoveButton;
    private boolean _isReadOnly = false;
    private EObject _targetObj = null;
    private String _mWarning = null;
    private ListenerList _changeListeners;
    private final EReference _mappingsFeature;
    private final EReference _actionVariableFeature;
    private final String _defaultFrom;
    private final String _defaultTo;

    public RulesMappingsTable(Composite parent, int style, String defaultFrom, String defaultTo, EReference actionVariableFeature, EReference mappingsFeature, List<String> columns) {
        this(parent, style, false, defaultFrom, defaultTo, actionVariableFeature, mappingsFeature, columns);
    }

    public RulesMappingsTable(Composite parent, int style, boolean isReadOnly, String defaultFrom, String defaultTo, EReference actionVariableFeature, EReference mappingsFeature, List<String> columns) {
        super(parent, style);
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        this._actionVariableFeature = actionVariableFeature;
        this._mappingsFeature = mappingsFeature;
        this._defaultFrom = defaultFrom;
        this._defaultTo = defaultTo;
        this._treeColumns = columns;
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Composite tableComposite = new Composite((Composite)this, additionalStyles);
        GridData gd11 = new GridData(4, 4, true, false, 1, 2);
        gd11.heightHint = 100;
        tableComposite.setLayoutData((Object)gd11);
        this._propertyTreeTable = new TableViewer(tableComposite, 0x10A40 | additionalStyles);
        this._propertyTreeTable.getTable().setHeaderVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        if (this._treeColumns.contains(FROM_COLUMN)) {
            TableColumn expressionColumn = new TableColumn(this._propertyTreeTable.getTable(), 16384);
            expressionColumn.setText(Messages.label_from);
            tableLayout.setColumnData((Widget)expressionColumn, (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        }
        if (this._treeColumns.contains(TO_COLUMN)) {
            TableColumn variableColumn = new TableColumn(this._propertyTreeTable.getTable(), 16384);
            variableColumn.setText(Messages.label_to);
            tableLayout.setColumnData((Widget)variableColumn, (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        }
        this._propertyTreeTable.setColumnProperties(this._treeColumns.toArray(new String[this._treeColumns.size()]));
        this._propertyTreeTable.setLabelProvider((IBaseLabelProvider)new PropertyTreeLabelProvider());
        this._propertyTreeTable.setContentProvider((IContentProvider)new PropertyTreeContentProvider());
        this._propertyTreeTable.setCellModifier((ICellModifier)this);
        if (this._treeColumns.size() == 2) {
            this._propertyTreeTable.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this._propertyTreeTable.getTable()), new TextCellEditor((Composite)this._propertyTreeTable.getTable())});
        } else {
            this._propertyTreeTable.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this._propertyTreeTable.getTable())});
        }
        this._mAddButton = new Button((Composite)this, 0);
        this._mAddButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mAddButton.setText(Messages.button_add);
        this._mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RulesMappingsTable.this.addPropertyToList();
                if (RulesMappingsTable.this._propertyTreeTable.getInput() == null) {
                    RulesMappingsTable.this._propertyTreeTable.setInput((Object)RulesMappingsTable.this._targetObj);
                }
                RulesMappingsTable.this._propertyTreeTable.refresh();
                RulesMappingsTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._mAddButton.setEnabled(false);
        this._propertyTreeTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RulesMappingsTable.this.updatePropertyButtons();
            }
        });
        this._mRemoveButton = new Button((Composite)this, 0);
        this._mRemoveButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mRemoveButton.setText(Messages.button_remove);
        this._mRemoveButton.setEnabled(false);
        this._mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RulesMappingsTable.this.removeFromList();
                RulesMappingsTable.this._propertyTreeTable.refresh();
                RulesMappingsTable.this.fireChangedEvent(e.getSource());
            }
        });
        this.updatePropertyButtons();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    protected void addPropertyToList() {
        if (this.getTargetObject() instanceof RulesOperationType) {
            final RulesOperationType impl = (RulesOperationType)this.getTargetObject();
            final MappingType newMapping = RulesFactory.eINSTANCE.createMappingType();
            newMapping.setFrom(this._defaultFrom);
            newMapping.setTo(this._defaultTo);
            if (impl.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        Object mappings;
                        Object variableContainer = impl.eGet((EStructuralFeature)RulesMappingsTable.this._actionVariableFeature);
                        if (variableContainer == null) {
                            EClass variableContainerClass = RulesMappingsTable.this._actionVariableFeature.getEReferenceType();
                            variableContainer = variableContainerClass.getEPackage().getEFactoryInstance().create(variableContainerClass);
                            impl.eSet((EStructuralFeature)RulesMappingsTable.this._actionVariableFeature, variableContainer);
                        }
                        if (variableContainer instanceof EObject && (mappings = ((EObject)variableContainer).eGet((EStructuralFeature)RulesMappingsTable.this._mappingsFeature)) instanceof Collection) {
                            ((Collection)mappings).add(newMapping);
                        }
                        RulesMappingsTable.this.getTableViewer().refresh(true);
                    }
                });
            } else {
                Object mappings;
                Object variableContainer = impl.eGet((EStructuralFeature)this._actionVariableFeature);
                if (variableContainer == null) {
                    EClass variableContainerClass = this._actionVariableFeature.getEReferenceType();
                    variableContainer = variableContainerClass.getEPackage().getEFactoryInstance().create(variableContainerClass);
                    impl.eSet((EStructuralFeature)this._actionVariableFeature, variableContainer);
                }
                if (variableContainer instanceof EObject && (mappings = ((EObject)variableContainer).eGet((EStructuralFeature)this._mappingsFeature)) instanceof Collection) {
                    ((Collection)mappings).add(newMapping);
                }
                this.getTableViewer().refresh(true);
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected void removeFromList() {
        if (this.getTargetObject() instanceof RulesOperationType) {
            final RulesOperationType impl = (RulesOperationType)this.getTargetObject();
            final MappingType actionToRemove = this.getTableSelection();
            if (impl.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        Object mappings;
                        Object variableContainer = impl.eGet((EStructuralFeature)RulesMappingsTable.this._actionVariableFeature);
                        if (variableContainer instanceof EObject && (mappings = ((EObject)variableContainer).eGet((EStructuralFeature)RulesMappingsTable.this._mappingsFeature)) instanceof Collection) {
                            ((Collection)mappings).remove(actionToRemove);
                        }
                        RulesMappingsTable.this.getTableViewer().refresh(true);
                    }
                });
            } else {
                Object mappings;
                Object variableContainer = impl.eGet((EStructuralFeature)this._actionVariableFeature);
                if (variableContainer instanceof EObject && (mappings = ((EObject)variableContainer).eGet((EStructuralFeature)this._mappingsFeature)) instanceof Collection) {
                    ((Collection)mappings).remove(actionToRemove);
                }
                this.getTableViewer().refresh(true);
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected MappingType getTableSelection() {
        IStructuredSelection ssel;
        if (this._propertyTreeTable != null && !this._propertyTreeTable.getSelection().isEmpty() && (ssel = (IStructuredSelection)this._propertyTreeTable.getSelection()).getFirstElement() instanceof MappingType) {
            return (MappingType)ssel.getFirstElement();
        }
        return null;
    }

    public void updatePropertyButtons() {
        if (this._isReadOnly) {
            this._mAddButton.setEnabled(false);
            this._mRemoveButton.setEnabled(false);
        } else {
            this._mAddButton.setEnabled(true);
            if (this.getTableSelection() != null) {
                this._mRemoveButton.setEnabled(true);
            }
        }
    }

    public String getWarning() {
        return this._mWarning;
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
        this._propertyTreeTable.setInput((Object)target);
        this.updatePropertyButtons();
    }

    protected EObject getTargetObject() {
        return this._targetObj;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof MappingType && property.equalsIgnoreCase(FROM_COLUMN)) {
            if (((MappingType)element).getFrom() != null) {
                return ((MappingType)element).getFrom();
            }
            return "";
        }
        if (element instanceof MappingType && property.equalsIgnoreCase(TO_COLUMN)) {
            if (((MappingType)element).getTo() != null) {
                return ((MappingType)element).getTo();
            }
            return "";
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (element instanceof TableItem && property.equalsIgnoreCase(FROM_COLUMN)) {
            final TableItem ti = (TableItem)element;
            if (this.getTargetObject() instanceof RulesOperationType) {
                String newValue;
                RulesOperationType impl = (RulesOperationType)this.getTargetObject();
                String string = newValue = value == null || ((String)value).length() == 0 ? null : (String)value;
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            MappingType parm = (MappingType)ti.getData();
                            parm.setFrom(newValue);
                            RulesMappingsTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    MappingType parm = (MappingType)ti.getData();
                    parm.setFrom(newValue);
                    this.getTableViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        } else if (element instanceof TableItem && property.equalsIgnoreCase(TO_COLUMN)) {
            final TableItem ti = (TableItem)element;
            if (this.getTargetObject() instanceof RulesOperationType) {
                String newValue;
                RulesOperationType impl = (RulesOperationType)this.getTargetObject();
                String string = newValue = value == null || ((String)value).length() == 0 ? null : (String)value;
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            MappingType parm = (MappingType)ti.getData();
                            parm.setTo(newValue);
                            RulesMappingsTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    MappingType parm = (MappingType)ti.getData();
                    parm.setTo(newValue);
                    this.getTableViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected TableViewer getTableViewer() {
        return this._propertyTreeTable;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._mAddButton.setEnabled(enabled);
        this._mRemoveButton.setEnabled(enabled);
        this._propertyTreeTable.getTable().setEnabled(enabled);
        if (enabled) {
            this.updatePropertyButtons();
        }
    }

    private class PropertyTreeContentProvider
    implements IStructuredContentProvider {
        private PropertyTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Object mappings;
            EObject object;
            Object variableContainer;
            if (inputElement instanceof EObject && (variableContainer = (object = (EObject)inputElement).eGet((EStructuralFeature)RulesMappingsTable.this._actionVariableFeature)) instanceof EObject && (mappings = ((EObject)variableContainer).eGet((EStructuralFeature)RulesMappingsTable.this._mappingsFeature)) instanceof Collection) {
                return ((Collection)mappings).toArray();
            }
            return new Object[0];
        }
    }

    private class PropertyTreeLabelProvider
    implements ITableLabelProvider {
        private PropertyTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            if (element instanceof MappingType && property.equalsIgnoreCase(RulesMappingsTable.FROM_COLUMN)) {
                return true;
            }
            return element instanceof MappingType && property.equalsIgnoreCase(RulesMappingsTable.TO_COLUMN);
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MappingType) {
                if (columnIndex == 0) {
                    if (RulesMappingsTable.FROM_COLUMN.equals(RulesMappingsTable.this._treeColumns.get(0))) {
                        return ((MappingType)element).getFrom();
                    }
                    return ((MappingType)element).getTo();
                }
                if (columnIndex == 1) {
                    if (RulesMappingsTable.FROM_COLUMN.equals(RulesMappingsTable.this._treeColumns.get(1))) {
                        return ((MappingType)element).getFrom();
                    }
                    return ((MappingType)element).getTo();
                }
            }
            return null;
        }
    }
}

