/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.rules;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.switchyard.tools.models.switchyard1_0.rules.ContainerType;
import org.switchyard.tools.models.switchyard1_0.rules.ManifestType;
import org.switchyard.tools.models.switchyard1_0.rules.OperationsType;
import org.switchyard.tools.models.switchyard1_0.rules.RemoteJmsType;
import org.switchyard.tools.models.switchyard1_0.rules.RemoteRestType;
import org.switchyard.tools.models.switchyard1_0.rules.ResourcesType;
import org.switchyard.tools.models.switchyard1_0.rules.RulesFactory;
import org.switchyard.tools.models.switchyard1_0.rules.RulesImplementationType;
import org.switchyard.tools.models.switchyard1_0.rules.RulesOperationType;
import org.switchyard.tools.models.switchyard1_0.rules.RulesPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.components.rules.KIEContainerDetailsComposite;
import org.switchyard.tools.ui.editor.components.rules.RemoteJMSContainerDetailsComposite;
import org.switchyard.tools.ui.editor.components.rules.RemoteRestContainerDetailsComposite;
import org.switchyard.tools.ui.editor.components.rules.RulesActionTable;
import org.switchyard.tools.ui.editor.components.rules.RulesChannelTable;
import org.switchyard.tools.ui.editor.components.rules.RulesEventListenerTable;
import org.switchyard.tools.ui.editor.components.rules.RulesLoggerTable;
import org.switchyard.tools.ui.editor.components.rules.RulesMappingsTable;
import org.switchyard.tools.ui.editor.components.rules.RulesPropertyTable;
import org.switchyard.tools.ui.editor.components.rules.RulesResourceTable;
import org.switchyard.tools.ui.editor.property.AbstractChangeAwareModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class RulesImplementationComposite
extends AbstractChangeAwareModelComposite<Component> {
    private Composite _panel;
    private Button _resourcesRadio;
    private Button _containerRadio;
    private Button _remoteJMSRadio;
    private Button _remoteRESTRadio;
    private StackLayout _manifestLayout;
    private RulesResourceTable _resourcesTable;
    private KIEContainerDetailsComposite _containerDetailsControls;
    private RemoteJMSContainerDetailsComposite _remoteJMSContainerDetailsControls;
    private RemoteRestContainerDetailsComposite _remoteRestContainerDetailsControls;
    private RulesActionTable _actionsTable;
    private RulesMappingsTable _inputsTable;
    private RulesMappingsTable _outputsTable;
    private RulesMappingsTable _faultsTable;
    private RulesMappingsTable _globalsTable;
    private RulesPropertyTable _propertiesTable;
    private RulesLoggerTable _loggersTable;
    private RulesEventListenerTable _listenersTable;
    private RulesChannelTable _channelsTable;
    private RulesImplementationType _implementation;
    private ResourcesType _resources;
    private ContainerType _container;
    private RemoteJmsType _remoteJms;
    private RemoteRestType _remoteRest;
    private boolean _updating;

    public RulesImplementationComposite(ICompositeContainer container, Composite parent, int style) {
        super(Component.class, container, parent, style);
        FormToolkit factory = this.getWidgetFactory();
        this._panel = this;
        this._panel.setLayout((Layout)new GridLayout());
        final TabFolder folder = new TabFolder(this._panel, 128);
        factory.adapt((Composite)folder);
        folder.setLayout(new Layout(){

            protected void layout(Composite composite, boolean flushCache) {
                Rectangle rect = composite.getClientArea();
                TabItem[] selected = folder.getSelection();
                if (selected == null || selected.length == 0) {
                    return;
                }
                selected[0].getControl().setBounds(rect);
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                if (wHint != -1 && hHint != -1) {
                    return new Point(wHint, hHint);
                }
                int maxWidth = 0;
                int maxHeight = 0;
                TabItem[] selected = folder.getSelection();
                if (selected != null && selected.length > 0) {
                    Point pt = selected[0].getControl().computeSize(wHint, hHint, flushCache);
                    maxWidth = Math.max(0, pt.x);
                    maxHeight = Math.max(0, pt.y);
                }
                if (wHint != -1) {
                    maxWidth = Math.max(wHint, maxWidth);
                }
                if (hHint != -1) {
                    maxWidth = Math.max(hHint, maxHeight);
                }
                return new Point(maxWidth, maxHeight);
            }
        });
        folder.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem resources = new TabItem(folder, 0);
        TabItem actions = new TabItem(folder, 0);
        TabItem advanced = new TabItem(folder, 0);
        resources.setText(Messages.label_general);
        actions.setText(Messages.label_operations);
        advanced.setText(Messages.label_advanced);
        this.createResourcesControls(folder, resources);
        this.createActionsControls(folder, actions);
        this.createAdvancedControls(folder, advanced);
        folder.setSelection(0);
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulesImplementationComposite.this.getContainer().layout();
            }
        });
        this.adaptChildren((Control)folder);
    }

    @Override
    public void refresh() {
        RulesOperationType selectedOp = null;
        if (this._implementation != null && this._actionsTable.getTableSelection() != null) {
            selectedOp = this._actionsTable.getTableSelection();
        }
        this._implementation = null;
        Component bo = (Component)this.getTargetObject();
        if (bo != null) {
            Implementation rawImpl = bo.getImplementation();
            this._implementation = rawImpl instanceof RulesImplementationType ? (RulesImplementationType)rawImpl : null;
            if (this._implementation != null && this._implementation.getManifest() != null) {
                this._resources = this._implementation.getManifest().getResources();
                this._container = this._implementation.getManifest().getContainer();
                this._remoteJms = this._implementation.getManifest().getRemoteJms();
                this._remoteRest = this._implementation.getManifest().getRemoteRest();
            }
        }
        this._updating = true;
        try {
            this._resourcesTable.setTargetObject((EObject)this._implementation);
            this._actionsTable.setTargetObject((EObject)this._implementation);
            if (selectedOp != null) {
                OperationsType ops = this._implementation.getOperations();
                if (ops != null && ops.getOperation() != null && !ops.getOperation().isEmpty()) {
                    for (RulesOperationType op : ops.getOperation()) {
                        if (op.getName() != null && op.getName().equals(selectedOp.getName())) {
                            this._actionsTable.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)op));
                        } else if (selectedOp.getName() != null && selectedOp.getName().equals(selectedOp.getName())) {
                            this._actionsTable.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)op));
                        } else {
                            if (selectedOp.getName() != null || op.getName() != null) continue;
                            this._actionsTable.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)op));
                        }
                        break;
                    }
                } else {
                    this._actionsTable.getTableViewer().setSelection(null);
                }
            }
            this._propertiesTable.setTargetObject((EObject)this._implementation);
            this._loggersTable.setTargetObject((EObject)this._implementation);
            this._listenersTable.setTargetObject((EObject)this._implementation);
            this._channelsTable.setTargetObject((EObject)this._implementation);
            if (this._resources != null && this._container == null && this._remoteJms == null && this._remoteRest == null) {
                this._resourcesRadio.setSelection(true);
                this._containerRadio.setSelection(false);
                this._remoteJMSRadio.setSelection(false);
                this._remoteRESTRadio.setSelection(false);
                this._manifestLayout.topControl = this._resourcesTable;
                this._resourcesTable.getParent().layout();
                this._container = RulesFactory.eINSTANCE.createContainerType();
                this._remoteJms = RulesFactory.eINSTANCE.createRemoteJmsType();
                this._remoteRest = RulesFactory.eINSTANCE.createRemoteRestType();
            } else if (this._resources == null && this._container != null && this._remoteJms == null && this._remoteRest == null) {
                this._resourcesRadio.setSelection(false);
                this._containerRadio.setSelection(true);
                this._remoteJMSRadio.setSelection(false);
                this._remoteRESTRadio.setSelection(false);
                this._manifestLayout.topControl = this._containerDetailsControls;
                this._containerDetailsControls.getParent().layout();
                this._resources = RulesFactory.eINSTANCE.createResourcesType();
                this._remoteJms = RulesFactory.eINSTANCE.createRemoteJmsType();
                this._remoteRest = RulesFactory.eINSTANCE.createRemoteRestType();
            } else if (this._resources == null && this._container == null && this._remoteJms != null && this._remoteRest == null) {
                this._resourcesRadio.setSelection(false);
                this._containerRadio.setSelection(false);
                this._remoteJMSRadio.setSelection(true);
                this._remoteRESTRadio.setSelection(false);
                this._manifestLayout.topControl = this._remoteJMSContainerDetailsControls;
                this._remoteJMSContainerDetailsControls.getParent().layout();
                this._resources = RulesFactory.eINSTANCE.createResourcesType();
                this._container = RulesFactory.eINSTANCE.createContainerType();
                this._remoteRest = RulesFactory.eINSTANCE.createRemoteRestType();
            } else if (this._resources == null && this._container == null && this._remoteJms == null && this._remoteRest != null) {
                this._resourcesRadio.setSelection(false);
                this._containerRadio.setSelection(false);
                this._remoteJMSRadio.setSelection(false);
                this._remoteRESTRadio.setSelection(true);
                this._manifestLayout.topControl = this._remoteRestContainerDetailsControls;
                this._remoteRestContainerDetailsControls.getParent().layout();
                this._resources = RulesFactory.eINSTANCE.createResourcesType();
                this._container = RulesFactory.eINSTANCE.createContainerType();
                this._remoteJms = RulesFactory.eINSTANCE.createRemoteJmsType();
            } else {
                this._resourcesRadio.setSelection(true);
                this._containerRadio.setSelection(false);
                this._remoteJMSRadio.setSelection(false);
                this._remoteRESTRadio.setSelection(false);
                this._manifestLayout.topControl = this._resourcesTable;
                this._resourcesTable.getParent().layout();
                this._container = RulesFactory.eINSTANCE.createContainerType();
                this._remoteJms = RulesFactory.eINSTANCE.createRemoteJmsType();
                this._remoteRest = RulesFactory.eINSTANCE.createRemoteRestType();
            }
            this._containerDetailsControls.setContainer(this._container);
            this._remoteRestContainerDetailsControls.setRemoteREST(this._remoteRest);
            this._remoteJMSContainerDetailsControls.setRemoteJMS(this._remoteJms);
        }
        finally {
            this._updating = false;
        }
        this.getContainer().validated(this.validate());
    }

    private void createResourcesControls(TabFolder folder, TabItem item) {
        FormToolkit factory = this.getWidgetFactory();
        Composite control = factory.createComposite((Composite)folder);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        Section resourcesSection = factory.createSection(control, 320);
        resourcesSection.setBackgroundMode(0);
        resourcesSection.setText(Messages.label_manifest);
        resourcesSection.setLayout((Layout)new GridLayout(2, false));
        resourcesSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite resourcesComposite = factory.createComposite((Composite)resourcesSection);
        resourcesComposite.setLayout((Layout)new GridLayout());
        resourcesComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        resourcesSection.setClient((Control)resourcesComposite);
        Composite resourceButtonsComposite = factory.createComposite(resourcesComposite);
        resourceButtonsComposite.setLayout((Layout)new RowLayout());
        resourceButtonsComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (RulesImplementationComposite.this._resourcesRadio.getSelection()) {
                    RulesImplementationComposite.this.swapResourceControls((Control)RulesImplementationComposite.this._resourcesTable, (EObject)RulesImplementationComposite.this._resources);
                } else if (RulesImplementationComposite.this._remoteJMSRadio.getSelection()) {
                    RulesImplementationComposite.this.swapResourceControls((Control)RulesImplementationComposite.this._remoteJMSContainerDetailsControls, (EObject)RulesImplementationComposite.this._remoteJms);
                } else if (RulesImplementationComposite.this._remoteRESTRadio.getSelection()) {
                    RulesImplementationComposite.this.swapResourceControls((Control)RulesImplementationComposite.this._remoteRestContainerDetailsControls, (EObject)RulesImplementationComposite.this._remoteRest);
                } else {
                    RulesImplementationComposite.this.swapResourceControls((Control)RulesImplementationComposite.this._containerDetailsControls, (EObject)RulesImplementationComposite.this._container);
                }
            }
        };
        this._resourcesRadio = factory.createButton(resourceButtonsComposite, Messages.label_definedResources, 16);
        this._resourcesRadio.addSelectionListener((SelectionListener)radioListener);
        this._containerRadio = factory.createButton(resourceButtonsComposite, Messages.label_knowledgeContainer, 16);
        this._containerRadio.addSelectionListener((SelectionListener)radioListener);
        this._remoteJMSRadio = factory.createButton(resourceButtonsComposite, "Remote JMS", 16);
        this._remoteJMSRadio.addSelectionListener((SelectionListener)radioListener);
        this._remoteRESTRadio = factory.createButton(resourceButtonsComposite, "Remote REST", 16);
        this._remoteRESTRadio.addSelectionListener((SelectionListener)radioListener);
        Composite resourceDetailsComposite = factory.createComposite(resourcesComposite);
        this._manifestLayout = new StackLayout();
        resourceDetailsComposite.setLayout((Layout)this._manifestLayout);
        resourceDetailsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this._resourcesTable = new RulesResourceTable(resourceDetailsComposite, 0);
        this._resourcesTable.setLayoutData(new GridData(4, 4, true, true));
        factory.adapt((Composite)this._resourcesTable);
        this.createContainerDetailsControls(resourceDetailsComposite);
        item.setControl((Control)control);
    }

    private void swapResourceControls(Control topControl, final EObject newResourceObject) {
        this._manifestLayout.topControl = topControl;
        topControl.getParent().layout();
        if (!this._updating) {
            ManifestType manifest = this._implementation.getManifest();
            final boolean createManifest = manifest == null;
            this.wrapOperation(new Runnable(){

                @Override
                public void run() {
                    if (createManifest) {
                        RulesImplementationComposite.this._implementation.setManifest(RulesFactory.eINSTANCE.createManifestType());
                    }
                    if (newResourceObject instanceof ResourcesType) {
                        RulesImplementationComposite.this._resources = (ResourcesType)newResourceObject;
                        RulesImplementationComposite.this._implementation.getManifest().setResources(RulesImplementationComposite.this._resources);
                        RulesImplementationComposite.this._implementation.getManifest().setContainer(null);
                        RulesImplementationComposite.this._implementation.getManifest().setRemoteJms(null);
                        RulesImplementationComposite.this._implementation.getManifest().setRemoteRest(null);
                    } else if (newResourceObject instanceof ContainerType) {
                        RulesImplementationComposite.this._container = (ContainerType)newResourceObject;
                        RulesImplementationComposite.this._implementation.getManifest().setContainer(RulesImplementationComposite.this._container);
                        RulesImplementationComposite.this._implementation.getManifest().setResources(null);
                        RulesImplementationComposite.this._implementation.getManifest().setRemoteJms(null);
                        RulesImplementationComposite.this._implementation.getManifest().setRemoteRest(null);
                    } else if (newResourceObject instanceof RemoteJmsType) {
                        RulesImplementationComposite.this._remoteJms = (RemoteJmsType)newResourceObject;
                        RulesImplementationComposite.this._implementation.getManifest().setRemoteJms(RulesImplementationComposite.this._remoteJms);
                        RulesImplementationComposite.this._implementation.getManifest().setResources(null);
                        RulesImplementationComposite.this._implementation.getManifest().setContainer(null);
                        RulesImplementationComposite.this._implementation.getManifest().setRemoteRest(null);
                    } else if (newResourceObject instanceof RemoteRestType) {
                        RulesImplementationComposite.this._remoteRest = (RemoteRestType)newResourceObject;
                        RulesImplementationComposite.this._implementation.getManifest().setRemoteRest(RulesImplementationComposite.this._remoteRest);
                        RulesImplementationComposite.this._implementation.getManifest().setResources(null);
                        RulesImplementationComposite.this._implementation.getManifest().setContainer(null);
                        RulesImplementationComposite.this._implementation.getManifest().setRemoteJms(null);
                    }
                }
            });
        }
    }

    private void createContainerDetailsControls(Composite parent) {
        this._containerDetailsControls = new KIEContainerDetailsComposite(parent, this.getWidgetFactory());
        this._remoteJMSContainerDetailsControls = new RemoteJMSContainerDetailsComposite(this.getContainer(), parent, 0, this.getWidgetFactory());
        this._remoteRestContainerDetailsControls = new RemoteRestContainerDetailsComposite(this.getContainer(), parent, 0, this.getWidgetFactory());
    }

    private void createActionsControls(TabFolder folder, TabItem item) {
        FormToolkit factory = this.getWidgetFactory();
        Composite control = factory.createComposite((Composite)folder);
        control.setLayout((Layout)new GridLayout(2, false));
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite actionsComposite = factory.createComposite(control);
        actionsComposite.setLayout((Layout)new GridLayout());
        actionsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Section actionsSection = factory.createSection(actionsComposite, 320);
        actionsSection.setBackgroundMode(0);
        actionsSection.setText(Messages.label_operations);
        actionsSection.setLayout((Layout)new GridLayout());
        actionsSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this._actionsTable = new RulesActionTable((Composite)actionsSection, 0);
        this._actionsTable.setLayoutData(new GridData(4, 4, true, true));
        factory.adapt((Composite)this._actionsTable);
        actionsSection.setClient((Control)this._actionsTable);
        this._actionsTable.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = event.getSelection().isEmpty() ? null : ((IStructuredSelection)event.getSelection()).getFirstElement();
                RulesImplementationComposite.this._inputsTable.setTargetObject((EObject)((RulesOperationType)selected));
                RulesImplementationComposite.this._outputsTable.setTargetObject((EObject)((RulesOperationType)selected));
                RulesImplementationComposite.this._globalsTable.setTargetObject((EObject)((RulesOperationType)selected));
                RulesImplementationComposite.this._faultsTable.setTargetObject((EObject)((RulesOperationType)selected));
                RulesImplementationComposite.this._inputsTable.setEnabled(selected != null);
                RulesImplementationComposite.this._outputsTable.setEnabled(selected != null);
                RulesImplementationComposite.this._globalsTable.setEnabled(selected != null);
                RulesImplementationComposite.this._faultsTable.setEnabled(selected != null);
            }
        });
        Composite mappingsComposite = factory.createComposite(control);
        mappingsComposite.setLayout((Layout)new GridLayout());
        mappingsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Section globalsSection = factory.createSection(mappingsComposite, 258);
        globalsSection.setBackgroundMode(0);
        globalsSection.setText(Messages.label_globals);
        globalsSection.setLayout((Layout)new GridLayout());
        globalsSection.setLayoutData((Object)new GridData(4, 4, true, false));
        globalsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                RulesImplementationComposite.this.getContainer().layout();
            }
        });
        this._globalsTable = new RulesMappingsTable((Composite)globalsSection, 0, "message.content", null, RulesPackage.eINSTANCE.getRulesOperationType_Globals(), RulesPackage.eINSTANCE.getGlobalsType_Global(), Arrays.asList("from", "to"));
        this._globalsTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._globalsTable);
        globalsSection.setClient((Control)this._globalsTable);
        Section inputsSection = factory.createSection(mappingsComposite, 322);
        inputsSection.setBackgroundMode(0);
        inputsSection.setText(Messages.label_inputs);
        inputsSection.setLayout((Layout)new GridLayout());
        inputsSection.setLayoutData((Object)new GridData(4, 4, true, false));
        inputsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                RulesImplementationComposite.this.getContainer().layout();
            }
        });
        this._inputsTable = new RulesMappingsTable((Composite)inputsSection, 0, "message.content", null, RulesPackage.eINSTANCE.getRulesOperationType_Inputs(), RulesPackage.eINSTANCE.getInputsType_Input(), Arrays.asList("from", "to"));
        this._inputsTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._inputsTable);
        inputsSection.setClient((Control)this._inputsTable);
        Section outputsSection = factory.createSection(mappingsComposite, 322);
        outputsSection.setBackgroundMode(0);
        outputsSection.setText(Messages.label_outputs);
        outputsSection.setLayout((Layout)new GridLayout());
        outputsSection.setLayoutData((Object)new GridData(4, 4, true, false));
        outputsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                RulesImplementationComposite.this.getContainer().layout();
            }
        });
        this._outputsTable = new RulesMappingsTable((Composite)outputsSection, 0, null, "message.content", RulesPackage.eINSTANCE.getRulesOperationType_Outputs(), RulesPackage.eINSTANCE.getOutputsType_Output(), Arrays.asList("from", "to"));
        this._outputsTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._outputsTable);
        outputsSection.setClient((Control)this._outputsTable);
        Section faultsSection = factory.createSection(mappingsComposite, 322);
        faultsSection.setBackgroundMode(0);
        faultsSection.setText(Messages.label_faults);
        faultsSection.setLayout((Layout)new GridLayout());
        faultsSection.setLayoutData((Object)new GridData(4, 4, true, false));
        faultsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                RulesImplementationComposite.this.getContainer().layout();
            }
        });
        this._faultsTable = new RulesMappingsTable((Composite)faultsSection, 0, null, "message.content", RulesPackage.eINSTANCE.getRulesOperationType_Faults(), RulesPackage.eINSTANCE.getFaultsType_Fault(), Arrays.asList("from", "to"));
        this._faultsTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._faultsTable);
        faultsSection.setClient((Control)this._faultsTable);
        this._inputsTable.setEnabled(false);
        this._outputsTable.setEnabled(false);
        this._globalsTable.setEnabled(false);
        this._faultsTable.setEnabled(false);
        item.setControl((Control)control);
    }

    private void createAdvancedControls(TabFolder folder, TabItem item) {
        FormToolkit factory = this.getWidgetFactory();
        Composite control = factory.createComposite((Composite)folder);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        Section channelsSection = factory.createSection(control, 322);
        channelsSection.setBackgroundMode(0);
        channelsSection.setText(Messages.label_channels);
        channelsSection.setLayout((Layout)new GridLayout());
        channelsSection.setLayoutData((Object)new GridData(4, 4, true, false));
        channelsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                RulesImplementationComposite.this.getContainer().layout();
            }
        });
        Composite channelsComposite = factory.createComposite((Composite)channelsSection);
        channelsComposite.setLayout((Layout)new GridLayout(2, false));
        channelsComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        channelsSection.setClient((Control)channelsComposite);
        this._channelsTable = new RulesChannelTable((Composite)channelsSection, 0);
        this._channelsTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._channelsTable);
        channelsSection.setClient((Control)this._channelsTable);
        Section listenersSection = factory.createSection(control, 258);
        listenersSection.setBackgroundMode(0);
        listenersSection.setText(Messages.label_listeners);
        listenersSection.setLayout((Layout)new GridLayout());
        listenersSection.setLayoutData((Object)new GridData(4, 4, true, false));
        listenersSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                RulesImplementationComposite.this.getContainer().layout();
            }
        });
        this._listenersTable = new RulesEventListenerTable((Composite)listenersSection, 0);
        this._listenersTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._listenersTable);
        listenersSection.setClient((Control)this._listenersTable);
        Section loggersSection = factory.createSection(control, 258);
        loggersSection.setBackgroundMode(0);
        loggersSection.setText(Messages.label_loggers);
        loggersSection.setLayout((Layout)new GridLayout());
        loggersSection.setLayoutData((Object)new GridData(4, 4, true, false));
        loggersSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                RulesImplementationComposite.this.getContainer().layout();
            }
        });
        this._loggersTable = new RulesLoggerTable((Composite)loggersSection, 0);
        this._loggersTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._loggersTable);
        loggersSection.setClient((Control)this._loggersTable);
        Section propertiesSection = factory.createSection(control, 258);
        propertiesSection.setBackgroundMode(0);
        propertiesSection.setText(Messages.label_properties);
        propertiesSection.setLayout((Layout)new GridLayout());
        propertiesSection.setLayoutData((Object)new GridData(4, 4, true, false));
        propertiesSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                RulesImplementationComposite.this.getContainer().layout();
            }
        });
        this._propertiesTable = new RulesPropertyTable((Composite)propertiesSection, 0);
        this._propertiesTable.setLayoutData(new GridData(4, 4, true, false));
        factory.adapt((Composite)this._propertiesTable);
        propertiesSection.setClient((Control)this._propertiesTable);
        item.setControl((Control)control);
    }

    @Override
    public IStatus validate() {
        if (this._implementation != null && this._implementation.getManifest() != null) {
            IStatus restStatus;
            IStatus jmsStatus;
            ManifestType manifest = this._implementation.getManifest();
            if (manifest.getRemoteJms() != null && (jmsStatus = this._remoteJMSContainerDetailsControls.validate()) != Status.OK_STATUS) {
                return jmsStatus;
            }
            if (manifest.getRemoteRest() != null && (restStatus = this._remoteRestContainerDetailsControls.validate()) != Status.OK_STATUS) {
                return restStatus;
            }
        }
        return Status.OK_STATUS;
    }
}

