/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.jca;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.emf.databinding.edit.IEMFEditObservable;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.switchyard.tools.models.switchyard1_0.jca.JcaFactory;
import org.switchyard.tools.models.switchyard1_0.jca.JcaPackage;
import org.switchyard.tools.models.switchyard1_0.jca.Property;

public class JCANamedPropertyObservableValue
extends AbstractObservableValue {
    private final IObservableList _list;
    private final String _name;
    private Property _property;
    private final Object _type;
    private final IChangeListener _listener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            JCANamedPropertyObservableValue.this.handleListChange();
        }
    };

    public JCANamedPropertyObservableValue(Realm realm, IObservableList list, String name, Object type) {
        super(realm);
        this._list = list;
        this._name = name;
        this._property = this.findProperty();
        this._type = type;
        this._list.addChangeListener(this._listener);
    }

    public JCANamedPropertyObservableValue(Realm realm, IObservableList list, String name) {
        super(realm);
        this._list = list;
        this._name = name;
        this._property = this.findProperty();
        this._type = String.class;
        this._list.addChangeListener(this._listener);
    }

    public Object getValueType() {
        return this._type;
    }

    public synchronized void dispose() {
        if (!this._list.isDisposed()) {
            this._list.removeChangeListener(this._listener);
        }
        super.dispose();
    }

    protected Object doGetValue() {
        if (this._property == null) {
            return null;
        }
        return this._property.getValue();
    }

    protected void doSetValue(Object value) {
        Object original;
        if (this._property == null) {
            original = null;
            if (value == null) {
                return;
            }
            this._property = JcaFactory.eINSTANCE.createProperty();
            this._property.setName(this._name);
            this._property.setValue(value);
            this._list.add((Object)this._property);
        } else {
            original = this._property.getValue();
            if (value == null && original == null || value != null && value.equals(original)) {
                return;
            }
            if (this._list instanceof IEMFEditObservable) {
                EditingDomain domain = ((IEMFEditObservable)this._list).getEditingDomain();
                domain.getCommandStack().execute(SetCommand.create((EditingDomain)domain, (Object)this._property, (Object)JcaPackage.Literals.PROPERTY__VALUE, (Object)value));
            } else {
                this._property.setValue(value);
            }
        }
        this.fireValueChange(Diffs.createValueDiff((Object)original, (Object)value));
    }

    private void handleListChange() {
        if (this._property != null && this._list.contains((Object)this._property)) {
            return;
        }
        Object oldValue = this._property == null ? null : this._property.getValue();
        this._property = this.findProperty();
        if (this._property == null ? oldValue == null : (oldValue == null ? this._property.getValue() == null : oldValue.equals(this._property.getValue()))) {
            return;
        }
        this.fireValueChange(Diffs.createValueDiff((Object)oldValue, this._property == null ? null : this._property.getValue()));
    }

    private Property findProperty() {
        for (Object entry : this._list) {
            Property property = (Property)entry;
            if (property == null || !this._name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }
}

