/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.jca;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.jca.Endpoint;
import org.switchyard.tools.models.switchyard1_0.jca.JCABinding;
import org.switchyard.tools.models.switchyard1_0.jca.JCAInboundInteraction;
import org.switchyard.tools.models.switchyard1_0.jca.JcaFactory;
import org.switchyard.tools.models.switchyard1_0.jca.JcaPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.components.jca.AbstractJCABindingComposite;
import org.switchyard.tools.ui.editor.components.jca.IJCAEndpointPropertiesExtension;
import org.switchyard.tools.ui.editor.components.jca.JCACCIEndpointPropertiesExtension;
import org.switchyard.tools.ui.editor.components.jca.JCACustomEndpointPropertiesExtension;
import org.switchyard.tools.ui.editor.components.jca.JCAJMSEndpointPropertiesExtension;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;

public class JCAInteractionDetailsComposite
extends AbstractSYBindingComposite {
    private Map<EndpointType, AbstractJCABindingComposite> _extensionComposites = new HashMap<EndpointType, AbstractJCABindingComposite>();
    private EndpointType _activeExtension;
    private Composite _panel;
    private JCABinding _binding = null;
    private ComboViewer _endpointMappingTypeCombo;
    private Button _transactedButton;
    private Group _batchGroup;
    private Text _batchSizeText;
    private Text _batchTimeoutText;
    private AbstractJCABindingComposite _endpointPropsComposite;
    private Composite _stackComposite;
    private StackLayout _stackLayout;
    private WritableValue _bindingValue;

    JCAInteractionDetailsComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_interactionDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_interactionDetails;
    }

    private void processEndpointComboSelection() {
        IStructuredSelection selection = (IStructuredSelection)this._endpointMappingTypeCombo.getSelection();
        this.swapExtensionComposites(selection.isEmpty() ? null : (EndpointType)((Object)selection.getFirstElement()), true);
    }

    private void swapExtensionComposites(final EndpointType newExtension, final boolean updateValues) {
        if (newExtension == null || newExtension == this._activeExtension) {
            return;
        }
        TransactionalEditingDomain domain = this.getDomain((EObject)this._binding);
        if (updateValues && domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, "Change JCA endpoint type"){

                protected void doExecute() {
                    JCAInteractionDetailsComposite.this.deactivateExtension(JCAInteractionDetailsComposite.this._activeExtension);
                    JCAInteractionDetailsComposite.this.activateExtension(newExtension, updateValues);
                }
            });
        } else {
            this.deactivateExtension(this._activeExtension);
            this.activateExtension(newExtension, updateValues);
        }
        this._activeExtension = newExtension;
        this._endpointPropsComposite = this._extensionComposites.get((Object)newExtension);
        this._stackLayout.topControl = this._endpointPropsComposite.getPanel();
        this._stackComposite.layout();
        if (this._stackComposite.getParent() != null) {
            this._stackComposite.getParent().layout();
        }
    }

    private void activateExtension(EndpointType extension, boolean updateValues) {
        if (extension == null) {
            return;
        }
        if (updateValues) {
            Endpoint endpoint;
            JCAInboundInteraction interaction = this._binding.getInboundInteraction();
            if (interaction == null) {
                interaction = JcaFactory.eINSTANCE.createJCAInboundInteraction();
                this._binding.setInboundInteraction(interaction);
            }
            if ((endpoint = interaction.getEndpoint()) == null) {
                endpoint = JcaFactory.eINSTANCE.createEndpoint();
                interaction.setEndpoint(endpoint);
            }
            endpoint.setType(extension.getEndpointType());
            interaction.setListener(extension.getListenerType());
        }
        this._extensionComposites.get((Object)extension).setBinding((Binding)this._binding);
    }

    private void deactivateExtension(EndpointType extension) {
        if (extension == null) {
            return;
        }
        AbstractJCABindingComposite extensionComposite = this._extensionComposites.get((Object)extension);
        extensionComposite.setBinding(null);
    }

    @Override
    public void setBinding(Binding impl) {
        super.setBinding(impl);
        this._binding = impl instanceof JCABinding ? (JCABinding)impl : null;
        this._bindingValue.setValue((Object)this._binding);
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getJCAInteractionDetailsTabControl(this._panel, context);
        this.bindControls(context);
    }

    private Control getJCAInteractionDetailsTabControl(Composite tabFolder, DataBindingContext context) {
        Composite composite = this.getToolkit().createComposite(tabFolder, 0);
        GridLayout gl = new GridLayout(1, false);
        composite.setLayout((Layout)gl);
        this._endpointMappingTypeCombo = new ComboViewer(this.createLabelAndCombo(composite, Messages.label_endpointMappingType, true));
        this._endpointMappingTypeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._endpointMappingTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((EndpointType)((Object)element)).getLabel();
            }
        });
        this._endpointMappingTypeCombo.setInput((Object)EndpointType.values());
        this._endpointMappingTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JCAInteractionDetailsComposite.this.processEndpointComboSelection();
            }
        });
        this._transactedButton = this.createCheckbox(composite, Messages.label_transacted);
        this._batchGroup = new Group(composite, 0);
        GridData bgGridData = new GridData(4, 1, true, false);
        this._batchGroup.setLayoutData((Object)bgGridData);
        this._batchGroup.setLayout((Layout)new GridLayout(2, false));
        this._batchGroup.setText(Messages.label_batchCommitOptions);
        this.getToolkit().adapt((Composite)this._batchGroup);
        this._batchSizeText = this.createLabelAndText((Composite)this._batchGroup, Messages.label_batchSize);
        this._batchTimeoutText = this.createLabelAndText((Composite)this._batchGroup, Messages.label_batchTimeout);
        this._stackComposite = this.getToolkit().createComposite(composite, 0);
        GridData gd = new GridData(4, 1, true, false, 2, 1);
        this._stackComposite.setLayoutData((Object)gd);
        this._stackLayout = new StackLayout();
        this._stackComposite.setLayout((Layout)this._stackLayout);
        Composite dummy = this.getToolkit().createComposite(this._stackComposite, 0);
        this._stackLayout.topControl = dummy;
        EndpointType[] endpointTypeArray = EndpointType.values();
        int n = endpointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EndpointType endpointType = endpointTypeArray[n2];
            AbstractJCABindingComposite endpointComposite = endpointType.createComposite(this.getToolkit());
            endpointComposite.setTargetObject(this.getTargetObject());
            endpointComposite.createContents(this._stackComposite, 0, context);
            endpointComposite.setBinding(null);
            this._extensionComposites.put(endpointType, endpointComposite);
            ++n2;
        }
        return composite;
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._stackComposite.getDisplay());
        this._bindingValue = new WritableValue(realm, null, JCABinding.class);
        FeaturePath batchSizeFeaturePath = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{JcaPackage.Literals.JCA_BINDING__INBOUND_INTERACTION, JcaPackage.Literals.JCA_INBOUND_INTERACTION__BATCH_COMMIT, JcaPackage.Literals.BATCH_COMMIT__BATCH_SIZE});
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._batchSizeText, (int)24), EMFProperties.value((FeaturePath)batchSizeFeaturePath).observeDetail((IObservableValue)this._bindingValue), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT, domain, (IObservableValue)this._bindingValue, batchSizeFeaturePath, true), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        FeaturePath batchTimeoutFeaturePath = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{JcaPackage.Literals.JCA_BINDING__INBOUND_INTERACTION, JcaPackage.Literals.JCA_INBOUND_INTERACTION__BATCH_COMMIT, JcaPackage.Literals.BATCH_COMMIT__BATCH_TIMEOUT});
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._batchTimeoutText, (int)24), EMFProperties.value((FeaturePath)batchTimeoutFeaturePath).observeDetail((IObservableValue)this._bindingValue), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT, domain, (IObservableValue)this._bindingValue, batchTimeoutFeaturePath, true), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        FeaturePath transactedFeaturePath = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{JcaPackage.Literals.JCA_BINDING__INBOUND_INTERACTION, JcaPackage.Literals.JCA_INBOUND_INTERACTION__TRANSACTED});
        binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._transactedButton), EMFProperties.value((FeaturePath)transactedFeaturePath).observeDetail((IObservableValue)this._bindingValue), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_UPDATE, domain, (IObservableValue)this._bindingValue, transactedFeaturePath, false), null);
        IObservableValue endpointType = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{JcaPackage.Literals.JCA_BINDING__INBOUND_INTERACTION, JcaPackage.Literals.JCA_INBOUND_INTERACTION__ENDPOINT, JcaPackage.Literals.ENDPOINT__TYPE}));
        endpointType.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                EndpointType newExtension = EndpointType.fromEndpointType((String)event.diff.getNewValue());
                if (newExtension != JCAInteractionDetailsComposite.this._activeExtension) {
                    JCAInteractionDetailsComposite.this.swapExtensionComposites(newExtension, false);
                    JCAInteractionDetailsComposite.this._endpointMappingTypeCombo.setSelection((ISelection)new StructuredSelection((Object)newExtension), true);
                }
            }
        });
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    private static enum EndpointType {
        JMS(Messages.label_jmsEndpoint, "org.switchyard.component.jca.endpoint.JMSEndpoint", "javax.jms.MessageListener", new JCAJMSEndpointPropertiesExtension()),
        CCI(Messages.label_cciEndpoint, "org.switchyard.component.jca.endpoint.CCIEndpoint", "javax.resource.cci.MessageListener", new JCACCIEndpointPropertiesExtension()),
        CUSTOM("Custom", null, null, new JCACustomEndpointPropertiesExtension());

        private final String _label;
        private final String _endpointType;
        private final String _listenerType;
        private final IJCAEndpointPropertiesExtension _extension;

        private EndpointType(String label, String endpointType, String listenerType, IJCAEndpointPropertiesExtension extension) {
            this._label = label;
            this._endpointType = endpointType;
            this._listenerType = listenerType;
            this._extension = extension;
        }

        public String getLabel() {
            return this._label;
        }

        public String getEndpointType() {
            return this._endpointType;
        }

        public String getListenerType() {
            return this._listenerType;
        }

        public AbstractJCABindingComposite createComposite(FormToolkit toolkit) {
            return this._extension.createComposite(toolkit);
        }

        public static EndpointType fromEndpointType(String endpointType) {
            if (EndpointType.JMS._endpointType.equals(endpointType)) {
                return JMS;
            }
            if (EndpointType.CCI._endpointType.equals(endpointType)) {
                return CCI;
            }
            return CUSTOM;
        }
    }
}

