/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.jca;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.jca.ActivationSpec;
import org.switchyard.tools.models.switchyard1_0.jca.JCABinding;
import org.switchyard.tools.models.switchyard1_0.jca.JCAInboundConnection;
import org.switchyard.tools.models.switchyard1_0.jca.JCAOutboundConnection;
import org.switchyard.tools.models.switchyard1_0.jca.JCAOutboundInteraction;
import org.switchyard.tools.models.switchyard1_0.jca.JcaPackage;
import org.switchyard.tools.models.switchyard1_0.jca.Processor;
import org.switchyard.tools.models.switchyard1_0.jca.Property;
import org.switchyard.tools.models.switchyard1_0.jca.ResourceAdapter;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.components.jca.AbstractJCABindingComposite;
import org.switchyard.tools.ui.editor.components.jca.AbstractResourceAdapterExtension;
import org.switchyard.tools.ui.editor.components.jca.IJCAResourceAdapterExtension;
import org.switchyard.tools.ui.editor.components.jca.JCANamedPropertyObservableValue;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;

public class JCAHornetQQueueResourceAdapterExtension
extends AbstractResourceAdapterExtension {
    private static final String DESTINATION_TYPE_PROP = "destinationType";
    private static final String DESTINATION_PROP = "destination";
    private static final String MESSAGE_SELECTOR_PROP = "messageSelector";
    private static final String ACKNOWLEDGE_MODE_PROP = "acknowledgeMode";
    private static final String DESTINATION_TYPE_DEFAULT = "javax.jms.Queue";
    private static final String DESTINATION_DEFAULT = "queue/YourQueueName";
    private static final String ACKNOWLEDGE_MODE_DEFAULT = "Auto-acknowledge";
    private static final String RESOURCE_ADAPTER_NAME = "hornetq-ra.rar";
    private static final IJCAResourceAdapterExtension.IInboundConnectionSettings INBOUND_CONNECTION_SETTINGS = new IJCAResourceAdapterExtension.IInboundConnectionSettings(){
        private final Map<String, String> _activationProperties = new LinkedHashMap<String, String>(){
            {
                this.put(JCAHornetQQueueResourceAdapterExtension.DESTINATION_TYPE_PROP, JCAHornetQQueueResourceAdapterExtension.DESTINATION_TYPE_DEFAULT);
                this.put(JCAHornetQQueueResourceAdapterExtension.DESTINATION_PROP, JCAHornetQQueueResourceAdapterExtension.DESTINATION_DEFAULT);
                this.put(JCAHornetQQueueResourceAdapterExtension.MESSAGE_SELECTOR_PROP, null);
                this.put(JCAHornetQQueueResourceAdapterExtension.ACKNOWLEDGE_MODE_PROP, JCAHornetQQueueResourceAdapterExtension.ACKNOWLEDGE_MODE_DEFAULT);
            }
        };

        @Override
        public Map<String, String> getResourceAdapterProperties() {
            return null;
        }

        @Override
        public String getResourceAdapterName() {
            return JCAHornetQQueueResourceAdapterExtension.RESOURCE_ADAPTER_NAME;
        }

        @Override
        public Map<String, String> getActivationSpecProperties() {
            return this._activationProperties;
        }
    };
    private static final String LISTENER_TYPE_DEFAULT = "javax.jms.MessageListener";
    private static final String ENDPOINT_TYPE_DEFAULT = "org.switchyard.component.jca.endpoint.JMSEndpoint";
    private static final IJCAResourceAdapterExtension.IInboundInteractionSettings INBOUND_INTERACTION_SETTINGS = new IJCAResourceAdapterExtension.IInboundInteractionSettings(){

        @Override
        public Boolean isTransacted() {
            return true;
        }

        @Override
        public String getListenerType() {
            return JCAHornetQQueueResourceAdapterExtension.LISTENER_TYPE_DEFAULT;
        }

        @Override
        public String getEndpointType() {
            return JCAHornetQQueueResourceAdapterExtension.ENDPOINT_TYPE_DEFAULT;
        }

        @Override
        public Map<String, String> getEndpointProperties() {
            return null;
        }
    };
    private static final IJCAResourceAdapterExtension.IOutboundConnectionSettings OUTBOUND_CONNECTION_SETTINGS = new IJCAResourceAdapterExtension.IOutboundConnectionSettings(){

        @Override
        public Map<String, String> getResourceAdapterProperties() {
            return null;
        }

        @Override
        public String getResourceAdapterName() {
            return JCAHornetQQueueResourceAdapterExtension.RESOURCE_ADAPTER_NAME;
        }

        @Override
        public Map<String, String> getConnectionProperties() {
            return null;
        }

        @Override
        public String getConnectionJndiName() {
            return null;
        }
    };
    private static final String PROCESSOR_TYPE_DEFAULT = "org.switchyard.component.jca.processor.JMSProcessor";
    private static final IJCAResourceAdapterExtension.IOutboundInteractionSettings OUTBOUND_INTERACTION_SETTINGS = new IJCAResourceAdapterExtension.IOutboundInteractionSettings(){
        private final Map<String, String> _processorProperties = new LinkedHashMap<String, String>(){
            {
                this.put(JCAHornetQQueueResourceAdapterExtension.DESTINATION_PROP, JCAHornetQQueueResourceAdapterExtension.DESTINATION_DEFAULT);
            }
        };

        @Override
        public String getProcessorType() {
            return JCAHornetQQueueResourceAdapterExtension.PROCESSOR_TYPE_DEFAULT;
        }

        @Override
        public Map<String, String> getProcessorProperties() {
            return this._processorProperties;
        }

        @Override
        public Map<String, String> getInteractionSpecProperties() {
            return null;
        }

        @Override
        public Map<String, String> getConnectionSpecProperties() {
            return null;
        }
    };

    @Override
    public IJCAResourceAdapterExtension.IInboundInteractionSettings getInboundInteractionSettings() {
        return INBOUND_INTERACTION_SETTINGS;
    }

    @Override
    public IJCAResourceAdapterExtension.IInboundConnectionSettings getInboundConnectionSettings() {
        return INBOUND_CONNECTION_SETTINGS;
    }

    @Override
    public IJCAResourceAdapterExtension.IOutboundInteractionSettings getOutboundInteractionSettings() {
        return OUTBOUND_INTERACTION_SETTINGS;
    }

    @Override
    public IJCAResourceAdapterExtension.IOutboundConnectionSettings getOutboundConnectionSettings() {
        return OUTBOUND_CONNECTION_SETTINGS;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return Messages.label_hornetQResourceAdapter;
    }

    @Override
    public AbstractJCABindingComposite createComposite(FormToolkit toolkit) {
        return new JCAHornetQQueueResourceAdapterComposite(toolkit);
    }

    @Override
    public int score(JCABinding binding) {
        if (binding == null) {
            return 0;
        }
        if (binding.getInboundConnection() != null) {
            return this.scoreInboundProperties(binding);
        }
        if (binding.getOutboundConnection() != null) {
            return this.scoreOutboundProperties(binding);
        }
        return 0;
    }

    private int scoreInboundProperties(JCABinding binding) {
        ActivationSpec activationSpec;
        int score = -1;
        JCAInboundConnection connection = binding.getInboundConnection();
        if (connection == null) {
            return score;
        }
        IJCAResourceAdapterExtension.IInboundConnectionSettings settings = this.getInboundConnectionSettings();
        if (settings == null) {
            return score;
        }
        ResourceAdapter ra = connection.getResourceAdapter();
        if (ra != null && settings.getResourceAdapterName() != null && settings.getResourceAdapterName().equals(ra.getName())) {
            ++score;
        }
        if ((activationSpec = connection.getActivationSpec()) != null && settings.getActivationSpecProperties() != null) {
            score += this.scoreProperty((List<Property>)activationSpec.getProperty(), DESTINATION_TYPE_PROP, DESTINATION_TYPE_DEFAULT);
        }
        return score;
    }

    private int scoreOutboundProperties(JCABinding binding) {
        Processor processor;
        JCAOutboundInteraction interaction;
        int score = -1;
        JCAOutboundConnection connection = binding.getOutboundConnection();
        if (connection == null) {
            return score;
        }
        IJCAResourceAdapterExtension.IOutboundConnectionSettings settings = this.getOutboundConnectionSettings();
        if (settings == null) {
            return score;
        }
        ResourceAdapter ra = connection.getResourceAdapter();
        if (ra != null && settings.getResourceAdapterName() != null && settings.getResourceAdapterName().equals(ra.getName())) {
            ++score;
        }
        if ((interaction = binding.getOutboundInteraction()) != null && OUTBOUND_INTERACTION_SETTINGS.getProcessorType() != null && (processor = interaction.getProcessor()) != null && OUTBOUND_INTERACTION_SETTINGS.getProcessorType().equals(processor.getType())) {
            ++score;
        }
        return score;
    }

    private final class JCAHornetQQueueResourceAdapterComposite
    extends AbstractJCABindingComposite {
        private Text _messageSelectorText;
        private JCABinding _binding;
        private Composite _panel;
        private Text _destinationText;
        private ComboViewer _acknowledgeModeCombo;
        private Set<org.eclipse.core.databinding.Binding> _validators;
        private WritableValue _bindingValue;

        private JCAHornetQQueueResourceAdapterComposite(FormToolkit toolkit) {
            super(toolkit);
            this._validators = new HashSet<org.eclipse.core.databinding.Binding>();
        }

        @Override
        public String getTitle() {
            return JCAHornetQQueueResourceAdapterExtension.this.getDisplayName();
        }

        @Override
        public String getDescription() {
            return this.getTitle();
        }

        @Override
        public void createContents(Composite parent, int style, DataBindingContext context) {
            this._panel = new Composite(parent, style);
            this._panel.setLayout((Layout)new GridLayout(2, false));
            this._destinationText = this.createLabelAndText(this._panel, Messages.label_destinationQueue);
            this._messageSelectorText = this.createLabelAndText(this._panel, Messages.label_messageSelector);
            this._acknowledgeModeCombo = this.createLabelAndComboViewer(this._panel, Messages.label_acknowledgeMode, true);
            this._acknowledgeModeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this._acknowledgeModeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            String[] methods = new String[]{JCAHornetQQueueResourceAdapterExtension.ACKNOWLEDGE_MODE_DEFAULT, "Dups-ok-acknowledge"};
            this._acknowledgeModeCombo.setInput((Object)methods);
            this._acknowledgeModeCombo.getCombo().setText(JCAHornetQQueueResourceAdapterExtension.ACKNOWLEDGE_MODE_DEFAULT);
            this.bindControls(context);
        }

        @Override
        public Composite getPanel() {
            return this._panel;
        }

        @Override
        public void setBinding(Binding impl) {
            block4: {
                super.setBinding(impl);
                this._binding = (JCABinding)impl;
                if (this._bindingValue == null) break block4;
                this._bindingValue.setValue((Object)this._binding);
                if (this._binding == null) {
                    for (org.eclipse.core.databinding.Binding binding : this._validators) {
                        binding.getValidationStatus().setValue((Object)Status.OK_STATUS);
                    }
                } else {
                    for (org.eclipse.core.databinding.Binding binding : this._validators) {
                        binding.validateTargetToModel();
                    }
                }
            }
        }

        protected void bindControls(DataBindingContext context) {
            EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
            Realm realm = SWTObservables.getRealm((Display)this._destinationText.getDisplay());
            this._bindingValue = new WritableValue(realm, null, JCABinding.class);
            FeaturePath propertiesFeaturePath = this.getTargetObject() instanceof Service ? FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{JcaPackage.Literals.JCA_BINDING__INBOUND_CONNECTION, JcaPackage.Literals.JCA_INBOUND_CONNECTION__ACTIVATION_SPEC, JcaPackage.Literals.ACTIVATION_SPEC__PROPERTY}) : FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{JcaPackage.Literals.JCA_BINDING__OUTBOUND_INTERACTION, JcaPackage.Literals.JCA_OUTBOUND_INTERACTION__PROCESSOR, JcaPackage.Literals.PROCESSOR__PROPERTY});
            IObservableList propertiesList = (domain == null ? EMFProperties.list((FeaturePath)propertiesFeaturePath) : EMFEditProperties.list((EditingDomain)domain, (FeaturePath)propertiesFeaturePath)).observeDetail((IObservableValue)this._bindingValue);
            org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._destinationText, (int)24), (IObservableValue)new JCANamedPropertyObservableValue(realm, propertiesList, JCAHornetQQueueResourceAdapterExtension.DESTINATION_PROP), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("Destination cannot be empty")), null);
            this._validators.add(binding);
            ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512, (Composite)this._panel);
            binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._messageSelectorText, (int)24), (IObservableValue)new JCANamedPropertyObservableValue(realm, propertiesList, JCAHornetQQueueResourceAdapterExtension.MESSAGE_SELECTOR_PROP), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
            ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512, (Composite)this._panel);
            binding = context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this._acknowledgeModeCombo), (IObservableValue)new JCANamedPropertyObservableValue(realm, propertiesList, JCAHornetQQueueResourceAdapterExtension.ACKNOWLEDGE_MODE_PROP), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_UPDATE), null);
            ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512, (Composite)this._panel);
            if (this._binding != null) {
                this._bindingValue.setValue((Object)this._binding);
            }
        }
    }
}

