/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.jca;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.switchyard.tools.models.switchyard1_0.jca.ActivationSpec;
import org.switchyard.tools.models.switchyard1_0.jca.Connection;
import org.switchyard.tools.models.switchyard1_0.jca.Endpoint;
import org.switchyard.tools.models.switchyard1_0.jca.JCABinding;
import org.switchyard.tools.models.switchyard1_0.jca.JCAInboundConnection;
import org.switchyard.tools.models.switchyard1_0.jca.JCAInboundInteraction;
import org.switchyard.tools.models.switchyard1_0.jca.JCAOutboundConnection;
import org.switchyard.tools.models.switchyard1_0.jca.JCAOutboundInteraction;
import org.switchyard.tools.models.switchyard1_0.jca.JcaFactory;
import org.switchyard.tools.models.switchyard1_0.jca.Processor;
import org.switchyard.tools.models.switchyard1_0.jca.Property;
import org.switchyard.tools.models.switchyard1_0.jca.ResourceAdapter;
import org.switchyard.tools.ui.editor.components.jca.IJCAResourceAdapterExtension;
import org.switchyard.tools.ui.editor.components.jca.IJCAResourceAdapterExtensionManager;
import org.switchyard.tools.ui.editor.components.jca.JCABindingTypeExtension;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractBindingWizard;
import org.switchyard.tools.ui.editor.diagram.binding.IBindingWizard;
import org.switchyard.tools.ui.editor.diagram.shared.IBindingComposite;

public class JCABindingWizard
extends AbstractBindingWizard
implements IBindingWizard {
    @Override
    protected Binding createBinding() {
        JCABinding binding = JcaFactory.eINSTANCE.createJCABinding();
        for (IJCAResourceAdapterExtension extension : IJCAResourceAdapterExtensionManager.instance().getExtensions()) {
            if (!extension.isDefault()) continue;
            if (this.getTargetContainer() instanceof Service) {
                binding.setInboundConnection(JcaFactory.eINSTANCE.createJCAInboundConnection());
                binding.getInboundConnection().setActivationSpec(JcaFactory.eINSTANCE.createActivationSpec());
                binding.getInboundConnection().setResourceAdapter(JcaFactory.eINSTANCE.createResourceAdapter());
                binding.setInboundInteraction(JcaFactory.eINSTANCE.createJCAInboundInteraction());
                binding.getInboundInteraction().setEndpoint(JcaFactory.eINSTANCE.createEndpoint());
                this.applyInboundConnectionSettings(extension.getInboundConnectionSettings(), binding);
                this.applyInboundInteractionSettings(extension.getInboundInteractionSettings(), binding);
                break;
            }
            binding.setOutboundConnection(JcaFactory.eINSTANCE.createJCAOutboundConnection());
            binding.getOutboundConnection().setConnection(JcaFactory.eINSTANCE.createConnection());
            binding.getOutboundConnection().setResourceAdapter(JcaFactory.eINSTANCE.createResourceAdapter());
            binding.setOutboundInteraction(JcaFactory.eINSTANCE.createJCAOutboundInteraction());
            binding.getOutboundInteraction().setProcessor(JcaFactory.eINSTANCE.createProcessor());
            binding.getOutboundInteraction().setConnectionSpec(JcaFactory.eINSTANCE.createConnectionSpec());
            binding.getOutboundInteraction().setInteractionSpec(JcaFactory.eINSTANCE.createInteractionSpec());
            this.applyOutboundConnectionSettings(extension.getOutboundConnectionSettings(), binding);
            this.applyOutboundInteractionSettings(extension.getOutboundInteractionSettings(), binding);
        }
        binding.setName(this.makeUniqueName("jca"));
        return binding;
    }

    @Override
    protected List<IBindingComposite> createComposites() {
        return JCABindingTypeExtension.createComposites(this.getToolkit(), this.getTargetContainer() instanceof Service);
    }

    private void applyInboundConnectionSettings(IJCAResourceAdapterExtension.IInboundConnectionSettings settings, JCABinding binding) {
        if (settings == null) {
            return;
        }
        JCAInboundConnection connection = binding.getInboundConnection();
        ResourceAdapter resourceAdapter = connection.getResourceAdapter();
        resourceAdapter.setName(settings.getResourceAdapterName());
        this.addDefaultProperties((List<Property>)resourceAdapter.getProperty(), settings.getResourceAdapterProperties());
        ActivationSpec activationSpec = connection.getActivationSpec();
        this.addDefaultProperties((List<Property>)activationSpec.getProperty(), settings.getActivationSpecProperties());
    }

    private void applyInboundInteractionSettings(IJCAResourceAdapterExtension.IInboundInteractionSettings settings, JCABinding binding) {
        if (settings == null) {
            return;
        }
        JCAInboundInteraction interaction = binding.getInboundInteraction();
        interaction.setListener(settings.getListenerType());
        if (settings.isTransacted() != null) {
            interaction.setTransacted(settings.isTransacted().booleanValue());
        }
        Endpoint endpoint = interaction.getEndpoint();
        endpoint.setType(settings.getEndpointType());
        this.addDefaultProperties((List<Property>)endpoint.getProperty(), settings.getEndpointProperties());
    }

    private void applyOutboundConnectionSettings(IJCAResourceAdapterExtension.IOutboundConnectionSettings settings, JCABinding binding) {
        if (settings == null) {
            return;
        }
        JCAOutboundConnection connection = binding.getOutboundConnection();
        ResourceAdapter resourceAdapter = connection.getResourceAdapter();
        resourceAdapter.setName(settings.getResourceAdapterName());
        this.addDefaultProperties((List<Property>)resourceAdapter.getProperty(), settings.getResourceAdapterProperties());
        Connection connectionConnection = connection.getConnection();
        connectionConnection.setJndiName(settings.getConnectionJndiName());
        this.addDefaultProperties((List<Property>)connectionConnection.getProperty(), settings.getConnectionProperties());
    }

    private void applyOutboundInteractionSettings(IJCAResourceAdapterExtension.IOutboundInteractionSettings settings, JCABinding binding) {
        if (settings == null) {
            return;
        }
        JCAOutboundInteraction interaction = binding.getOutboundInteraction();
        Processor processor = interaction.getProcessor();
        processor.setType(settings.getProcessorType());
        this.addDefaultProperties((List<Property>)processor.getProperty(), settings.getProcessorProperties());
        this.addDefaultProperties((List<Property>)interaction.getConnectionSpec().getProperty(), settings.getConnectionSpecProperties());
        this.addDefaultProperties((List<Property>)interaction.getInteractionSpec().getProperty(), settings.getInteractionSpecProperties());
    }

    private void addDefaultProperties(List<Property> properties, Map<String, String> defaults) {
        if (defaults == null) {
            return;
        }
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        for (Property property : properties) {
            if (property.getName() == null) continue;
            propertiesMap.put(property.getName(), property);
        }
        for (Map.Entry entry : defaults.entrySet()) {
            String name = (String)entry.getKey();
            if (name == null || propertiesMap.containsKey(name)) continue;
            Property property = JcaFactory.eINSTANCE.createProperty();
            property.setName(name);
            property.setValue(entry.getValue());
            properties.add(property);
        }
    }
}

