/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.util;

import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.UUID;
import org.teiid.designer.core.types.DatatypeConstants;

public class UuidUtil {
    public static final char DELIMITER_CHAR = '.';
    private static final String PREFIXED_OBJECT_ID_KEY = ".mmuuid:";
    private static final String PREFIXED_OBJECT_ID_KEY_UCASE = String.valueOf('.') + UUID.PROTOCOL_UCASE + ':';
    private static final String DELIMITED_PROTOCOL = "mmuuid:";
    private static final String DELIMITED_PROTOCOL_UCASE = String.valueOf(UUID.PROTOCOL_UCASE) + ':';
    private static final int DELIMITED_PROTOCOL_LENGTH = "mmuuid:".length();

    public static boolean isStringifiedUUID(String str) {
        boolean result = false;
        try {
            String string = UuidUtil.stripPrefixFromUUID(str);
            int index = string.indexOf(DELIMITED_PROTOCOL);
            if (index == -1) {
                index = string.indexOf(DELIMITED_PROTOCOL_UCASE);
            }
            if (index != -1) {
                string = string.substring(index += DELIMITED_PROTOCOL_LENGTH);
                DatatypeConstants.stringToObject((String)string);
                result = true;
            } else {
                result = false;
            }
        }
        catch (InvalidIDException invalidIDException) {
            result = false;
        }
        return result;
    }

    public static String stripPrefixFromUUID(String str) {
        if (str == null) {
            return null;
        }
        int index = str.indexOf(PREFIXED_OBJECT_ID_KEY);
        if (index == -1) {
            index = str.indexOf(PREFIXED_OBJECT_ID_KEY_UCASE);
        }
        if (index != -1) {
            return str.substring(index + 1);
        }
        return str;
    }
}

