/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.util;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.Mapping;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.refactor.ReferenceUpdator;
import org.teiid.designer.metamodels.transformation.SqlTransformation;
import org.teiid.designer.query.sql.ILanguageVisitor;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.UpdateLanguageObjectNameVisitor;
import org.teiid.designer.transformation.validation.SqlTransformationResult;
import org.teiid.designer.transformation.validation.TransformationValidator;

public class TransformationReferenceUpdator
implements ReferenceUpdator {
    public void updateEObject(EObject eObject, Map oldToNewObjects) {
        if (eObject instanceof SqlTransformation) {
            UpdateLanguageObjectNameVisitor visitor = new UpdateLanguageObjectNameVisitor(oldToNewObjects);
            SqlTransformation sqlTransformation = (SqlTransformation)eObject;
            this.updateSqlTransformation(sqlTransformation, visitor);
        }
    }

    private void updateSqlTransformation(SqlTransformation sqlTransformation, UpdateLanguageObjectNameVisitor visitor) {
        SqlTransformationResult deleteResult;
        String deleteSql;
        SqlTransformationResult updateResult;
        String updateSql;
        SqlTransformationResult insertResult;
        String insertSql;
        SqlTransformationResult selectResult;
        ModelerCore.getTeiidQueryService();
        Mapping mappingRoot = sqlTransformation.getMapper();
        String selectSql = sqlTransformation.getSelectSql();
        if (selectSql != null && (selectResult = TransformationValidator.parseSQL(selectSql)).isParsable()) {
            ICommand selectCmd = selectResult.getCommand();
            selectCmd.acceptVisitor((ILanguageVisitor)visitor);
            String newSelect = selectCmd.toString();
            if (!selectSql.equalsIgnoreCase(newSelect)) {
                SqlMappingRootCache.invalidateSelectStatus(mappingRoot, true, null);
                sqlTransformation.setSelectSql(newSelect);
            }
        }
        if ((insertSql = sqlTransformation.getInsertSql()) != null && (insertResult = TransformationValidator.parseSQL(insertSql)).isParsable()) {
            ICommand insertCmd = insertResult.getCommand();
            insertCmd.acceptVisitor((ILanguageVisitor)visitor);
            String newInsert = insertCmd.toString();
            if (!insertSql.equalsIgnoreCase(newInsert)) {
                SqlMappingRootCache.invalidateInsertStatus(mappingRoot, true, null);
                sqlTransformation.setInsertSql(newInsert);
            }
        }
        if ((updateSql = sqlTransformation.getUpdateSql()) != null && (updateResult = TransformationValidator.parseSQL(updateSql)).isParsable()) {
            ICommand updateCmd = updateResult.getCommand();
            updateCmd.acceptVisitor((ILanguageVisitor)visitor);
            String newUpdate = updateCmd.toString();
            if (!updateSql.equalsIgnoreCase(newUpdate)) {
                SqlMappingRootCache.invalidateUpdateStatus(mappingRoot, true, null);
                sqlTransformation.setUpdateSql(newUpdate);
            }
        }
        if ((deleteSql = sqlTransformation.getDeleteSql()) != null && (deleteResult = TransformationValidator.parseSQL(deleteSql)).isParsable()) {
            ICommand deleteCmd = deleteResult.getCommand();
            deleteCmd.acceptVisitor((ILanguageVisitor)visitor);
            String newDelete = deleteCmd.toString();
            if (!deleteSql.equalsIgnoreCase(newDelete)) {
                SqlMappingRootCache.invalidateDeleteStatus(mappingRoot, true, null);
                sqlTransformation.setDeleteSql(newDelete);
            }
        }
    }
}

