/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.EObjectFinder;
import org.teiid.designer.core.index.IEntryResult;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.ModelResourceIndexSelector;
import org.teiid.designer.core.index.ModelWorkspaceIndexSelector;
import org.teiid.designer.core.metadata.runtime.AnnotationRecordImpl;
import org.teiid.designer.core.metadata.runtime.ColumnRecordImpl;
import org.teiid.designer.core.metadata.runtime.ColumnSetRecordImpl;
import org.teiid.designer.core.metadata.runtime.DatatypeRecordImpl;
import org.teiid.designer.core.metadata.runtime.ForeignKeyRecordImpl;
import org.teiid.designer.core.metadata.runtime.ModelRecordImpl;
import org.teiid.designer.core.metadata.runtime.ProcedureParameterRecordImpl;
import org.teiid.designer.core.metadata.runtime.ProcedureRecordImpl;
import org.teiid.designer.core.metadata.runtime.TableRecordImpl;
import org.teiid.designer.core.metadata.runtime.TransformationRecordImpl;
import org.teiid.designer.core.metadata.runtime.VdbRecordImpl;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAnnotationAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnSetAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlDatatypeAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlForeignKeyAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlModelAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTransformationAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlVdbAspect;
import org.teiid.designer.core.metamodel.util.ColumnNameFinder;
import org.teiid.designer.core.metamodel.util.DatatypeNameFinder;
import org.teiid.designer.core.metamodel.util.ModelNameFinder;
import org.teiid.designer.core.metamodel.util.ProcedureNameFinder;
import org.teiid.designer.core.metamodel.util.TableNameFinder;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.resource.MMXmiResource;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metadata.runtime.MetadataRecord;
import org.teiid.designer.metadata.runtime.TransformationRecord;
import org.teiid.designer.metadata.runtime.impl.RecordFactory;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.metadata.QueryMetadataContext;
import org.teiid.designer.transformation.metadata.TransformationMetadata;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.UuidUtil;

public class ModelerMetadata
extends TransformationMetadata {
    private static Map systemModelByNameMap = Collections.EMPTY_MAP;
    private Container container;

    static {
        if (ModelerCore.getPlugin() != null) {
            Resource[] systemModels = ModelerCore.getSystemVdbResources();
            systemModelByNameMap = new HashMap(systemModels.length);
            int i = 0;
            while (i != systemModels.length) {
                String name = systemModels[i].getURI().trimFileExtension().lastSegment();
                systemModelByNameMap.put(name.toUpperCase(), systemModels[i]);
                ++i;
            }
        }
    }

    ModelerMetadata(QueryMetadataContext context, Container container) {
        super(context);
        this.container = container;
    }

    @Override
    public Properties getExtensionProperties(Object metadataID) {
        EmfResource emfResource;
        ModelContents contents;
        Annotation annotation;
        CoreArgCheck.isInstanceOf(MetadataRecord.class, (Object)metadataID);
        MetadataRecord metadataRecord = (MetadataRecord)metadataID;
        String uuid = metadataRecord.getUUID();
        EObject eObj = this.lookupEObject(uuid);
        Properties extProps = new Properties();
        if (eObj != null && eObj.eResource() != null && eObj.eResource() instanceof EmfResource && (annotation = (contents = new ModelContents((Resource)(emfResource = (EmfResource)eObj.eResource()))).getAnnotation(eObj)) != null) {
            for (Map.Entry entry : annotation.getTags().entrySet()) {
                extProps.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return extProps;
    }

    protected String getShortElementName(String fullElementName) {
        CoreArgCheck.isNotEmpty((String)fullElementName);
        if (UuidUtil.isStringifiedUUID(fullElementName)) {
            return UuidUtil.stripPrefixFromUUID(fullElementName);
        }
        int index = fullElementName.lastIndexOf(46);
        if (index >= 0) {
            return fullElementName.substring(index + 1);
        }
        return fullElementName;
    }

    @Override
    protected Collection findMetadataRecords(char recordType, String entityName, boolean isPartialName) throws Exception {
        EObject eObj;
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        String uuid = null;
        if (CoreStringUtil.startsWithIgnoreCase((String)entityName, (String)"mmuuid")) {
            uuid = entityName.toLowerCase();
        } else {
            String shortName = this.getShortElementName(entityName);
            if (CoreStringUtil.startsWithIgnoreCase((String)shortName, (String)"mmuuid")) {
                uuid = shortName.toLowerCase();
            }
        }
        if (uuid != null && (eObj = this.lookupEObject(uuid)) != null && (eObj.eContainer() != null || eObj.eResource() != null)) {
            eObjects.add(eObj);
        }
        if (eObjects.isEmpty()) {
            String debugMsg;
            Collection sysObjects = this.findSystemMetadataRecords(recordType, entityName, isPartialName);
            if (!sysObjects.isEmpty()) {
                return sysObjects;
            }
            List tokens = CoreStringUtil.getTokens((String)entityName, (String)".");
            String firstSegment = (String)tokens.get(0);
            if (eObjects.isEmpty() && this.getIndexSelector() instanceof ModelResourceIndexSelector) {
                if (ModelerCore.DEBUG_QUERY_RESOLUTION) {
                    debugMsg = TransformationPlugin.Util.getString("ModelerMetadata.Resolving_entity_{0}_using_index_files_1", (Object)entityName);
                    TransformationPlugin.Util.log(1, debugMsg);
                }
                ModelResourceIndexSelector resourceSelector = (ModelResourceIndexSelector)this.getIndexSelector();
                ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource(resourceSelector.getResource());
                if (modelResource != null) {
                    Collection records = super.findMetadataRecords(recordType, entityName, isPartialName);
                    if (!super.getContext().isRestrictedSearch() && records.isEmpty()) {
                        ModelWorkspaceIndexSelector workspaceSelector = new ModelWorkspaceIndexSelector();
                        super.getContext().setIndexSelector((IndexSelector)workspaceSelector);
                        records = super.findMetadataRecords(recordType, entityName, isPartialName);
                        super.getContext().setIndexSelector((IndexSelector)resourceSelector);
                    }
                    if (ModelerCore.DEBUG_QUERY_RESOLUTION) {
                        Object[] params = new Object[]{Integer.toString(records.size()), entityName};
                        String debugMsg2 = TransformationPlugin.Util.getString("ModelerMetadata.Found_{0}_records_for_the_entity_{1}_1", params);
                        ModelerCore.Util.log(1, debugMsg2);
                    }
                    if (!records.isEmpty()) {
                        return records;
                    }
                    if (uuid != null) {
                        ResourceSet[] resourceSets = this.getContainer().getExternalResourceSets();
                        int i = 0;
                        while (i < resourceSets.length) {
                            Container externalContainer;
                            EObject externalEObj;
                            ResourceSet currentResourceSet = resourceSets[i];
                            if (currentResourceSet != null && currentResourceSet instanceof Container && (externalEObj = (EObject)(externalContainer = (Container)currentResourceSet).getEObjectFinder().find((Object)uuid)) != null && (externalEObj.eContainer() != null || externalEObj.eResource() != null)) {
                                eObjects.add(externalEObj);
                            }
                            ++i;
                        }
                    }
                }
            }
            if (ModelerCore.DEBUG_QUERY_RESOLUTION) {
                debugMsg = TransformationPlugin.Util.getString("ModelerMetadata.Resolving_entity_{0}_by_navigating_the_workspace_1", (Object)entityName);
                TransformationPlugin.Util.log(1, debugMsg);
            }
            for (Resource resource : this.findResourcesByName(firstSegment)) {
                if (resource == null) continue;
                Collection entities = this.findEntitiesByName(resource, entityName, recordType, isPartialName);
                for (EObject eObj2 : entities) {
                    if (eObj2 == null || eObj2.eContainer() == null && eObj2.eResource() == null) continue;
                    eObjects.add(eObj2);
                }
            }
        }
        if (!eObjects.isEmpty()) {
            Collection records = this.createMetadataRecords(recordType, eObjects);
            if (ModelerCore.DEBUG_QUERY_RESOLUTION) {
                Object[] params = new Object[]{Integer.toString(records.size()), entityName};
                String debugMsg = TransformationPlugin.Util.getString("ModelerMetadata.Found_{0}_records_for_the_entity_{1}_1", params);
                ModelerCore.Util.log(1, debugMsg);
            }
            return records;
        }
        return Collections.EMPTY_LIST;
    }

    protected boolean isSystemModelName(String firstSegment) {
        if (CoreStringUtil.startsWithIgnoreCase((String)firstSegment, (String)"mmuuid")) {
            return false;
        }
        return systemModelByNameMap.containsKey(firstSegment.toUpperCase());
    }

    protected Collection findSystemMetadataRecords(char recordType, String entityName, boolean isPartialName) throws Exception {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        List tokens = CoreStringUtil.getTokens((String)entityName, (String)".");
        String firstSegment = (String)tokens.get(0);
        if (!this.isSystemModelName(firstSegment)) {
            return eObjects;
        }
        Object value = systemModelByNameMap.get(firstSegment.toUpperCase());
        if (value != null && value instanceof EmfResource) {
            ObjectID eResourceUuid = ((EmfResource)value).getUuid();
            Resource wsEResource = this.getContainer().getResourceFinder().findByUUID(eResourceUuid, false);
            if (wsEResource != null) {
                value = wsEResource;
            }
        }
        Collection entities = this.findEntitiesByName(value, entityName, recordType, isPartialName);
        for (EObject eObj : entities) {
            if (eObj == null || eObj.eContainer() == null && eObj.eResource() == null) continue;
            eObjects.add(eObj);
        }
        Collection records = this.createMetadataRecords(recordType, eObjects);
        if (ModelerCore.DEBUG_QUERY_RESOLUTION) {
            Object[] params = new Object[]{Integer.toString(records.size()), entityName};
            String debugMsg = TransformationPlugin.Util.getString("ModelerMetadata.Found_{0}_records_for_the_entity_{1}_1", params);
            ModelerCore.Util.log(1, debugMsg);
        }
        return records;
    }

    protected Collection createMetadataRecords(char recordType, Collection eObjects) throws Exception {
        if (eObjects != null && !eObjects.isEmpty()) {
            ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>(eObjects.size());
            Iterator eObjIter = eObjects.iterator();
            while (eObjIter.hasNext()) {
                MetadataRecord record = this.createMetadataRecord(recordType, (EObject)eObjIter.next());
                if (record == null) continue;
                records.add(record);
            }
            return records;
        }
        return Collections.EMPTY_LIST;
    }

    protected MetadataRecord createMetadataRecord(char recordType, EObject eObject) throws Exception {
        TransformationRecord record = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)eObject);
        if (!sqlAspect.isQueryable(eObject)) {
            return null;
        }
        switch (recordType) {
            case 'A': {
                if (!(sqlAspect instanceof SqlModelAspect)) break;
                record = new ModelRecordImpl((SqlModelAspect)sqlAspect, eObject);
                break;
            }
            case 'B': {
                if (!(sqlAspect instanceof SqlTableAspect)) break;
                record = new TableRecordImpl((SqlTableAspect)sqlAspect, eObject);
                break;
            }
            case 'E': {
                if (!(sqlAspect instanceof SqlProcedureAspect)) break;
                record = new ProcedureRecordImpl((SqlProcedureAspect)sqlAspect, eObject);
                break;
            }
            case 'F': {
                if (!(sqlAspect instanceof SqlProcedureParameterAspect)) break;
                record = new ProcedureParameterRecordImpl((SqlProcedureParameterAspect)sqlAspect, eObject);
                break;
            }
            case 'G': {
                if (!(sqlAspect instanceof SqlColumnAspect)) break;
                record = new ColumnRecordImpl((SqlColumnAspect)sqlAspect, eObject);
                break;
            }
            case 'C': 
            case 'H': 
            case 'I': 
            case 'K': 
            case 'L': {
                if (!(sqlAspect instanceof SqlColumnSetAspect)) break;
                record = new ColumnSetRecordImpl((SqlColumnSetAspect)sqlAspect, eObject, recordType);
                break;
            }
            case 'J': {
                if (!(sqlAspect instanceof SqlForeignKeyAspect)) break;
                record = new ForeignKeyRecordImpl((SqlForeignKeyAspect)sqlAspect, eObject);
                break;
            }
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': {
                record = this.getTransforMationRecord(sqlAspect, eObject, recordType);
                break;
            }
            case 'M': {
                if (!(sqlAspect instanceof SqlDatatypeAspect)) break;
                record = new DatatypeRecordImpl((SqlDatatypeAspect)sqlAspect, eObject);
                break;
            }
            case 'V': {
                if (!(sqlAspect instanceof SqlVdbAspect)) break;
                record = new VdbRecordImpl((SqlVdbAspect)sqlAspect, eObject);
                break;
            }
            case 'W': {
                if (!(sqlAspect instanceof SqlAnnotationAspect)) break;
                record = new AnnotationRecordImpl((SqlAnnotationAspect)sqlAspect, eObject);
                break;
            }
            case 'D': 
            case 'X': {
                return null;
            }
            default: {
                throw new TeiidDesignerException(TransformationPlugin.Util.getString("TransformationMetadata.No_known_index_file_type_associated_with_the_recordType_1", (Object)new Character(recordType)));
            }
        }
        return record;
    }

    private TransformationRecord getTransforMationRecord(SqlAspect sqlAspect, EObject eObject, char recordType) {
        if (sqlAspect instanceof SqlTransformationAspect) {
            switch (recordType) {
                case 'P': {
                    return new TransformationRecordImpl((SqlTransformationAspect)sqlAspect, eObject, "Select");
                }
                case 'Q': {
                    return new TransformationRecordImpl((SqlTransformationAspect)sqlAspect, eObject, "Insert");
                }
                case 'R': {
                    return new TransformationRecordImpl((SqlTransformationAspect)sqlAspect, eObject, "Update");
                }
                case 'S': {
                    return new TransformationRecordImpl((SqlTransformationAspect)sqlAspect, eObject, "Delete");
                }
                case 'T': {
                    return new TransformationRecordImpl((SqlTransformationAspect)sqlAspect, eObject, "Procedure");
                }
                case 'U': {
                    return new TransformationRecordImpl((SqlTransformationAspect)sqlAspect, eObject, "Mapping");
                }
            }
            throw new ModelerCoreRuntimeException(TransformationPlugin.Util.getString("TransformationMetadata.No_known_index_file_type_associated_with_the_recordType_1", (Object)new Character(recordType)));
        }
        return null;
    }

    @Override
    protected Collection findChildRecords(MetadataRecord parentRecord, char childRecordType) throws Exception {
        block19: {
            SqlAspect sqlAspect;
            EObject parentObj;
            block21: {
                block20: {
                    CoreArgCheck.isNotNull((Object)parentRecord);
                    parentObj = (EObject)parentRecord.getEObject();
                    if (parentObj == null) {
                        String uuid = parentRecord.getUUID();
                        parentObj = this.lookupEObject(uuid);
                    }
                    if (parentObj == null) break block19;
                    sqlAspect = AspectManager.getSqlAspect((EObject)parentObj);
                    if (!(sqlAspect instanceof SqlTableAspect)) break block20;
                    SqlTableAspect tableAspect = (SqlTableAspect)sqlAspect;
                    switch (childRecordType) {
                        case 'G': {
                            List columns = tableAspect.getColumns(parentObj);
                            return this.findMetadataRecords(childRecordType, columns);
                        }
                        case 'J': {
                            Collection foreignKeys = tableAspect.getForeignKeys(parentObj);
                            return this.findMetadataRecords(childRecordType, foreignKeys);
                        }
                        case 'I': {
                            Collection uniqueKeys = tableAspect.getUniqueKeys(parentObj);
                            return this.findMetadataRecords(childRecordType, uniqueKeys);
                        }
                        case 'K': {
                            EObject primaryKey = (EObject)tableAspect.getPrimaryKey(parentObj);
                            MetadataRecord record = this.createMetadataRecord(childRecordType, primaryKey);
                            if (record != null) {
                                ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>(1);
                                records.add(record);
                                return records;
                            }
                            break block19;
                        }
                        case 'H': {
                            Collection accPtterns = tableAspect.getAccessPatterns(parentObj);
                            return this.findMetadataRecords(childRecordType, accPtterns);
                        }
                        case 'L': {
                            Collection indexes = tableAspect.getIndexes(parentObj);
                            return this.findMetadataRecords(childRecordType, indexes);
                        }
                    }
                    break block19;
                }
                if (!(sqlAspect instanceof SqlProcedureAspect)) break block21;
                SqlProcedureAspect procAspect = (SqlProcedureAspect)sqlAspect;
                switch (childRecordType) {
                    case 'F': {
                        List params = procAspect.getParameters(parentObj);
                        return this.findMetadataRecords(childRecordType, params);
                    }
                    case 'C': {
                        EObject result = (EObject)procAspect.getResult(parentObj);
                        MetadataRecord record = this.createMetadataRecord(childRecordType, result);
                        if (record != null) {
                            ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>(1);
                            records.add(record);
                            return records;
                        } else {
                            break;
                        }
                    }
                }
                break block19;
            }
            if (sqlAspect instanceof SqlColumnSetAspect) {
                SqlColumnSetAspect colSetAspect = (SqlColumnSetAspect)sqlAspect;
                switch (childRecordType) {
                    case 'G': {
                        List column = colSetAspect.getColumns(parentObj);
                        return this.findMetadataRecords(childRecordType, column);
                    }
                }
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected Collection findMetadataRecords(IEntryResult[] results) {
        return RecordFactory.getMetadataRecord((IEntryResult[])results, (EObjectFinder)this.getContainer().getEObjectFinder());
    }

    @Override
    protected MetadataRecord findMetadataRecord(IEntryResult result) {
        return RecordFactory.getMetadataRecord((IEntryResult)result, (EObjectFinder)this.getContainer().getEObjectFinder());
    }

    protected final Collection getResources() {
        return super.getContext().getResources();
    }

    protected final Container getContainer() {
        return this.container;
    }

    protected EObject lookupEObject(String uuid) {
        CoreArgCheck.isNotEmpty((String)uuid);
        if (this.getResources() != null) {
            for (Resource r : this.getResources()) {
                if (r.isLoaded()) continue;
                try {
                    r.load(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    TransformationPlugin.Util.log(4, e.getLocalizedMessage());
                }
            }
        }
        EObject eObject = null;
        if (this.getContainer() != null) {
            eObject = (EObject)this.getContainer().getEObjectFinder().find((Object)uuid);
            if (eObject != null) {
                Container cntr;
                Resource resource = eObject.eResource();
                if (this.getResources() != null && (cntr = ModelerCore.getContainer((Resource)resource)) == this.getContainer() && !this.getResources().contains(resource)) {
                    return null;
                }
            }
            return eObject;
        }
        for (Resource rsrc : this.getResources()) {
            if (!(rsrc instanceof MMXmiResource ? (eObject = ((MMXmiResource)rsrc).getEObject(uuid)) != null : rsrc instanceof XSDResourceImpl && (eObject = ((XSDResourceImpl)rsrc).getEObject(uuid)) != null)) continue;
            return eObject;
        }
        return eObject;
    }

    private Collection findMetadataRecords(char recordType, Collection eObjects) throws Exception {
        ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>(eObjects.size());
        for (EObject eObj : eObjects) {
            MetadataRecord record = this.createMetadataRecord(recordType, eObj);
            if (record == null) continue;
            records.add(record);
        }
        return records;
    }

    private Collection findResourcesByName(String modelName) {
        CoreArgCheck.isNotEmpty((String)modelName);
        ArrayList<Resource> rsrcs = new ArrayList<Resource>(this.getResources() != null ? this.getResources() : this.getContainer().getResources());
        Resource[] systemModels = ModelerCore.getSystemVdbResources();
        int i = 0;
        while (i != systemModels.length) {
            Resource systemModel = systemModels[i];
            if (!rsrcs.contains(systemModel)) {
                rsrcs.add(systemModel);
            }
            ++i;
        }
        ModelEditor modelEditor = ModelerCore.getModelEditor();
        ArrayList<Resource> resources = new ArrayList<Resource>(1);
        IndexSelector selector = this.getIndexSelector();
        if (selector != null && selector instanceof ModelResourceIndexSelector) {
            ModelResourceIndexSelector resourceSelector = (ModelResourceIndexSelector)selector;
            Resource modelResource = resourceSelector.getResource();
            String resourceName = modelEditor.getModelName(modelResource);
            if (resourceName.equalsIgnoreCase(modelName)) {
                resources.add(modelResource);
            } else {
                block1: for (ModelImport modelImport : resourceSelector.getModelImports()) {
                    String importName = modelImport.getName();
                    if (!importName.equalsIgnoreCase(modelName)) continue;
                    String importPath = modelImport.getPath();
                    for (Resource resource : rsrcs) {
                        String resourceUri = URI.decode((String)resource.getURI().toString());
                        if (!CoreStringUtil.endsWithIgnoreCase((String)resourceUri, (String)importPath)) continue;
                        resources.add(resource);
                        continue block1;
                    }
                }
            }
        } else {
            for (Resource resource : rsrcs) {
                String resourceName = modelEditor.getModelName(resource);
                if (!resourceName.equalsIgnoreCase(modelName)) continue;
                resources.add(resource);
                break;
            }
        }
        if (!resources.isEmpty()) {
            return resources;
        }
        return rsrcs;
    }

    private Collection findEntitiesByName(Object container, String entityName, char recordType, boolean isPartialName) {
        CoreArgCheck.isNotEmpty((String)entityName);
        ModelNameFinder finder = null;
        switch (recordType) {
            case 'A': {
                finder = new ModelNameFinder(entityName, isPartialName);
                break;
            }
            case 'B': {
                finder = new TableNameFinder(entityName, isPartialName);
                break;
            }
            case 'E': {
                finder = new ProcedureNameFinder(entityName, isPartialName);
                break;
            }
            case 'F': 
            case 'G': {
                finder = new ColumnNameFinder(entityName, isPartialName);
                break;
            }
            case 'C': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': {
                finder = new ColumnNameFinder(entityName, isPartialName);
                break;
            }
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': {
                return this.getTransforMationsForTable(container, entityName, recordType, isPartialName);
            }
            case 'M': {
                finder = new DatatypeNameFinder(entityName, isPartialName);
                break;
            }
            case 'D': 
            case 'V': 
            case 'W': 
            case 'X': {
                break;
            }
            default: {
                throw new ModelerCoreRuntimeException(TransformationPlugin.Util.getString("TransformationMetadata.No_known_index_file_type_associated_with_the_recordType_1", (Object)new Character(recordType)));
            }
        }
        if (finder != null) {
            ModelerMetadata.executeVisitor(container, (ModelVisitor)finder, 2);
            return finder.getMatchingEObjects();
        }
        return Collections.EMPTY_LIST;
    }

    private static void executeVisitor(Object container, ModelVisitor visitor, int depth) {
        ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
        try {
            if (container instanceof Resource) {
                processor.walk((Resource)container, depth);
            } else if (container instanceof EObject) {
                processor.walk((EObject)container, depth);
            }
        }
        catch (ModelerCoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
    }

    private Collection getTransforMationsForTable(Object container, String entityName, char recordType, boolean isPartialName) {
        TableNameFinder finder = null;
        switch (recordType) {
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'U': {
                finder = new TableNameFinder(entityName, isPartialName);
                break;
            }
            case 'T': {
                finder = new ProcedureNameFinder(entityName, isPartialName);
                break;
            }
            default: {
                throw new ModelerCoreRuntimeException(TransformationPlugin.Util.getString("TransformationMetadata.No_known_index_file_type_associated_with_the_recordType_1", (Object)new Character(recordType)));
            }
        }
        ModelerMetadata.executeVisitor(container, (ModelVisitor)finder, 2);
        Collection matches = finder.getMatchingEObjects();
        ArrayList<EObject> transforms = new ArrayList<EObject>(matches.size());
        for (EObject targetObj : matches) {
            if (!SqlAspectHelper.isValidTransformationTarget((EObject)targetObj)) continue;
            EObject mappinRoot = TransformationHelper.getMappingRoot(targetObj);
            transforms.add(mappinRoot);
        }
        return transforms;
    }

    @Override
    protected Collection findChildRecordsForColumns(MetadataRecord parentRecord, char childRecordType, List uuids) throws Exception {
        Collection kids = this.findChildRecords(parentRecord, childRecordType);
        ArrayList<MetadataRecord> result = new ArrayList<MetadataRecord>();
        for (Object o : kids) {
            MetadataRecord mr = (MetadataRecord)o;
            if (!uuids.contains(mr.getUUID())) continue;
            result.add(mr);
        }
        return result;
    }
}

