/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.aspects.validation.rules;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.mapping.factory.DefaultMappableTree;
import org.teiid.designer.mapping.factory.IMappableTree;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.metamodels.transformation.InputBinding;
import org.teiid.designer.metamodels.transformation.InputParameter;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.aspects.validation.rules.XmlDocumentValidationRule;

public class InputParameterValidationRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(InputParameter.class, (Object)eObject);
        InputParameter inputParam = (InputParameter)eObject;
        if (inputParam != null) {
            MappingClass mappingClass = inputParam.getInputSet().getMappingClass();
            Iterator bindingIterator = mappingClass.getMappingClassSet().getInputBinding().iterator();
            InputBinding foundBinding = null;
            while (foundBinding == null && bindingIterator.hasNext()) {
                InputBinding binding = (InputBinding)bindingIterator.next();
                InputParameter bindingParam = binding.getInputParameter();
                if (bindingParam == null || !bindingParam.equals(inputParam)) continue;
                foundBinding = binding;
            }
            if (foundBinding == null) {
                String msg = TransformationPlugin.Util.getString("InputParameterValidationRule.The_inputParameter_{0}_on_the_inputSet_of_the_MappingClass_{1}_is_not_bound_to_any_mappingClass_column._1", new Object[]{inputParam.getName(), mappingClass.getName()});
                ValidationProblemImpl failureProblem = new ValidationProblemImpl(0, 4, msg);
                ValidationResultImpl validationResult = new ValidationResultImpl((Object)eObject);
                validationResult.addProblem((ValidationProblem)failureProblem);
                context.addResult((ValidationResult)validationResult);
            } else {
                EObject mcs = mappingClass.eContainer();
                CoreArgCheck.isInstanceOf(MappingClassSet.class, (Object)mcs);
                EObject target = ((MappingClassSet)mcs).getTarget();
                CoreArgCheck.isInstanceOf(XmlDocument.class, (Object)target);
                XmlDocument document = (XmlDocument)target;
                TreeMappingAdapter mappingAdapter = new TreeMappingAdapter((EObject)document);
                DefaultMappableTree mappableTree = new DefaultMappableTree((EObject)document);
                List parentMCs = XmlDocumentValidationRule.getParentMappingClasses(mappingClass, mappingAdapter, (IMappableTree)mappableTree);
                boolean validColumn = false;
                Iterator i = parentMCs.iterator();
                while (i.hasNext() && !validColumn) {
                    MappingClass parent = (MappingClass)i.next();
                    if (!parent.getColumns().contains((Object)foundBinding.getMappingClassColumn())) continue;
                    validColumn = true;
                }
                if (!validColumn) {
                    String msg = TransformationPlugin.Util.getString("InputParameterValidationRule.Invalid_binding", new Object[]{inputParam.getName(), mappingClass.getName()});
                    ValidationProblemImpl failureProblem = new ValidationProblemImpl(0, 4, msg);
                    ValidationResultImpl validationResult = new ValidationResultImpl((Object)eObject);
                    validationResult.addProblem((ValidationProblem)failureProblem);
                    context.addResult((ValidationResult)validationResult);
                }
            }
        }
    }
}

