/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.aspects.validation;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.ValidationAspect;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationRule;
import org.teiid.designer.core.validation.ValidationRuleSet;
import org.teiid.designer.core.validation.rules.StringLengthRule;
import org.teiid.designer.core.validation.rules.StringNameRule;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.transformation.aspects.validation.TransformationAspect;

public class MappingClassAspect
extends TransformationAspect {
    public static final ValidationRule NAME_RULE = new StringNameRule(0);
    public static final ValidationRule LENGTH_RULE = new StringLengthRule(0);

    public MappingClassAspect(MetamodelEntity entity) {
        super(entity);
    }

    public ValidationRuleSet getValidationRules() {
        this.addRule(NAME_RULE);
        this.addRule(LENGTH_RULE);
        return super.getValidationRules();
    }

    public void updateContext(EObject eObject, ValidationContext context) {
        Map transformMap = context.getTargetTransformMap();
        if (transformMap != null && transformMap.containsKey(eObject)) {
            return;
        }
        context.addTargetTransform(eObject, null);
    }

    public boolean shouldValidate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(MappingClass.class, (Object)eObject);
        if (!context.shouldIgnore((Object)eObject)) {
            List mappingRoots;
            EmfResource emfResource;
            MappingClass mappingClass = (MappingClass)eObject;
            Resource resource = mappingClass.eResource();
            ModelContents contents = null;
            if (resource instanceof EmfResource && (contents = (emfResource = (EmfResource)resource).getModelContents()) != null && !(mappingRoots = contents.getTransformationsForInput((EObject)mappingClass)).isEmpty()) {
                boolean shouldValidate = false;
                for (EObject mappingRoot : mappingRoots) {
                    ValidationAspect validAspect = AspectManager.getValidationAspect((EObject)mappingRoot);
                    if (validAspect != null && !validAspect.shouldValidate(mappingRoot, context)) continue;
                    shouldValidate = true;
                    break;
                }
                if (!shouldValidate) {
                    context.addObjectToIgnore(eObject, true);
                }
                return shouldValidate;
            }
            return true;
        }
        return false;
    }
}

