/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.aspects.sql;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.common.vdb.SystemVdbUtility;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.aspects.sql.MappingClassObjectSqlAspect;

public class MappingClassSqlAspect
extends MappingClassObjectSqlAspect
implements SqlTableAspect {
    public MappingClassSqlAspect(MetamodelEntity entity) {
        super(entity);
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'B';
    }

    public boolean isQueryable(EObject eObject) {
        return true;
    }

    public boolean supportsUpdate(EObject eObject) {
        return false;
    }

    public boolean isVirtual(EObject eObject) {
        CoreArgCheck.isInstanceOf(MappingClass.class, (Object)eObject);
        MappingClass operation = (MappingClass)eObject;
        try {
            Resource eResource = operation.eResource();
            if (eResource != null && eResource instanceof EmfResource) {
                return ((EmfResource)eResource).getModelType() == ModelType.VIRTUAL_LITERAL;
            }
        }
        catch (Exception e) {
            TransformationPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
        return false;
    }

    public boolean isMaterialized(EObject eObject) {
        return false;
    }

    public String getMaterializedTableId(EObject eObject) {
        return null;
    }

    public boolean isSystem(EObject eObject) {
        CoreArgCheck.isInstanceOf(MappingClass.class, (Object)eObject);
        String modelName = this.getModelName(eObject);
        return modelName != null && SystemVdbUtility.isSystemModelWithSystemTableType((String)modelName);
    }

    public List getColumns(EObject eObject) {
        CoreArgCheck.isInstanceOf(MappingClass.class, (Object)eObject);
        MappingClass mappingClass = (MappingClass)eObject;
        return mappingClass.getColumns();
    }

    public Collection getIndexes(EObject eObject) {
        return Collections.EMPTY_LIST;
    }

    public Collection getUniqueKeys(EObject eObject) {
        return Collections.EMPTY_LIST;
    }

    public Collection getForeignKeys(EObject eObject) {
        return Collections.EMPTY_LIST;
    }

    public Object getPrimaryKey(EObject eObject) {
        return null;
    }

    public Collection getAccessPatterns(EObject eObject) {
        return Collections.EMPTY_LIST;
    }

    public int getCardinality(EObject eObject) {
        return 0;
    }

    public int getTableType(EObject eObject) {
        CoreArgCheck.isInstanceOf(MappingClass.class, (Object)eObject);
        if (eObject instanceof StagingTable) {
            return 4;
        }
        return 3;
    }

    public int getColumnSetType() {
        return 5;
    }

    public boolean isMappable(EObject eObject, int mappingType) {
        if (this.isVirtual(eObject)) {
            return mappingType == 1;
        }
        return false;
    }

    public boolean canAcceptTransformationSource(EObject target, EObject source) {
        CoreArgCheck.isInstanceOf(MappingClass.class, (Object)target);
        CoreArgCheck.isNotNull((Object)source);
        if (source == target) {
            return false;
        }
        SqlAspect sourceSqlAspect = SqlAspectHelper.getSqlAspect((EObject)source);
        if (sourceSqlAspect instanceof SqlTableAspect) {
            if (source instanceof StagingTable) {
                return true;
            }
            if (source instanceof MappingClass) {
                return false;
            }
            return !(source instanceof InputSet) || !(target instanceof StagingTable);
        }
        return sourceSqlAspect instanceof SqlProcedureAspect && (target instanceof StagingTable || target instanceof MappingClass);
    }

    public boolean canBeTransformationSource(EObject source, EObject target) {
        CoreArgCheck.isInstanceOf(MappingClass.class, (Object)source);
        CoreArgCheck.isNotNull((Object)target);
        if (source == target) {
            return false;
        }
        return source instanceof StagingTable && target instanceof MappingClass;
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
    }

    public void setSupportsUpdate(EObject eObject, boolean supportsUpdate) {
    }
}

