/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.aspects.sql;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlValueHolder;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.aspects.sql.MappingClassObjectSqlAspect;

public class MappingClassColumnSqlAspect
extends MappingClassObjectSqlAspect
implements SqlColumnAspect {
    public MappingClassColumnSqlAspect(MetamodelEntity entity) {
        super(entity);
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'G';
    }

    public boolean isQueryable(EObject eObject) {
        return true;
    }

    private List getElementsFromMappingClassColumn(MappingClassColumn column) {
        EObject mc = column.eContainer();
        CoreArgCheck.isInstanceOf(MappingClass.class, (Object)mc);
        EObject mcs = ((MappingClass)mc).eContainer();
        CoreArgCheck.isInstanceOf(MappingClassSet.class, (Object)mcs);
        EObject target = ((MappingClassSet)mcs).getTarget();
        CoreArgCheck.isInstanceOf(XmlDocument.class, (Object)target);
        XmlDocument document = (XmlDocument)target;
        Resource documentResource = document.eResource();
        ModelContents mdlContents = new ModelContents(documentResource);
        for (MappingRoot mappingRoot : mdlContents.getTransformations((EObject)document)) {
            if (mappingRoot == null || !(mappingRoot instanceof TreeMappingRoot)) continue;
            for (Mapping nestedMapping : mappingRoot.getNested()) {
                EList inputColumns = nestedMapping.getInputs();
                EList outputElements = nestedMapping.getOutputs();
                if (!inputColumns.contains(column)) continue;
                return outputElements;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isSelectable(EObject eObject) {
        return true;
    }

    public boolean isUpdatable(EObject eObject) {
        return true;
    }

    public int getNullType(EObject eObject) {
        return 1;
    }

    public boolean isAutoIncrementable(EObject eObject) {
        return false;
    }

    public boolean isCaseSensitive(EObject eObject) {
        return true;
    }

    public boolean isSigned(EObject eObject) {
        return true;
    }

    public boolean isCurrency(EObject eObject) {
        return false;
    }

    public boolean isFixedLength(EObject eObject) {
        return false;
    }

    public boolean isTranformationInputParameter(EObject eObject) {
        return !this.isSelectable(eObject);
    }

    public int getSearchType(EObject eObject) {
        return 0;
    }

    public Object getDefaultValue(EObject eObject) {
        CoreArgCheck.isInstanceOf(MappingClassColumn.class, (Object)eObject);
        List elements = this.getElementsFromMappingClassColumn((MappingClassColumn)eObject);
        if (elements.size() != 1) {
            return null;
        }
        XmlValueHolder valueHolder = (XmlValueHolder)elements.get(0);
        if ((valueHolder.isValueDefault() || valueHolder.isValueFixed()) && valueHolder.getValue() != null) {
            return valueHolder.getValue();
        }
        return null;
    }

    public Object getMinValue(EObject eObject) {
        return null;
    }

    public Object getMaxValue(EObject eObject) {
        return null;
    }

    public String getFormat(EObject eObject) {
        return null;
    }

    public int getLength(EObject eObject) {
        return 0;
    }

    public int getScale(EObject eObject) {
        return 0;
    }

    public int getRadix(EObject eObject) {
        return 0;
    }

    public int getDistinctValues(EObject eObject) {
        return 0;
    }

    public int getNullValues(EObject eObject) {
        return 0;
    }

    public String getNativeType(EObject eObject) {
        return null;
    }

    public String getDatatypeName(EObject eObject) {
        CoreArgCheck.isInstanceOf(MappingClassColumn.class, (Object)eObject);
        MappingClassColumn column = (MappingClassColumn)eObject;
        EObject dataType = column.getType();
        DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)column, (boolean)true);
        String dtName = dtMgr.getName(dataType);
        return dtName == null ? "" : dtName;
    }

    public boolean canSetDatatype() {
        return true;
    }

    public void setDatatype(EObject eObject, EObject datatype) {
        CoreArgCheck.isInstanceOf(MappingClassColumn.class, (Object)eObject);
        MappingClassColumn column = (MappingClassColumn)eObject;
        column.setType(datatype);
    }

    public EObject getDatatype(EObject eObject) {
        CoreArgCheck.isInstanceOf(MappingClassColumn.class, (Object)eObject);
        MappingClassColumn column = (MappingClassColumn)eObject;
        return column.getType();
    }

    public String getRuntimeType(EObject eObject) {
        CoreArgCheck.isInstanceOf(MappingClassColumn.class, (Object)eObject);
        MappingClassColumn column = (MappingClassColumn)eObject;
        EObject datatype = column.getType();
        DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)column, (boolean)true);
        String rtType = dtMgr.getRuntimeTypeName(datatype);
        return rtType == null ? "" : rtType;
    }

    public String getDatatypeObjectID(EObject eObject) {
        CoreArgCheck.isInstanceOf(MappingClassColumn.class, (Object)eObject);
        MappingClassColumn column = (MappingClassColumn)eObject;
        DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)column, (boolean)true);
        return dtMgr.getUuidString(column.getType());
    }

    public int getPrecision(EObject eObject) {
        return 0;
    }

    public int getCharOctetLength(EObject eObject) {
        return 0;
    }

    public int getPosition(EObject eObject) {
        CoreArgCheck.isInstanceOf(MappingClassColumn.class, (Object)eObject);
        MappingClassColumn column = (MappingClassColumn)eObject;
        MappingClass mappingClass = column.getMappingClass();
        CoreArgCheck.isNotNull((Object)mappingClass);
        return mappingClass.getColumns().indexOf((Object)column) + 1;
    }

    public boolean canSetLength() {
        return false;
    }

    public void setLength(EObject eObject, int length) {
        throw new UnsupportedOperationException(TransformationPlugin.Util.getString("MappingClassColumnSqlAspect.Length_cannot_be_set_on_a_MappingClassColumn_1"));
    }

    public boolean canSetNullType() {
        return false;
    }

    public void setNullType(EObject eObject, int nullType) {
        throw new UnsupportedOperationException(TransformationPlugin.Util.getString("MappingClassColumnSqlAspect.NullType_cannot_be_set_on_a_MappingClassColumn_2"));
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
        CoreArgCheck.isNotNull((Object)sourceObject);
        SqlAspect columnAspect = AspectManager.getSqlAspect((EObject)sourceObject);
        CoreArgCheck.isInstanceOf(SqlColumnAspect.class, (Object)columnAspect);
        EObject srcType = ((SqlColumnAspect)columnAspect).getDatatype(sourceObject);
        this.setDatatype(targetObject, srcType);
    }

    public boolean isDatatypeFeature(EObject eObject, EStructuralFeature eFeature) {
        CoreArgCheck.isInstanceOf(MappingClassColumn.class, (Object)eObject);
        EObjectImpl eObjectImpl = super.getEObjectImpl(eObject);
        if (eObjectImpl != null) {
            switch (eObjectImpl.eDerivedStructuralFeatureID(eFeature)) {
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }
}

