/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl.importer;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.sequencer.ddl.DdlParsers;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.exception.EmptyArgumentException;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.OperationUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.NewModelObjectHelperManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ddl.DdlImporterManager;
import org.teiid.designer.ddl.DdlNodeImporter;
import org.teiid.designer.ddl.importer.DdlImporterI18n;
import org.teiid.designer.ddl.importer.DdlImporterPlugin;
import org.teiid.designer.ddl.registry.DdlNodeImporterRegistry;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.View;
import org.teiid.designer.relational.compare.DifferenceGenerator;
import org.teiid.designer.relational.compare.DifferenceReport;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.processor.EmfModelGenerator;

public class DdlImporter {
    private IProject[] projects;
    private IContainer modelFolder;
    private String ddlFileName;
    private String specifiedParser;
    private IFile modelFile;
    private DifferenceReport diffReport;
    private ModelResource model;
    private String ddlString;
    private IStatus importStatus;
    private boolean generateDefaultSQL;
    private boolean noDdlImported;
    private DdlImporterManager importManager = new DdlImporterManager();

    public DdlImporter(IProject[] projects) {
        this.projects = projects;
    }

    public String ddlFileName() {
        return this.ddlFileName;
    }

    public void importDdl(final IProgressMonitor monitor, final int totalWork) throws Exception {
        OperationUtil.perform((OperationUtil.Unreliable)new OperationUtil.Unreliable(){
            private FileReader reader = null;

            public void doIfFails() {
            }

            public void finallyDo() throws Exception {
                if (this.reader != null) {
                    this.reader.close();
                }
            }

            public void tryToDo() throws Exception {
                this.reader = new FileReader(DdlImporter.this.ddlFileName());
                DdlImporter.this.importDdl(this.reader, monitor, totalWork);
            }
        });
    }

    void importDdl(FileReader reader, IProgressMonitor monitor, int totalWork) throws Exception {
        this.ddlString = null;
        this.importManager.getImportMessages().clear();
        int workUnit = totalWork / 3;
        monitor.subTask(DdlImporterI18n.PARSING_DDL_MSG);
        char[] buf = new char[FileUtils.DEFAULT_BUFFER_SIZE];
        StringBuilder builder = new StringBuilder();
        int charTot = reader.read(buf);
        while (charTot >= 0) {
            builder.append(buf, 0, charTot);
            charTot = reader.read(buf);
        }
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        AstNode rootNode = null;
        DdlParsers parsers = new DdlParsers();
        this.ddlString = builder.toString();
        if (CoreStringUtil.isEmpty((String)this.ddlString)) {
            this.ddlString = "-- No DDL Returned";
            this.noDdlImported = true;
        }
        try {
            rootNode = !CoreStringUtil.isEmpty((String)this.specifiedParser) ? parsers.parseUsing(this.ddlString, this.specifiedParser) : parsers.parse(this.ddlString, this.ddlFileName);
        }
        catch (ParsingException e) {
            String parseMessage = e.getMessage();
            this.importManager.getImportMessages().setParseErrorMessage(parseMessage);
            Position position = e.getPosition();
            this.importManager.getImportMessages().setHasParseError(true);
            this.importManager.getImportMessages().setParseErrorColNumber(position.getColumn());
            this.importManager.getImportMessages().setParseErrorLineNumber(position.getLine());
            this.importManager.getImportMessages().setParseErrorIndex(position.getIndexInContent());
            if (!CoreStringUtil.isEmpty((String)this.specifiedParser)) {
                this.importManager.getImportMessages().setParserId(this.specifiedParser);
            } else if (rootNode != null) {
                String parserId = (String)rootNode.getProperty("ddl:parserId");
                this.importManager.getImportMessages().setParserId(parserId);
            }
            return;
        }
        String parserId = (String)rootNode.getProperty("ddl:parserId");
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.worked(workUnit);
        monitor.subTask(DdlImporterI18n.CREATING_MODEL_MSG);
        this.model = ModelerCore.create((IFile)this.modelFile);
        this.importManager.setRelationalModel(this.model);
        RelationalModel targetRelationalModel = this.importManager.getObjectFactory().createRelationalModel(this.model);
        this.importManager.setProgressMonitor(monitor);
        DdlNodeImporter nodeImporter = (DdlNodeImporter)DdlNodeImporterRegistry.getInstance().getRegistered((Object)parserId.toUpperCase());
        if (nodeImporter == null) {
            throw new Exception(DdlImporterPlugin.i18n("noDDLImporterRegisteredMsg", parserId));
        }
        this.importManager.setNodeImporter(nodeImporter);
        RelationalModel ddlImportModel = nodeImporter.importNode(rootNode, this.importManager);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.worked(workUnit);
        monitor.subTask(DdlImporterI18n.CREATING_CHANGE_REPORT_MSG);
        this.diffReport = DifferenceGenerator.compare((RelationalModel)ddlImportModel, (RelationalModel)targetRelationalModel);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.worked(workUnit);
    }

    public boolean hasParseError() {
        return this.importManager.getImportMessages().hasParseError();
    }

    public String getParseErrorMessage() {
        return this.importManager.getImportMessages().getParseErrorMessage();
    }

    public int getParseErrorIndex() {
        return this.importManager.getImportMessages().getParseErrorIndex();
    }

    public void addProgressMessage(String message) {
        this.importManager.getImportMessages().addProgressMessage(message);
    }

    public List<String> getAllMessages() {
        return this.importManager.getImportMessages().getAllMessages();
    }

    public IStatus getImportStatus() {
        return this.importStatus;
    }

    public String getDdlString() {
        return this.ddlString;
    }

    public boolean noDdlImported() {
        return this.noDdlImported;
    }

    public DifferenceReport getDifferenceReport() {
        return this.diffReport;
    }

    public IFile modelFile() {
        return this.modelFile;
    }

    public IContainer modelFolder() {
        return this.modelFolder;
    }

    public ModelType modelType() {
        return this.importManager.getModelType();
    }

    public void save(IProgressMonitor monitor, int totalWork) throws Exception {
        monitor.subTask(DdlImporterI18n.SAVING_MODEL_MSG);
        if (!this.model.exists()) {
            ModelAnnotation modelAnnotation = this.model.getModelAnnotation();
            modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            modelAnnotation.setModelType(this.importManager.getModelType());
        }
        this.importStatus = EmfModelGenerator.INSTANCE.execute(this.diffReport, this.model, monitor, totalWork);
        if (this.importManager.getModelType() == ModelType.VIRTUAL_LITERAL) {
            Properties props = new Properties();
            if (this.doGenerateDefaultSQL()) {
                props.put("generateDefaultSQL", (Object)this.generateDefaultSQL);
                props.put("validate", (Object)this.generateDefaultSQL);
            }
            ArrayList<EObject> targets = new ArrayList<EObject>();
            for (Object nextObj : this.model.getEObjects()) {
                if (!(nextObj instanceof Procedure) && !(nextObj instanceof BaseTable) && !(nextObj instanceof View)) continue;
                try {
                    NewModelObjectHelperManager.helpCreate(nextObj, (Map)props);
                    targets.add((EObject)nextObj);
                }
                catch (ModelerCoreException err) {
                    DdlImporterPlugin.UTIL.log(4, (Throwable)err, err.getMessage());
                }
            }
        }
        this.model.save(monitor, false);
        monitor.worked(totalWork);
        monitor.done();
    }

    public void setDdlFileName(String ddlFileName) {
        this.ddlFileName = null;
        if (ddlFileName == null) {
            throw new EmptyArgumentException("ddlFileName");
        }
        if ((ddlFileName = ddlFileName.trim()).isEmpty()) {
            throw new EmptyArgumentException("ddlFileName");
        }
        File file = new File(ddlFileName);
        if (!file.exists() || file.isDirectory()) {
            throw new IllegalArgumentException(DdlImporterI18n.DDL_FILE_NOT_FOUND_MSG);
        }
        this.ddlFileName = ddlFileName;
    }

    public void setModelFolder(IContainer modelFolder) {
        this.modelFolder = modelFolder;
    }

    public void setModelFolder(String modelFolderName) {
        this.modelFolder = null;
        if (modelFolderName == null) {
            throw new EmptyArgumentException("modelFolderName");
        }
        modelFolderName = modelFolderName.trim();
        IPath modelFolderPath = Path.fromPortableString((String)modelFolderName).makeAbsolute();
        if (modelFolderName.isEmpty() || modelFolderPath.segmentCount() == 0) {
            throw new EmptyArgumentException("modelFolderName");
        }
        String projectName = modelFolderPath.segment(0);
        IWorkspace workspace = ModelerCore.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        if (root.findMember(projectName) != null) {
            boolean found = false;
            IProject[] iProjectArray = this.projects;
            int n = this.projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (projectName.equals(project.getName())) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                throw new IllegalArgumentException(DdlImporterI18n.MODEL_FOLDER_IN_NON_MODEL_PROJECT_MSG);
            }
        }
        if (!workspace.validatePath(modelFolderPath.toString(), 6).isOK()) {
            throw new IllegalArgumentException(DdlImporterI18n.INVALID_MODEL_FOLDER_MSG);
        }
        IResource resource = root.findMember(modelFolderPath);
        if (resource instanceof IFile) {
            throw new IllegalArgumentException(DdlImporterI18n.MODEL_FOLDER_IS_FILE_MSG);
        }
        this.modelFolder = resource == null ? (modelFolderPath.segmentCount() == 1 ? root.getProject(projectName) : root.getFolder(modelFolderPath)) : (IContainer)resource;
    }

    public void setModelName(String modelName) {
        this.importManager.setModelName(null);
        this.modelFile = null;
        if (modelName == null) {
            throw new EmptyArgumentException("modelName");
        }
        if ((modelName = modelName.trim()).isEmpty()) {
            throw new EmptyArgumentException("modelName");
        }
        IWorkspace workspace = ModelerCore.getWorkspace();
        if (!workspace.validateName(modelName, 1).isOK()) {
            throw new IllegalArgumentException(DdlImporterI18n.INVALID_MODEL_NAME_MSG);
        }
        if (this.modelFolder != null) {
            IWorkspaceRoot root = workspace.getRoot();
            IPath modelPath = this.modelFolder.getFullPath().append(modelName);
            if (!modelName.endsWith(".xmi")) {
                modelPath = modelPath.addFileExtension(".xmi".substring(1));
            }
            if (this.modelFolder.exists()) {
                IResource resource = root.findMember(modelPath);
                if (resource instanceof IContainer) {
                    throw new IllegalArgumentException(DdlImporterI18n.MODEL_NAME_IS_FOLDER_MSG);
                }
                if (resource == null) {
                    this.modelFile = root.getFile(modelPath);
                } else {
                    if (!ModelUtil.isModelFile((IResource)resource)) {
                        throw new IllegalArgumentException(DdlImporterI18n.MODEL_NAME_IS_NON_MODEL_FILE_MSG);
                    }
                    if (!"http://www.metamatrix.com/metamodels/Relational".equals(ModelUtil.getXmiHeader((IResource)resource).getPrimaryMetamodelURI())) {
                        throw new IllegalArgumentException(DdlImporterI18n.MODEL_NAME_IS_NON_RELATIONAL_MODEL_MSG);
                    }
                    this.modelFile = (IFile)resource;
                }
            } else {
                this.modelFile = root.getFile(modelPath);
            }
        }
        this.importManager.setModelName(new Path(modelName).removeFileExtension().lastSegment());
    }

    public void setModelType(ModelType modelType) {
        this.importManager.setModelType(modelType);
    }

    public void setOptToCreateModelEntitiesForUnsupportedDdl(boolean optToCreateModelEntitiesForUnsupportedDdl) {
        this.importManager.setOptToCreateModelEntitiesForUnsupportedDdl(optToCreateModelEntitiesForUnsupportedDdl);
    }

    public void setOptToSetModelEntityDescription(boolean optToSetModelEntityDescription) {
        this.importManager.setOptToSetModelEntityDescription(optToSetModelEntityDescription);
    }

    public void setGenerateDefaultSQL(boolean value) {
        this.generateDefaultSQL = value;
    }

    public boolean doGenerateDefaultSQL() {
        return this.generateDefaultSQL;
    }

    public String getSpecifiedParser() {
        return this.specifiedParser;
    }

    public void setSpecifiedParser(String specifiedParser) {
        this.specifiedParser = specifiedParser;
    }

    public void undoImport() {
        this.diffReport = null;
    }
}

