/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.wizard;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jboss.tools.jbpm.preferences.JbpmInstallation;
import org.jboss.tools.jbpm.preferences.PreferencesManager;
import org.jbpm.gd.jpdl.Logger;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.wizard.NewProcessDefinitionWizardPage;

public class NewProcessDefinitionWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private NewProcessDefinitionWizardPage page;

    public NewProcessDefinitionWizard() {
        this.setWindowTitle("New Process Definition");
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.selection = currentSelection;
    }

    public void addPages() {
        this.page = new NewProcessDefinitionWizardPage();
        this.addPage((IWizardPage)this.page);
        this.page.init(this.selection);
    }

    public boolean performFinish() {
        try {
            IFile processDefinitionFile = this.page.getProcessDefinitionFile();
            processDefinitionFile.create((InputStream)this.createInitialProcessDefinition(), true, null);
            IFile gpdFile = this.page.getGpdFile();
            gpdFile.create((InputStream)this.createInitialGpdInfo(), true, null);
            IDE.openEditor((IWorkbenchPage)this.getActivePage(), (IFile)processDefinitionFile);
            this.openPropertiesView();
            BasicNewResourceWizard.selectAndReveal((IResource)processDefinitionFile, (IWorkbenchWindow)this.getActiveWorkbenchWindow());
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void openPropertiesView() {
        try {
            if (this.getActivePage().findView("org.eclipse.ui.views.PropertySheet") == null) {
                this.getActivePage().showView("org.eclipse.ui.views.PropertySheet");
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private IWorkbenchPage getActivePage() {
        return this.getActiveWorkbenchWindow().getActivePage();
    }

    private IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    private ByteArrayInputStream createInitialProcessDefinition() throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("\n");
        buffer.append("\n");
        buffer.append("<process-definition" + this.getSchemaText() + "  name=\"" + this.page.getProcessName() + "\"></process-definition>");
        return new ByteArrayInputStream(buffer.toString().getBytes());
    }

    private String getSchemaText() throws JavaModelException {
        if (!Plugin.getDefault().getPreferenceStore().getBoolean("exclude xsd")) {
            return "  xmlns=\"" + this.getJbpmSchemaNameSpace() + "\"";
        }
        return "";
    }

    private ByteArrayInputStream createInitialGpdInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("\n");
        buffer.append("\n");
        buffer.append("<root-container></root-container>");
        return new ByteArrayInputStream(buffer.toString().getBytes());
    }

    private String getJbpmSchemaNameSpace() throws JavaModelException {
        File file;
        block9: {
            String location;
            block8: {
                JbpmInstallation jbpmInstallation;
                block7: {
                    String jbpmName;
                    block6: {
                        try {
                            IProject project = this.page.getProcessDefinitionFile().getProject();
                            jbpmName = project.getPersistentProperty(new QualifiedName("", "jbpmName"));
                            if (jbpmName != null) break block6;
                            return "";
                        }
                        catch (CoreException coreException) {
                            return "";
                        }
                    }
                    jbpmInstallation = PreferencesManager.getInstance().getJbpmInstallation(jbpmName);
                    if (jbpmInstallation != null) break block7;
                    return "";
                }
                location = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(jbpmInstallation.location);
                if (location != null) break block8;
                return "";
            }
            file = new Path(location).append("src/resources/gpd/version.info.xml").toFile();
            if (file.exists()) break block9;
            return "";
        }
        return this.getNameSpace(file);
    }

    private String getNameSpace(File file) {
        try {
            Document document = new SAXReader().read(file);
            Attribute attribute = document.getRootElement().attribute("namespace");
            if (attribute != null) {
                return attribute.getValue();
            }
            return "";
        }
        catch (DocumentException e) {
            Logger.logError(e);
            return "";
        }
        catch (MalformedURLException e) {
            Logger.logError(e);
            return "";
        }
    }
}

