/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Timer;
import org.jbpm.gd.jpdl.properties.TimerActionConfigurationComposite;
import org.jbpm.gd.jpdl.properties.TimerGeneralConfigurationComposite;

public class TimerConfigurationComposite {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Timer timer;
    private CTabFolder timerTabFolder;
    private TimerGeneralConfigurationComposite timerGeneralConfigurationComposite;
    private TimerActionConfigurationComposite timerActionConfigurationComposite;

    public static TimerConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        TimerConfigurationComposite result = new TimerConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setTimer(Timer timer) {
        if (this.timer == timer) {
            return;
        }
        this.unhookListeners();
        this.clearControls();
        this.timer = timer;
        if (timer != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
    }

    private void unhookListeners() {
    }

    private void clearControls() {
        this.timerGeneralConfigurationComposite.setTimer(null);
        this.timerActionConfigurationComposite.setTimer(null);
    }

    private void updateControls() {
        this.timerGeneralConfigurationComposite.setTimer(this.timer);
        this.timerActionConfigurationComposite.setTimer(this.timer);
    }

    private void create() {
        this.timerTabFolder = this.widgetFactory.createTabFolder(this.parent, 2176);
        this.timerTabFolder.setLayoutData((Object)this.createTimerTabFolderLayoutData());
        this.createGeneralTabItem();
        this.createActionTabItem();
        this.timerTabFolder.setSelection(0);
    }

    private void createGeneralTabItem() {
        CTabItem generalTabItem = this.widgetFactory.createTabItem(this.timerTabFolder, 0);
        generalTabItem.setText("General");
        Composite generalTabControl = this.widgetFactory.createFlatFormComposite((Composite)this.timerTabFolder);
        this.timerGeneralConfigurationComposite = TimerGeneralConfigurationComposite.create(this.widgetFactory, generalTabControl);
        generalTabItem.setControl((Control)generalTabControl);
    }

    private void createActionTabItem() {
        CTabItem actionTabItem = this.widgetFactory.createTabItem(this.timerTabFolder, 0);
        actionTabItem.setText("Action");
        Composite actionTabControl = this.widgetFactory.createFlatFormComposite((Composite)this.timerTabFolder);
        this.timerActionConfigurationComposite = TimerActionConfigurationComposite.create(this.widgetFactory, actionTabControl);
        actionTabItem.setControl((Control)actionTabControl);
    }

    private FormData createTimerTabFolderLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 0);
        result.right = new FormAttachment(100, 0);
        result.top = new FormAttachment(0, 0);
        result.bottom = new FormAttachment(100, 0);
        return result;
    }
}

