/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.command;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.gd.common.command.AbstractEdgeCreateCommand;
import org.jbpm.gd.common.model.NamedElement;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

public class EdgeCreateCommand
extends AbstractEdgeCreateCommand {
    public void execute() {
        super.execute();
        this.initializeTransitionAttributes();
        this.getTransition().setSource(this.getTransitionSource());
        this.getTransitionSource().addTransition(this.getTransition());
    }

    public void undo() {
        this.getTransitionSource().removeTransition(this.getTransition());
        this.getTransition().setSource(null);
    }

    private void initializeTransitionAttributes() {
        this.initializeToAttribute();
        if (this.getTransitionSource().getTransitions().length > 0) {
            this.getTransition().setName("to " + this.getTransition().getTo());
            this.edge.getLabel().setText(this.getTransition().getName());
        }
    }

    private void initializeToAttribute() {
        List sourcePath = this.getPathToRootFrom(this.source);
        List targetPath = this.getPathToRootFrom(this.target);
        NotationElement common = this.findFirstCommonElement(sourcePath, targetPath);
        this.getTransition().setTo(String.valueOf(this.getPrefix(sourcePath, common)) + this.getSuffix(common, targetPath));
    }

    private List getPathToRootFrom(NotationElement notationElement) {
        ArrayList<NotationElement> result = new ArrayList<NotationElement>();
        while (notationElement != null) {
            result.add(notationElement);
            notationElement = notationElement instanceof Node ? ((Node)notationElement).getContainer() : null;
        }
        return result;
    }

    private NotationElement findFirstCommonElement(List sourcePath, List targetPath) {
        NotationElement result = null;
        int i = 1;
        while (i <= sourcePath.size() && i <= targetPath.size()) {
            if (sourcePath.get(sourcePath.size() - i) == targetPath.get(targetPath.size() - i)) {
                result = (NotationElement)sourcePath.get(sourcePath.size() - i);
            }
            ++i;
        }
        return result;
    }

    private String getPrefix(List sourcePath, NotationElement common) {
        StringBuffer result = new StringBuffer("");
        if (this.source != this.target) {
            int i = 1;
            while (i < sourcePath.size() && sourcePath.get(i) != common) {
                result.append("../");
                ++i;
            }
        }
        return result.toString();
    }

    private String getSuffix(NotationElement common, List targetPath) {
        StringBuffer result = new StringBuffer();
        if (this.source != this.target) {
            int i = 0;
            while (i < targetPath.size() && targetPath.get(i) != common) {
                result.insert(0, this.getSemanticElementName((NotationElement)targetPath.get(i++)));
                if (i >= targetPath.size() || targetPath.get(i) == common) continue;
                result.insert(0, "/");
            }
        } else {
            result.append(this.getSemanticElementName(common));
        }
        return result.toString();
    }

    private String getSemanticElementName(NotationElement notationElement) {
        return ((NamedElement)notationElement.getSemanticElement()).getName();
    }

    private NodeElement getTransitionSource() {
        return (NodeElement)this.source.getSemanticElement();
    }

    private Transition getTransition() {
        return (Transition)this.edge.getSemanticElement();
    }
}

