/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.part;

import java.beans.PropertyChangeEvent;
import java.util.Observable;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Font;
import org.jbpm.gd.common.figure.LabelFigure;
import org.jbpm.gd.common.notation.Label;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.common.part.AbstractNotationElementGraphicalEditPart;
import org.jbpm.gd.common.policy.DirectEditPolicy;
import org.jbpm.gd.common.policy.LabelGraphicalNodeEditPolicy;
import org.jbpm.gd.common.util.CellEditorLocator;
import org.jbpm.gd.common.util.DirectEditManager;

public class LabelGraphicalEditPart
extends AbstractNotationElementGraphicalEditPart {
    private DirectEditManager manager;

    public LabelGraphicalEditPart(NotationElement notationElement) {
        super(notationElement);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolciy", (EditPolicy)new LabelGraphicalNodeEditPolicy());
    }

    protected IFigure createFigure() {
        LabelFigure result = new LabelFigure();
        result.setText(((Label)this.getNotationElement()).getText());
        return new LabelFigure();
    }

    protected void refreshVisuals() {
        String text = ((Label)this.getNotationElement()).getText();
        Polyline polyline = (Polyline)((GraphicalEditPart)this.getParent()).getFigure();
        Point offset = ((Label)this.getNotationElement()).getOffset();
        if (offset == null) {
            offset = this.calculateInitialOffset(polyline);
            ((Label)this.getNotationElement()).setOffset(offset);
        }
        LabelFigure figure = (LabelFigure)this.getFigure();
        figure.setText(text);
        LabelConstraint constraint = new LabelConstraint(text, offset, polyline);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
    }

    private Point calculateInitialOffset(Polyline polyline) {
        Point result = new Point(5, -10);
        Point start = polyline.getStart();
        Point end = polyline.getEnd();
        Point mid = start.getNegated().getTranslated(end).getScaled(0.5);
        if (mid.x < -10) {
            result.y = 10;
        }
        return result;
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTracker(this){

            protected EditPart getTargetEditPart() {
                return LabelGraphicalEditPart.this.getParent();
            }
        };
    }

    private void performDirectEdit() {
        if (this.manager == null) {
            this.initializeManager();
        }
        this.manager.show();
    }

    private void initializeManager() {
        CellEditorLocator locator = new CellEditorLocator((LabelFigure)this.getFigure());
        this.manager = new DirectEditManager((GraphicalEditPart)this, TextCellEditor.class, locator);
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        }
    }

    public void update(Observable arg0, Object arg1) {
        this.refreshVisuals();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String eventName = evt.getPropertyName();
        if (eventName.equals("text") || eventName.equals("offset")) {
            this.refreshVisuals();
        }
    }

    private class LabelConstraint
    implements Locator {
        String text;
        Point offset;
        Polyline polyline;

        public LabelConstraint(String text, Point offset, Polyline polyline) {
            this.text = text;
            this.offset = offset;
            this.polyline = polyline;
        }

        public void relocate(IFigure figure) {
            Dimension minimum = FigureUtilities.getTextExtents((String)this.text, (Font)figure.getFont());
            figure.setSize(minimum);
            Point location = this.polyline.getPoints().getMidpoint();
            Point offsetCopy = this.offset.getCopy();
            offsetCopy.translate(location);
            figure.setLocation(offsetCopy);
        }
    }
}

