/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.figure;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jbpm.gd.common.figure.AbstractNodeFigure;
import org.jbpm.gd.common.figure.FixedAnchor;
import org.jbpm.gd.common.figure.NodeHeaderFigure;
import org.jbpm.gd.jpdl.Constants;

public class NodeFigure
extends AbstractNodeFigure {
    private FixedAnchor selfReferencingAnchor;
    private NodeHeaderFigure header;
    private IFigure body;

    public NodeFigure(String nodeType) {
        this(nodeType, nodeType);
    }

    public NodeFigure(String nodeType, ImageDescriptor imageDescriptor) {
        this(nodeType, nodeType, imageDescriptor);
    }

    public NodeFigure(String nodeType, boolean hideName) {
        this(nodeType, nodeType, hideName);
    }

    public NodeFigure(String nodeType, boolean hideName, ImageDescriptor imageDescriptor) {
        this(nodeType, nodeType, hideName, imageDescriptor);
    }

    public NodeFigure(String nodeType, String iconName) {
        this(nodeType, iconName, false);
    }

    public NodeFigure(String nodeType, String iconName, ImageDescriptor imageDescriptor) {
        this(nodeType, iconName, false, imageDescriptor);
    }

    public NodeFigure(String nodeType, String iconName, boolean hideName) {
        this.header = new NodeHeaderFigure(nodeType, iconName, hideName);
        this.initialize();
    }

    public NodeFigure(String nodeType, String iconName, boolean hideName, ImageDescriptor imageDescriptor) {
        this.header = new NodeHeaderFigure(nodeType, iconName, hideName, imageDescriptor);
        this.initialize();
    }

    public NodeFigure(String nodeType, ImageDescriptor iconDescriptor, boolean hideName) {
        this.header = new NodeHeaderFigure(nodeType, iconDescriptor, hideName);
        this.initialize();
    }

    private void initialize() {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setSpacing(2);
        layout.setStretchMinorAxis(true);
        this.setLayoutManager((LayoutManager)layout);
        this.setOpaque(true);
        this.add((IFigure)this.header);
        this.connectionAnchor = new ChopboxAnchor((IFigure)this);
        this.selfReferencingAnchor = new FixedAnchor((IFigure)this);
        this.body = new Figure();
        this.body.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.add(this.body);
    }

    public IFigure getContentPane() {
        return this.body;
    }

    public void setName(String name) {
        this.header.setNodeName(name);
        this.getLayoutManager().layout((IFigure)this);
    }

    public Label getNameLabel() {
        return this.header.getNameLabel();
    }

    public ConnectionAnchor getSelfReferencingAnchor() {
        return this.selfReferencingAnchor;
    }

    protected void paintBorder(Graphics graphics) {
        Rectangle bounds = this.getBounds().getCopy();
        Point origin = bounds.getLocation();
        int height = bounds.height;
        int width = bounds.width;
        graphics.translate(origin);
        graphics.setForegroundColor(ColorConstants.lightGray);
        graphics.drawLine(0, 0, width - 2, 0);
        graphics.drawLine(width - 2, 0, width - 2, height - 2);
        graphics.drawLine(width - 2, height - 2, 0, height - 2);
        graphics.drawLine(0, height - 2, 0, 0);
        graphics.setForegroundColor(Constants.veryLightGray);
        graphics.drawLine(width - 1, 1, width - 1, height - 1);
        graphics.drawLine(width - 1, height - 1, 1, height - 1);
    }
}

