/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.editor;

import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.jbpm.gd.common.editor.ActionRegistry;
import org.jbpm.gd.common.editor.ContentProvider;
import org.jbpm.gd.common.editor.CreationFactory;
import org.jbpm.gd.common.editor.GraphPage;
import org.jbpm.gd.common.editor.GraphicalViewer;
import org.jbpm.gd.common.editor.OutlineViewer;
import org.jbpm.gd.common.editor.SelectionSynchronizer;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.common.notation.NotationElementFactory;
import org.jbpm.gd.common.notation.RootContainer;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.common.xml.XmlAdapterFactory;
import org.jbpm.gd.jpdl.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Editor
extends XMLMultiPageEditorPart
implements ITabbedPropertySheetPageContributor {
    private ActionRegistry actionRegistry;
    private EditDomain editDomain;
    private CommandStackListener commandStackListener;
    private boolean isDirty = false;
    private ISelectionListener selectionListener;
    private SelectionSynchronizer selectionSynchronizer;
    private SemanticElementFactory semanticElementFactory;
    private NotationElementFactory notationElementFactory;
    private RootContainer rootContainer;
    private GraphPage graphPage;
    private StructuredTextEditor sourcePage;
    private MenuManager sourceContextMenuManager;
    private ContentProvider contentProvider;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.initActionRegistry();
        this.initEditDomain();
        this.initCommandStackListener();
        this.initSelectionListener();
        this.initSelectionSynchronizer();
    }

    protected void createPages() {
        super.createPages();
        this.initSourcePage();
        this.initGraphPage();
        this.setActivePage(0);
        this.checkReadOnly();
    }

    protected void addPage(int index, IEditorPart part, String label) {
        try {
            this.addPage(index, part, this.getEditorInput());
            this.setPageText(index, label);
        }
        catch (PartInitException e) {
            Logger.logError("Could not create editor page", e);
        }
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    private void initActionRegistry() {
        this.actionRegistry = new ActionRegistry((IEditorPart)this);
    }

    private void initEditDomain() {
        this.editDomain = new DefaultEditDomain((IEditorPart)this);
    }

    private void initSelectionSynchronizer() {
        this.selectionSynchronizer = this.createSelectionSynchronizer();
    }

    private void initCommandStackListener() {
        this.commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Editor.this.handleCommandStackChanged();
            }
        };
        this.getCommandStack().addCommandStackListener(this.commandStackListener);
    }

    private void initSelectionListener() {
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                Editor.this.getActionRegistry().updateEditPartActions();
            }
        };
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener(this.selectionListener);
    }

    protected void initGraphPage() {
        this.graphPage = new GraphPage(this);
        this.addPage(0, (IEditorPart)this.graphPage, "Diagram");
        this.getContentProvider().addNotationInfo(this.getRootContainer(), this.getEditorInput());
    }

    protected void initSourcePage() {
        int pageCount = this.getPageCount();
        int i = 0;
        while (i < pageCount) {
            if (this.getEditor(i) instanceof StructuredTextEditor) {
                this.sourcePage = (StructuredTextEditor)this.getEditor(i);
                SemanticElement semanticElement = this.getSemanticElement(this.sourcePage);
                CreationFactory factory = new CreationFactory(semanticElement.getElementId(), this.getSemanticElementFactory(), this.getNotationElementFactory());
                this.setRootContainer((RootContainer)factory.getNewObject());
                this.getRootContainer().setSemanticElement(semanticElement);
                semanticElement.addPropertyChangeListener(this.getRootContainer());
            }
            ++i;
        }
        if (this.sourcePage != null) {
            this.initSourcePageContextMenu((Control)this.sourcePage.getTextViewer().getTextWidget());
        }
    }

    private SemanticElement getSemanticElement(StructuredTextEditor sourcePage) {
        Node node = this.getDocumentElement(sourcePage);
        XmlAdapterFactory factory = new XmlAdapterFactory(node.getOwnerDocument(), this.getSemanticElementFactory());
        XmlAdapter xmlAdapter = factory.adapt(node);
        SemanticElement semanticElement = this.createMainElement();
        xmlAdapter.initialize(semanticElement);
        return semanticElement;
    }

    private Node getDocumentElement(StructuredTextEditor sourcePage) {
        Element result = null;
        Document document = (Document)sourcePage.getAdapter(Document.class);
        if (document != null) {
            result = document.getDocumentElement();
        }
        return result;
    }

    private void initSourcePageContextMenu(Control control) {
        this.sourceContextMenuManager = new MenuManager("#PopupMenu");
        this.sourceContextMenuManager.setRemoveAllWhenShown(true);
        this.sourceContextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                Editor.this.fillContextMenu(m);
            }
        });
        Menu menu = this.sourceContextMenuManager.createContextMenu(control);
        this.getSite().registerContextMenu("org.jbpm.ui.editor.DesignerEditor.SourcePopupMenu", this.sourceContextMenuManager, this.getSite().getSelectionProvider());
        control.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    private void handleCommandStackChanged() {
        this.getActionRegistry().updateStackActions();
        if (!this.isDirty() && this.getCommandStack().isDirty() && this.editAllowed()) {
            this.setDirty(true);
        }
    }

    private boolean editAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        IKeyBindingService service;
        if (newPageIndex == 0 && (service = this.getSite().getKeyBindingService()) instanceof INestableKeyBindingService) {
            INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
            nestableService.activateKeyBindingService(null);
        }
        super.pageChange(newPageIndex);
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.isDirty || super.isDirty();
    }

    public ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public GraphPage getGraphPage() {
        return this.graphPage;
    }

    public EditDomain getEditDomain() {
        return this.editDomain;
    }

    public CommandStack getCommandStack() {
        return this.editDomain.getCommandStack();
    }

    public void setSelectionSynchronizer(SelectionSynchronizer selectionSynchronizer) {
        this.selectionSynchronizer = selectionSynchronizer;
    }

    public SelectionSynchronizer getSelectionSynchronizer() {
        return this.selectionSynchronizer;
    }

    public SemanticElementFactory getSemanticElementFactory() {
        if (this.semanticElementFactory == null) {
            this.semanticElementFactory = new SemanticElementFactory(this.getContributorId());
        }
        return this.semanticElementFactory;
    }

    public NotationElementFactory getNotationElementFactory() {
        if (this.notationElementFactory == null) {
            this.notationElementFactory = new NotationElementFactory();
        }
        return this.notationElementFactory;
    }

    public RootContainer getRootContainer() {
        return this.rootContainer;
    }

    public void setRootContainer(RootContainer rootContainer) {
        this.rootContainer = rootContainer;
    }

    public ContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = this.createContentProvider();
        }
        return this.contentProvider;
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.getGraphPage().getDesignerModelViewer();
    }

    public OutlineViewer getOutlineViewer() {
        return this.getGraphPage().getOutlineViewer();
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        if (adapter == CommandStack.class) {
            result = this.getCommandStack();
        } else {
            if (adapter == IContentOutlinePage.class) {
                return this.getOutlineViewer();
            }
            if (adapter == IPropertySheetPage.class) {
                return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            if (adapter == org.eclipse.gef.GraphicalViewer.class) {
                return this.getGraphicalViewer();
            }
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.checkReadOnly()) {
            return;
        }
        super.doSave(monitor);
        this.getGraphPage().doSave(monitor);
        boolean saved = this.getContentProvider().saveToInput(this.getEditorInput(), this.getRootContainer());
        if (saved) {
            this.getCommandStack().markSaveLocation();
            this.setDirty(false);
            this.firePropertyChange(257);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected SelectionSynchronizer createSelectionSynchronizer() {
        return new SelectionSynchronizer();
    }

    private boolean checkReadOnly() {
        IFile inputFile = ((FileEditorInput)this.getEditorInput()).getFile();
        IContainer inputFolder = inputFile.getParent();
        IFile notationInfoFile = inputFolder.getFile((IPath)new Path(this.getContentProvider().getNotationInfoFileName(inputFile.getName())));
        IFile diagramImageFile = inputFolder.getFile((IPath)new Path(this.getContentProvider().getDiagramImageFileName(inputFile.getName())));
        String readOnlyFiles = "";
        ArrayList<IFile> readOnlyFilesList = new ArrayList<IFile>();
        if (inputFile.isReadOnly()) {
            readOnlyFiles = String.valueOf(readOnlyFiles) + "- " + inputFile.getFullPath().toOSString() + "\n";
            readOnlyFilesList.add(inputFile);
        }
        if (notationInfoFile.exists() && notationInfoFile.isReadOnly()) {
            readOnlyFiles = String.valueOf(readOnlyFiles) + "- " + notationInfoFile.getFullPath().toOSString() + "\n";
            readOnlyFilesList.add(notationInfoFile);
        }
        if (diagramImageFile.exists() && diagramImageFile.isReadOnly()) {
            readOnlyFiles = String.valueOf(readOnlyFiles) + "- " + diagramImageFile.getFullPath().toOSString() + "\n";
            readOnlyFilesList.add(diagramImageFile);
        }
        if (readOnlyFilesList.isEmpty()) {
            return true;
        }
        boolean answer = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Read-only Input Files Detected", (String)("The following files have a read-only indicator which needs to be changed to read-write in order to be able to save the process correctly.\n\n" + readOnlyFiles + "\n" + "Do you want to perform this change now?"));
        if (answer) {
            try {
                ResourceAttributes resourceAttributes = new ResourceAttributes();
                resourceAttributes.setReadOnly(false);
                int i = 0;
                while (i < readOnlyFilesList.size()) {
                    ((IFile)readOnlyFilesList.get(i)).setResourceAttributes(resourceAttributes);
                    ++i;
                }
                return false;
            }
            catch (CoreException e) {
                Logger.logError("Error while trying to set files writeable", e);
                return true;
            }
        }
        return true;
    }

    protected abstract ContentProvider createContentProvider();

    protected abstract SemanticElement createMainElement();

    protected abstract GraphicalViewer createGraphicalViewer();

    protected abstract OutlineViewer createOutlineViewer();
}

