/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.validation;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.validation.IDiagramProfile;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.validation.Messages;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.validation.ServletUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.osgi.util.NLS;

public class CallActivityConstraint
extends AbstractModelConstraint {
    private IDiagramProfile profile;
    private String uuid = "uuid";

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        if (eObj instanceof CallActivity) {
            CallActivity ca = (CallActivity)eObj;
            if (ca.getCalledElementRef() == null) {
                ctx.createFailureStatus(new Object[]{Messages.CallActivityConstraint_No_Called_Element});
            } else {
                String[] packageAssetInfo = ServletUtil.findPackageAndAssetInfo(this.uuid, this.profile);
                String packageName = packageAssetInfo[0];
                List<String> allProcessesInPackage = ServletUtil.getAllProcessesInPackage(packageName, this.profile);
                boolean foundCalledElementProcess = false;
                for (String p : allProcessesInPackage) {
                    String processContent = ServletUtil.getProcessSourceContent(packageName, p, this.profile);
                    Pattern pattern = Pattern.compile("<\\S*process[\\s\\S]*id=\"" + ca.getCalledElementRef() + "\"", 8);
                    Matcher m = pattern.matcher(processContent);
                    if (!m.find()) continue;
                    foundCalledElementProcess = true;
                    break;
                }
                foundCalledElementProcess = true;
                if (!foundCalledElementProcess) {
                    ctx.createFailureStatus(new Object[]{NLS.bind((String)Messages.CallActivityConstraint_No_Process, (Object)ca.getCalledElementRef())});
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

