/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.ManualTask;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.ScriptTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.modeler.core.IBpmn2RuntimeExtension;
import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.features.ICustomElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.PropertiesCompositeFactory;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskImageProvider;
import org.eclipse.bpmn2.modeler.core.runtime.ModelExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.Messages;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.ProcessVariableNameChangeAdapter;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.features.JbpmCustomTaskFeatureContainer;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.drools.GlobalType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.drools.ImportType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmActivityDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmCommonEventDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmDataAssociationDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmDataItemsPropertySection;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmDefinitionsPropertySection;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmGatewayDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmImportTypeDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmInterfaceDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmItemDefinitionDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmItemDefinitionListComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmManualTaskDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmMultiInstanceDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmReceiveTaskDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmScriptTaskDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmSendTaskDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmSequenceFlowDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.JbpmTaskDetailComposite;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid.WIDException;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid.WIDHandler;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid.WorkItemDefinition;
import org.eclipse.bpmn2.modeler.ui.DefaultBpmn2RuntimeExtension;
import org.eclipse.bpmn2.modeler.ui.wizards.FileService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.xml.sax.InputSource;

public class JBPM5RuntimeExtension
implements IBpmn2RuntimeExtension,
ResourceSetListener {
    public static final String JBPM5_RUNTIME_ID = "org.jboss.runtime.jbpm5";
    private static final String DROOLS_NAMESPACE = "http://www.jboss.org/drools";
    private List<WorkItemDefinition> workItemDefinitions;
    private static boolean initialized = false;

    public boolean isContentForRuntime(IEditorInput input) {
        InputSource source = new InputSource(FileService.getInputContents((IEditorInput)input));
        DefaultBpmn2RuntimeExtension.RootElementParser parser = new DefaultBpmn2RuntimeExtension.RootElementParser(DROOLS_NAMESPACE);
        parser.parse(source);
        return parser.getResult();
    }

    public String getTargetNamespace(ModelUtil.Bpmn2DiagramType diagramType) {
        return DROOLS_NAMESPACE;
    }

    public List<WorkItemDefinition> getWorkItemDefinitions() {
        if (this.workItemDefinitions == null) {
            this.workItemDefinitions = new ArrayList<WorkItemDefinition>();
        }
        return this.workItemDefinitions;
    }

    public WorkItemDefinition getWorkItemDefinition(String taskName) {
        List<WorkItemDefinition> wids = this.getWorkItemDefinitions();
        for (WorkItemDefinition wid : wids) {
            if (!taskName.equals(wid.getName())) continue;
            return wid;
        }
        return null;
    }

    public void notify(LifecycleEvent event) {
        if (event.eventType == LifecycleEvent.EventType.EDITOR_INITIALIZED) {
            IProject project;
            DiagramEditor editor;
            ISelection sel;
            if (!initialized) {
                PropertiesCompositeFactory.register(Activity.class, JbpmActivityDetailComposite.class);
                PropertiesCompositeFactory.register(DataInput.class, JbpmDataAssociationDetailComposite.class);
                PropertiesCompositeFactory.register(DataOutput.class, JbpmDataAssociationDetailComposite.class);
                PropertiesCompositeFactory.register(Event.class, JbpmCommonEventDetailComposite.class);
                PropertiesCompositeFactory.register(Gateway.class, JbpmGatewayDetailComposite.class);
                PropertiesCompositeFactory.register(GlobalType.class, JbpmDataItemsPropertySection.GlobalTypeDetailComposite.class);
                PropertiesCompositeFactory.register(ImportType.class, JbpmImportTypeDetailComposite.class);
                PropertiesCompositeFactory.register(ItemDefinition.class, JbpmItemDefinitionListComposite.class);
                PropertiesCompositeFactory.register(ManualTask.class, JbpmManualTaskDetailComposite.class);
                PropertiesCompositeFactory.register(Message.class, JbpmDefinitionsPropertySection.JbpmMessageDetailComposite.class);
                PropertiesCompositeFactory.register(Message.class, JbpmDefinitionsPropertySection.JbpmMessageListComposite.class);
                PropertiesCompositeFactory.register(MultiInstanceLoopCharacteristics.class, JbpmMultiInstanceDetailComposite.class);
                PropertiesCompositeFactory.register(ReceiveTask.class, JbpmReceiveTaskDetailComposite.class);
                PropertiesCompositeFactory.register(ScriptTask.class, JbpmScriptTaskDetailComposite.class);
                PropertiesCompositeFactory.register(SendTask.class, JbpmSendTaskDetailComposite.class);
                PropertiesCompositeFactory.register(SequenceFlow.class, JbpmSequenceFlowDetailComposite.class);
                PropertiesCompositeFactory.register(Task.class, JbpmTaskDetailComposite.class);
                PropertiesCompositeFactory.register(ItemDefinition.class, JbpmItemDefinitionDetailComposite.class);
                PropertiesCompositeFactory.register(Interface.class, JbpmInterfaceDetailComposite.class);
                initialized = true;
            }
            if ((sel = (editor = (DiagramEditor)event.target).getEditorSite().getWorkbenchWindow().getSelectionService().getSelection()) instanceof IStructuredSelection) {
                ((IStructuredSelection)sel).getFirstElement();
            }
            if ((project = Bpmn2Preferences.getActiveProject()) != null) {
                this.getWorkItemDefinitions();
                this.workItemDefinitions.clear();
                try {
                    WIDResourceVisitor visitor = new WIDResourceVisitor();
                    project.accept((IResourceVisitor)visitor, 2, false);
                    if (visitor.getWIDFiles().size() > 0) {
                        for (IFile file : visitor.getWIDFiles()) {
                            LinkedHashMap widMap = new LinkedHashMap();
                            WIDHandler.evaluateWorkDefinitions((Map<String, WorkItemDefinition>)widMap, file);
                            this.workItemDefinitions.addAll(((HashMap)widMap).values());
                        }
                    }
                    if (!this.workItemDefinitions.isEmpty()) {
                        ArrayList<CustomTaskDescriptor> removed = new ArrayList<CustomTaskDescriptor>();
                        for (CustomTaskDescriptor d : TargetRuntime.getCurrentRuntime().getCustomTaskDescriptors()) {
                            if (d.isPermanent()) continue;
                            removed.add(d);
                        }
                        TargetRuntime.getCurrentRuntime().getCustomTaskDescriptors().removeAll(removed);
                        for (final WorkItemDefinition wid : this.workItemDefinitions) {
                            final CustomTaskDescriptor ctd = this.convertWIDtoCT(wid);
                            if (ctd == null) continue;
                            if (TargetRuntime.getCurrentRuntime().customTaskExists(ctd.getId())) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.JBPM5RuntimeExtension_Duplicate_Task_Title, (String)(String.valueOf(Messages.JBPM5RuntimeExtension_Duplicate_Task_Message) + ctd.getId() + "' was already defined.\n" + "The new Custom Task defined in the file: " + wid.getDefinitionFile().getFullPath().toString() + "\n" + "will be ignored."));
                                    }
                                });
                                continue;
                            }
                            TargetRuntime.getCurrentRuntime().addCustomTask(ctd);
                        }
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (WIDException e) {
                    e.printStackTrace();
                }
            }
            editor.getEditingDomain().addResourceSetListener((ResourceSetListener)this);
        }
    }

    private CustomTaskDescriptor convertWIDtoCT(WorkItemDefinition wid) {
        if (wid != null) {
            String id = wid.getName();
            String name = wid.getDisplayName();
            CustomTaskDescriptor ct = new CustomTaskDescriptor(id, name);
            ct.setType("Task");
            ct.setDescription(wid.getDescription());
            ct.setCategory(wid.getCategory());
            ct.setFeatureContainer((ICustomElementFeatureContainer)new JbpmCustomTaskFeatureContainer());
            ct.getFeatureContainer().setCustomTaskDescriptor(ct);
            ct.getFeatureContainer().setId(id);
            this.setBasicProps(ct, wid);
            IProject project = Bpmn2Preferences.getActiveProject();
            String iconPath = this.getWIDPropertyValue("icon", wid);
            if (iconPath != null) {
                Path tempPath = new Path(iconPath);
                String iconName = tempPath.lastSegment();
                IconResourceVisitor visitor = new IconResourceVisitor(iconName);
                try {
                    project.accept((IResourceVisitor)visitor, 2, false);
                    if (visitor.getIconResources() != null && visitor.getIconResources().size() > 0) {
                        ArrayList<IResource> icons = visitor.getIconResources();
                        IResource icon = icons.get(0);
                        URL url = icon.getLocationURI().toURL();
                        ImageDescriptor image = ImageDescriptor.createFromURL((URL)url);
                        CustomTaskImageProvider.registerImage((String)iconPath, (ImageDescriptor)image);
                    }
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            ModelExtensionDescriptor.Property ioSpecification = this.createIOSpecificationSection(ct, wid);
            this.createDataAssociations(ioSpecification, ct);
            return ct;
        }
        return null;
    }

    private String getWIDPropertyValue(String propName, WorkItemDefinition wid) {
        if (propName.equalsIgnoreCase("taskname")) {
            return wid.getName();
        }
        if (propName.equalsIgnoreCase("displayName")) {
            return wid.getDisplayName();
        }
        if (propName.equalsIgnoreCase("icon")) {
            return wid.getIcon();
        }
        if (propName.equalsIgnoreCase("customEditor")) {
            return wid.getCustomEditor();
        }
        if (propName.equalsIgnoreCase("eclipse:customEditor")) {
            return wid.getEclipseCustomEditor();
        }
        return null;
    }

    private ModelExtensionDescriptor.Property getPropertyFromWID(String propName, WorkItemDefinition wid) {
        String name = propName;
        String value = this.getWIDPropertyValue(propName, wid);
        String description = null;
        String type = "EString";
        ModelExtensionDescriptor.Property prop = new ModelExtensionDescriptor.Property(null, name, description);
        prop.type = type;
        if (value == null && propName.equalsIgnoreCase("icon")) {
            value = "task.png";
        }
        if (value != null) {
            prop.getValues().add(value);
        }
        return prop;
    }

    private void createDataAssociations(ModelExtensionDescriptor.Property ioSpecification, CustomTaskDescriptor ct) {
        Object[] values = ioSpecification.getValues().toArray();
        int inputCounter = -1;
        int i = 0;
        while (i < values.length) {
            if (values[i] instanceof ModelExtensionDescriptor.Property) {
                ModelExtensionDescriptor.Property prop = (ModelExtensionDescriptor.Property)values[i];
                if (prop.name.equals("dataInputs")) {
                    ModelExtensionDescriptor.Property dataInputAssociations = new ModelExtensionDescriptor.Property(prop, "dataInputAssociations", null);
                    ModelExtensionDescriptor.Property targetRef = new ModelExtensionDescriptor.Property(dataInputAssociations, "targetRef", null);
                    targetRef.ref = "ioSpecification/dataInputs#" + ++inputCounter;
                    dataInputAssociations.getValues().add(targetRef);
                    ct.getProperties().add(dataInputAssociations);
                }
            }
            ++i;
        }
    }

    private ModelExtensionDescriptor.Property createIOSpecificationSection(CustomTaskDescriptor ct, WorkItemDefinition wid) {
        ModelExtensionDescriptor.Property ioSpecification = new ModelExtensionDescriptor.Property(null, "ioSpecification", null);
        for (Map.Entry<String, String> entry : wid.getParameters().entrySet()) {
            ModelExtensionDescriptor.Property dataInputs = new ModelExtensionDescriptor.Property(ioSpecification, "dataInputs", null);
            ModelExtensionDescriptor.Property dataInputsName = new ModelExtensionDescriptor.Property(dataInputs, "name", null);
            dataInputsName.getValues().add(entry.getKey());
            dataInputs.getValues().add(dataInputsName);
            ioSpecification.getValues().add(dataInputs);
        }
        for (Map.Entry<String, String> entry : wid.getResults().entrySet()) {
            ModelExtensionDescriptor.Property dataOutputs = new ModelExtensionDescriptor.Property(ioSpecification, "dataOutputs", null);
            ModelExtensionDescriptor.Property dataOutputsName = new ModelExtensionDescriptor.Property(dataOutputs, "name", null);
            dataOutputsName.getValues().add(entry.getKey());
            dataOutputs.getValues().add(dataOutputsName);
            ioSpecification.getValues().add(dataOutputs);
        }
        Object[] values = ioSpecification.getValues().toArray();
        int inputCounter = -1;
        int outputCounter = -1;
        ModelExtensionDescriptor.Property inputSets = new ModelExtensionDescriptor.Property(ioSpecification, "inputSets", null);
        ModelExtensionDescriptor.Property outputSets = new ModelExtensionDescriptor.Property(ioSpecification, "outputSets", null);
        int i = 0;
        while (i < values.length) {
            if (values[i] instanceof ModelExtensionDescriptor.Property) {
                ModelExtensionDescriptor.Property prop = (ModelExtensionDescriptor.Property)values[i];
                if (prop.name.equals("dataInputs")) {
                    ModelExtensionDescriptor.Property inputSetsRef = new ModelExtensionDescriptor.Property(inputSets, "dataInputRefs", null);
                    inputSetsRef.ref = "ioSpecification/dataInputs#" + ++inputCounter;
                    inputSets.getValues().add(inputSetsRef);
                } else if (prop.name.equals("dataOutputs")) {
                    ModelExtensionDescriptor.Property outputSetsRef = new ModelExtensionDescriptor.Property(outputSets, "dataOutputRefs", null);
                    outputSetsRef.ref = "ioSpecification/dataOutputs#" + ++outputCounter;
                    outputSets.getValues().add(outputSetsRef);
                }
            }
            ++i;
        }
        if (inputSets.getValues().size() > 0) {
            ioSpecification.getValues().add(inputSets);
        }
        if (outputSets.getValues().size() > 0) {
            ioSpecification.getValues().add(outputSets);
        }
        ct.getProperties().add(ioSpecification);
        return ioSpecification;
    }

    private void setBasicProps(CustomTaskDescriptor ct, WorkItemDefinition wid) {
        String[] basicProps = new String[]{"taskName", "displayName", "icon"};
        int i = 0;
        while (i < basicProps.length) {
            ModelExtensionDescriptor.Property prop = this.getPropertyFromWID(basicProps[i], wid);
            ct.getProperties().add(prop);
            ++i;
        }
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        return null;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        for (Notification n : event.getNotifications()) {
            Adapter a2;
            EObject object;
            if (n.getEventType() != 3 || !(n.getNewValue() instanceof EObject) || !((object = (EObject)n.getNewValue()) instanceof Property) && !(object instanceof DataObject) && !(object instanceof Message) && !(object instanceof GlobalType)) continue;
            boolean found = false;
            for (Adapter a2 : object.eAdapters()) {
                if (!(a2 instanceof ProcessVariableNameChangeAdapter)) continue;
                found = true;
                break;
            }
            if (found) continue;
            a2 = new ProcessVariableNameChangeAdapter();
            object.eAdapters().add((Object)a2);
        }
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    private class IconResourceVisitor
    implements IResourceVisitor {
        private ArrayList<IResource> iconResources = new ArrayList();
        private String iconName;

        public IconResourceVisitor(String iconName) {
            this.iconName = iconName;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1 && ((IFile)resource).getName().equalsIgnoreCase(this.iconName)) {
                this.iconResources.add(resource);
                return true;
            }
            return true;
        }

        public ArrayList<IResource> getIconResources() {
            return this.iconResources;
        }
    }

    private class WIDResourceVisitor
    implements IResourceVisitor {
        private ArrayList<IFile> widFiles = new ArrayList();

        private WIDResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            String name;
            if (resource.getType() == 1) {
                if ("conf".equalsIgnoreCase(((IFile)resource).getFileExtension()) || "wid".equalsIgnoreCase(((IFile)resource).getFileExtension())) {
                    this.widFiles.add((IFile)resource);
                    return true;
                }
            } else if (resource.getType() == 2 && ("bin".equals(name = resource.getName()) || "target".equals(name))) {
                return false;
            }
            return true;
        }

        public ArrayList<IFile> getWIDFiles() {
            return this.widFiles;
        }
    }
}

