/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.version.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.DesignerSPIPlugin;
import org.teiid.designer.Messages;
import org.teiid.designer.runtime.registry.TeiidRuntimeRegistry;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;

public class TeiidServerVersion
implements ITeiidServerVersion {
    private String versionString = "0.0.0";
    private final String majorVersion;
    private String minorVersion = "x";
    private String microVersion = "x";

    public TeiidServerVersion(String major, String minor, String micro) {
        if (major == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.valueCannotBeNull, (Object)"major"));
        }
        if (minor == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.valueCannotBeNull, (Object)"minor"));
        }
        if (micro == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.valueCannotBeNull, (Object)"micro"));
        }
        this.majorVersion = major;
        this.minorVersion = minor;
        this.microVersion = micro;
        this.versionString = String.valueOf(major) + "." + minor + "." + micro;
    }

    public TeiidServerVersion(String versionString) {
        this.versionString = versionString;
        String[] tokens = versionString.split("\\.");
        if (tokens.length >= 3) {
            this.majorVersion = tokens[0];
            this.minorVersion = tokens[1];
            if (tokens[2] != null) {
                int dashIndex = tokens[2].indexOf(45);
                this.microVersion = dashIndex != -1 && tokens[2].length() > 0 ? tokens[2].substring(0, dashIndex) : tokens[2];
            }
        } else if (tokens.length == 2) {
            this.majorVersion = tokens[0];
            this.minorVersion = tokens[1];
        } else {
            this.majorVersion = tokens[0];
        }
        this.versionString = String.valueOf(this.majorVersion) + "." + this.minorVersion + "." + this.microVersion;
    }

    public static ITeiidServerVersion deriveUltimateDefaultServerVersion() {
        ITeiidServerVersion lastTestedDefault = Version.TEIID_DEFAULT.get();
        Collection<ITeiidServerVersion> serverVersions = null;
        try {
            serverVersions = TeiidRuntimeRegistry.getInstance().getRegisteredServerVersions();
        }
        catch (Exception ex) {
            DesignerSPIPlugin.log(ex);
            return lastTestedDefault;
        }
        if (serverVersions == null || serverVersions.isEmpty()) {
            return lastTestedDefault;
        }
        if (serverVersions.size() == 1) {
            return serverVersions.iterator().next();
        }
        ArrayList<String> items = new ArrayList<String>(serverVersions.size());
        for (ITeiidServerVersion serverVersion : serverVersions) {
            if (serverVersion.isGreaterThan(lastTestedDefault)) continue;
            items.add(serverVersion.toString());
        }
        Collections.sort(items, Collections.reverseOrder());
        return new TeiidServerVersion((String)items.get(0));
    }

    public String toString() {
        return this.versionString;
    }

    @Override
    public String getMajor() {
        return this.majorVersion;
    }

    @Override
    public String getMinor() {
        return this.minorVersion;
    }

    @Override
    public String getMicro() {
        return this.microVersion;
    }

    @Override
    public boolean hasWildCards() {
        return this.majorVersion.equals("x") || this.minorVersion.equals("x") || this.microVersion.equals("x");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.majorVersion == null ? 0 : this.majorVersion.hashCode());
        result = 31 * result + (this.microVersion == null ? 0 : this.microVersion.hashCode());
        result = 31 * result + (this.minorVersion == null ? 0 : this.minorVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TeiidServerVersion other = (TeiidServerVersion)obj;
        if (this.majorVersion == null ? other.majorVersion != null : !this.majorVersion.equals(other.majorVersion)) {
            return false;
        }
        if (this.microVersion == null ? other.microVersion != null : !this.microVersion.equals(other.microVersion)) {
            return false;
        }
        return !(this.minorVersion == null ? other.minorVersion != null : !this.minorVersion.equals(other.minorVersion));
    }

    @Override
    public boolean compareTo(ITeiidServerVersion otherVersion) {
        String entryMajor = otherVersion.getMajor();
        if (!(this.getMajor().equals(entryMajor) || this.getMajor().equals("x") || entryMajor.equals("x"))) {
            return false;
        }
        String entryMinor = otherVersion.getMinor();
        if (!(this.getMinor().equals(entryMinor) || this.getMinor().equals("x") || entryMinor.equals("x"))) {
            return false;
        }
        String entryMicro = otherVersion.getMicro();
        return this.getMicro().equals(entryMicro) || this.getMicro().equals("x") || entryMicro.equals("x");
    }

    @Override
    public boolean isSevenServer() {
        return "7".equals(this.getMajor());
    }

    @Override
    public ITeiidServerVersion getMinimumVersion() {
        if (!this.hasWildCards()) {
            return this;
        }
        String major = this.getMajor().equals("x") ? "7" : this.getMajor();
        String minor = this.getMinor().equals("x") ? "0" : this.getMinor();
        String micro = this.getMicro().equals("x") ? "0" : this.getMicro();
        return new TeiidServerVersion(major, minor, micro);
    }

    @Override
    public ITeiidServerVersion getMaximumVersion() {
        if (!this.hasWildCards()) {
            return this;
        }
        String major = this.getMajor().equals("x") ? "9" : this.getMajor();
        String minor = this.getMinor().equals("x") ? "9" : this.getMinor();
        String micro = this.getMicro().equals("x") ? "9" : this.getMicro();
        return new TeiidServerVersion(major, minor, micro);
    }

    @Override
    public boolean isGreaterThan(ITeiidServerVersion otherVersion) {
        ITeiidServerVersion myMaxVersion = this.getMaximumVersion();
        ITeiidServerVersion otherMinVersion = otherVersion.getMinimumVersion();
        int majCompResult = myMaxVersion.getMajor().compareTo(otherMinVersion.getMajor());
        if (majCompResult > 0) {
            return true;
        }
        int minCompResult = myMaxVersion.getMinor().compareTo(otherMinVersion.getMinor());
        if (majCompResult == 0 && minCompResult > 0) {
            return true;
        }
        int micCompResult = myMaxVersion.getMicro().compareTo(otherMinVersion.getMicro());
        return majCompResult == 0 && minCompResult == 0 && micCompResult > 0;
    }

    @Override
    public boolean isLessThan(ITeiidServerVersion otherVersion) {
        ITeiidServerVersion myMaxVersion = this.getMaximumVersion();
        ITeiidServerVersion otherMinVersion = otherVersion.getMinimumVersion();
        int majCompResult = myMaxVersion.getMajor().compareTo(otherMinVersion.getMajor());
        if (majCompResult < 0) {
            return true;
        }
        int minCompResult = myMaxVersion.getMinor().compareTo(otherMinVersion.getMinor());
        if (majCompResult == 0 && minCompResult < 0) {
            return true;
        }
        int micCompResult = myMaxVersion.getMicro().compareTo(otherMinVersion.getMicro());
        return majCompResult == 0 && minCompResult == 0 && micCompResult < 0;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(ITeiidServerVersion otherVersion) {
        return this.compareTo(otherVersion) || this.isGreaterThan(otherVersion);
    }

    @Override
    public boolean isLessThanOrEqualTo(ITeiidServerVersion otherVersion) {
        return this.compareTo(otherVersion) || this.isLessThan(otherVersion);
    }

    public static enum Version {
        TEIID_7_7(ITeiidServerVersion.VersionID.TEIID_7_7),
        TEIID_8_0(ITeiidServerVersion.VersionID.TEIID_8_0),
        TEIID_8_1(ITeiidServerVersion.VersionID.TEIID_8_1),
        TEIID_8_2(ITeiidServerVersion.VersionID.TEIID_8_2),
        TEIID_8_3(ITeiidServerVersion.VersionID.TEIID_8_3),
        TEIID_8_4(ITeiidServerVersion.VersionID.TEIID_8_4),
        TEIID_8_5(ITeiidServerVersion.VersionID.TEIID_8_5),
        TEIID_8_6(ITeiidServerVersion.VersionID.TEIID_8_6),
        TEIID_8_7(ITeiidServerVersion.VersionID.TEIID_8_7),
        TEIID_8_8(ITeiidServerVersion.VersionID.TEIID_8_7),
        TEIID_DEFAULT(ITeiidServerVersion.VersionID.TEIID_8_8);

        private final ITeiidServerVersion version;

        private Version(ITeiidServerVersion.VersionID id) {
            this.version = new TeiidServerVersion(id.toString());
        }

        public ITeiidServerVersion get() {
            return this.version;
        }
    }
}

