/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.spi;

import org.eclipse.osgi.util.NLS;
import org.teiid.designer.Messages;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidTranslator;

public final class ExecutionConfigurationEvent {
    private final EventType eventType;
    private final TargetType targetType;
    private final Object target;
    private final Object updatedTarget;

    public static ExecutionConfigurationEvent createAddDataSourceEvent(ITeiidDataSource dataSource) {
        return new ExecutionConfigurationEvent(EventType.ADD, TargetType.DATA_SOURCE, dataSource);
    }

    public static ExecutionConfigurationEvent createAddServerEvent(ITeiidServer teiidServer) {
        return new ExecutionConfigurationEvent(EventType.ADD, TargetType.SERVER, teiidServer);
    }

    public static ExecutionConfigurationEvent createDeployVDBEvent(String vdbName) {
        return new ExecutionConfigurationEvent(EventType.ADD, TargetType.VDB, vdbName);
    }

    public static ExecutionConfigurationEvent createRemoveDataSourceEvent(ITeiidDataSource dataSource) {
        return new ExecutionConfigurationEvent(EventType.REMOVE, TargetType.DATA_SOURCE, dataSource);
    }

    public static ExecutionConfigurationEvent createRemoveServerEvent(ITeiidServer teiidServer) {
        return new ExecutionConfigurationEvent(EventType.REMOVE, TargetType.SERVER, teiidServer);
    }

    public static ExecutionConfigurationEvent createServerRefreshEvent(ITeiidServer teiidServer) {
        return new ExecutionConfigurationEvent(EventType.REFRESH, TargetType.SERVER, teiidServer);
    }

    public static ExecutionConfigurationEvent createServerConnectedEvent(ITeiidServer teiidServer) {
        return new ExecutionConfigurationEvent(EventType.CONNECTED, TargetType.SERVER, teiidServer);
    }

    public static ExecutionConfigurationEvent createSetDefaultServerEvent(ITeiidServer oldDefaultServer, ITeiidServer newDefaultServer) {
        return new ExecutionConfigurationEvent(EventType.DEFAULT, TargetType.SERVER, oldDefaultServer, newDefaultServer);
    }

    public static ExecutionConfigurationEvent createUnDeployVDBEvent(String vdbName) {
        return new ExecutionConfigurationEvent(EventType.REMOVE, TargetType.VDB, vdbName);
    }

    public static ExecutionConfigurationEvent createUpdateDataSourceEvent(ITeiidDataSource dataSource) {
        return new ExecutionConfigurationEvent(EventType.UPDATE, TargetType.DATA_SOURCE, dataSource);
    }

    public static ExecutionConfigurationEvent createUpdateServerEvent(ITeiidServer teiidServer, ITeiidServer updatedServer) {
        return new ExecutionConfigurationEvent(EventType.UPDATE, TargetType.SERVER, teiidServer, updatedServer);
    }

    private ExecutionConfigurationEvent(EventType eventType, TargetType targetType, Object target) {
        this(eventType, targetType, target, null);
        if (target == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.valueCannotBeNull, (Object)"target"));
        }
    }

    private ExecutionConfigurationEvent(EventType eventType, TargetType targetType, Object target, Object updatedTarget) {
        assert (eventType != null);
        assert (targetType != null);
        this.eventType = eventType;
        this.targetType = targetType;
        this.target = target;
        this.updatedTarget = updatedTarget;
    }

    private ExecutionConfigurationEvent(TargetType targetType) {
        this(EventType.REFRESH, targetType, null, null);
    }

    public ITeiidDataSource getDataSource() {
        if (this.targetType != TargetType.DATA_SOURCE) {
            throw new IllegalStateException(NLS.bind((String)Messages.invalidTargetTypeForGetDataSourceMethod, (Object)((Object)this.targetType), (Object)((Object)TargetType.DATA_SOURCE)));
        }
        return (ITeiidDataSource)this.target;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public ITeiidServer getServer() {
        if (this.targetType != TargetType.SERVER) {
            throw new IllegalStateException(NLS.bind((String)Messages.invalidTargetTypeForGetServerMethod, (Object)((Object)this.targetType), (Object)((Object)TargetType.SERVER)));
        }
        return (ITeiidServer)this.target;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public ITeiidTranslator getTranslator() {
        if (this.targetType != TargetType.TRANSLATOR) {
            throw new IllegalStateException(NLS.bind((String)Messages.invalidTargetTypeForGetTranslatorMethod, (Object)((Object)this.targetType), (Object)((Object)TargetType.TRANSLATOR)));
        }
        return (ITeiidTranslator)this.target;
    }

    public ITeiidServer getUpdatedServer() {
        if (this.targetType != TargetType.SERVER) {
            throw new IllegalStateException(NLS.bind((String)Messages.invalidTargetTypeForGetUpdatedServerMethod, (Object)((Object)this.targetType), (Object)((Object)TargetType.SERVER)));
        }
        return (ITeiidServer)this.updatedTarget;
    }

    public static enum EventType {
        ADD,
        CONNECTED,
        REFRESH,
        REMOVE,
        UPDATE,
        DEFAULT;

    }

    public static enum TargetType {
        TRANSLATOR,
        DATA_SOURCE,
        SERVER,
        VDB,
        SOURCE_BINDING;

    }
}

