/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.registry;

import java.sql.Driver;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.Messages;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.registry.AbstractExtensionRegistry;
import org.teiid.designer.runtime.spi.IExecutionAdmin;
import org.teiid.designer.runtime.spi.IExecutionAdminFactory;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.type.IDataTypeManagerService;

public class TeiidRuntimeRegistry
extends AbstractExtensionRegistry<ITeiidServerVersion, IExecutionAdminFactory> {
    private static final String EXT_POINT_ID = "org.teiid.designer.spi.teiidRuntimeClient";
    private static final String FACTORY_ID = "runtimeFactory";
    private static final String VERSION_ELEMENT_ID = "version";
    private static final String MAJOR_ATTRIBUTE_ID = "major";
    private static final String MINOR_ATTRIBUTE_ID = "minor";
    private static final String MICRO_ATTRIBUTE_ID = "micro";
    private static TeiidRuntimeRegistry registry;

    public static TeiidRuntimeRegistry getInstance() throws Exception {
        if (registry == null) {
            registry = new TeiidRuntimeRegistry();
        }
        return registry;
    }

    private TeiidRuntimeRegistry() throws Exception {
        super(EXT_POINT_ID, FACTORY_ID);
    }

    @Override
    protected void register(IConfigurationElement configurationElement, IExecutionAdminFactory adminFactory) {
        IConfigurationElement[] versions;
        IConfigurationElement[] iConfigurationElementArray = versions = configurationElement.getChildren(VERSION_ELEMENT_ID);
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement version = iConfigurationElementArray[n2];
            String major = version.getAttribute(MAJOR_ATTRIBUTE_ID);
            String minor = version.getAttribute(MINOR_ATTRIBUTE_ID);
            String micro = version.getAttribute(MICRO_ATTRIBUTE_ID);
            TeiidServerVersion serverVersion = new TeiidServerVersion(major, minor, micro);
            this.register(serverVersion, adminFactory);
            ++n2;
        }
    }

    public IExecutionAdminFactory getExecutionAdminFactory(ITeiidServerVersion teiidServerVersion) throws Exception {
        IExecutionAdminFactory factory = this.search(teiidServerVersion);
        if (factory == null) {
            throw new Exception(NLS.bind((String)Messages.NoExecutionAdminFactory, (Object)teiidServerVersion));
        }
        return factory;
    }

    public IExecutionAdmin getExecutionAdmin(ITeiidServer teiidServer) throws Exception {
        IExecutionAdminFactory factory = this.getExecutionAdminFactory(teiidServer.getServerVersion());
        return factory.createExecutionAdmin(teiidServer);
    }

    public IDataTypeManagerService getDataTypeManagerService(ITeiidServerVersion teiidServerVersion) throws Exception {
        IExecutionAdminFactory factory = this.search(teiidServerVersion);
        if (factory == null) {
            throw new Exception(NLS.bind((String)Messages.NoExecutionAdminFactory, (Object)teiidServerVersion));
        }
        return factory.getDataTypeManagerService(teiidServerVersion);
    }

    public Driver getTeiidDriver(ITeiidServerVersion teiidServerVersion) throws Exception {
        IExecutionAdminFactory factory = this.search(teiidServerVersion);
        if (factory == null) {
            throw new Exception(NLS.bind((String)Messages.NoExecutionAdminFactory, (Object)teiidServerVersion));
        }
        return factory.getTeiidDriver(teiidServerVersion);
    }

    public IQueryService getQueryService(ITeiidServerVersion teiidServerVersion) throws Exception {
        IExecutionAdminFactory factory = this.search(teiidServerVersion);
        if (factory == null) {
            throw new Exception(NLS.bind((String)Messages.NoExecutionAdminFactory, (Object)teiidServerVersion));
        }
        return factory.getQueryService(teiidServerVersion);
    }

    private IExecutionAdminFactory search(ITeiidServerVersion serverVersion) {
        IExecutionAdminFactory factory = (IExecutionAdminFactory)this.getRegistered(serverVersion);
        if (factory != null) {
            return factory;
        }
        for (Map.Entry entry : this.getRegisteredEntries()) {
            ITeiidServerVersion entryVersion = (ITeiidServerVersion)entry.getKey();
            if (!serverVersion.compareTo(entryVersion)) continue;
            return (IExecutionAdminFactory)entry.getValue();
        }
        return null;
    }

    public Collection<ITeiidServerVersion> getRegisteredServerVersions() {
        return this.getRegisteredKeys();
    }
}

