/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.extension;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.extension.EmfModelObjectExtensionAssistant;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionConstants;

public class RestModelExtensionAssistant
extends EmfModelObjectExtensionAssistant {
    public void applyMedIfNecessary(IResource model) throws Exception {
        ModelResource modelResource;
        if (model != null && (modelResource = ModelerCore.getModelWorkspace().findModelResource(model)) != null && !modelResource.isReadOnly() && ModelType.VIRTUAL_LITERAL == modelResource.getModelType() && "http://www.metamatrix.com/metamodels/Relational".equals(modelResource.getPrimaryMetamodelUri()) && !this.supportsMyNamespace(model)) {
            this.saveModelExtensionDefinition(model);
        }
    }

    protected ModelExtensionPropertyDefinition getPropertyDefinition(Object modelObject, String propId) throws Exception {
        CoreArgCheck.isInstanceOf(EObject.class, (Object)modelObject);
        ModelExtensionPropertyDefinition propDefn = super.getPropertyDefinition(modelObject, propId);
        if (propDefn != null && modelObject instanceof Procedure && ModelUtil.isVirtual((Object)modelObject) && (RestModelExtensionConstants.PropertyIds.REST_METHOD.equals(propId) || RestModelExtensionConstants.PropertyIds.URI.equals(propId) || RestModelExtensionConstants.PropertyIds.CHARSET.equals(propId) || RestModelExtensionConstants.PropertyIds.HEADERS.equals(propId))) {
            return propDefn;
        }
        return null;
    }

    public boolean supportsMedOperation(String proposedOperationName, Object context) {
        return "SHOW_IN_REGISTRY".equals(proposedOperationName);
    }

    private static RestModelExtensionAssistant getRestAssistant() {
        ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
        String prefix = RestModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix();
        return (RestModelExtensionAssistant)registry.getModelExtensionAssistant(prefix);
    }

    public static boolean setRestProperties(EObject procedure, String restMethod, String restUri, String restCharSet, String restHeaders) {
        RestModelExtensionAssistant assistant = RestModelExtensionAssistant.getRestAssistant();
        if (assistant != null) {
            try {
                assistant.setPropertyValue(procedure, RestModelExtensionConstants.PropertyIds.URI, restUri);
                assistant.setPropertyValue(procedure, RestModelExtensionConstants.PropertyIds.REST_METHOD, restMethod);
                assistant.setPropertyValue(procedure, RestModelExtensionConstants.PropertyIds.CHARSET, restCharSet);
                assistant.setPropertyValue(procedure, RestModelExtensionConstants.PropertyIds.HEADERS, restHeaders);
            }
            catch (Exception e) {
                RelationalPlugin.Util.log((Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static String getRestProperty(EObject procedure, String key) {
        String result = null;
        RestModelExtensionAssistant assistant = RestModelExtensionAssistant.getRestAssistant();
        if (assistant != null) {
            try {
                result = assistant.getPropertyValue(procedure, key);
            }
            catch (Exception e) {
                RelationalPlugin.Util.log((Throwable)e);
            }
        }
        return result;
    }
}

